/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.access.derby;

import com.googlecode.fascinator.access.derby.DerbySchema;
import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.access.AccessControl;
import com.googlecode.fascinator.api.access.AccessControlException;
import com.googlecode.fascinator.api.access.AccessControlSchema;
import com.googlecode.fascinator.common.JsonSimple;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyAccessControl
implements AccessControl {
    private final Logger log = LoggerFactory.getLogger(DerbyAccessControl.class);
    private static String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static String DERBY_PROTOCOL = "jdbc:derby:";
    private static String SECURITY_DATABASE = "tfsecurity";
    private static String RECORD_TABLE = "records";
    private static String ROLE_TABLE = "roles";
    private static String USER_TABLE = "users";
    private String derbyHome;
    private Connection connection;

    public String getId() {
        return "derby";
    }

    public String getName() {
        return "Derby Access Control";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(String jsonString) throws AccessControlException {
        try {
            this.setConfig(new JsonSimple(jsonString));
        }
        catch (IOException e) {
            throw new AccessControlException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws AccessControlException {
        try {
            this.setConfig(new JsonSimple(jsonFile));
        }
        catch (IOException ioe) {
            throw new AccessControlException((Throwable)ioe);
        }
    }

    private void setConfig(JsonSimple config) throws AccessControlException {
        this.derbyHome = config.getString(null, new Object[]{"database-service", "derbyHome"});
        String oldHome = System.getProperty("derby.system.home");
        if (oldHome != null) {
            if (this.derbyHome != null) {
                this.log.warn("Using previously specified data directory: '{}', provided value has been ignored: '{}'", (Object)oldHome, (Object)this.derbyHome);
            } else {
                this.log.info("Using existing data directory: '{}'", (Object)oldHome);
            }
        } else {
            if (this.derbyHome == null) {
                this.log.error("No database home directory configured!");
                return;
            }
            File file = new File(this.derbyHome);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new AccessControlException("Database home '" + this.derbyHome + "' is not a directory!");
                }
            } else {
                file.mkdirs();
                if (!file.exists()) {
                    throw new AccessControlException("Database home '" + this.derbyHome + "' does not exist and could not be created!");
                }
            }
            System.setProperty("derby.system.home", this.derbyHome);
        }
        try {
            this.checkTable(RECORD_TABLE);
            this.checkTable(ROLE_TABLE);
            this.checkTable(USER_TABLE);
        }
        catch (SQLException ex) {
            this.log.error("Error during database preparation:", (Throwable)ex);
            throw new AccessControlException("Error during database preparation:", (Throwable)ex);
        }
        this.log.debug("Derby security database online!");
    }

    private Connection connection() throws SQLException {
        if (this.connection == null || !this.connection.isValid(1)) {
            if (this.connection != null) {
                this.log.error("!!! Database connection has failed, recreating.");
                try {
                    this.connection.close();
                }
                catch (SQLException ex) {
                    this.log.error("Error closing invalid connection, ignoring: {}", (Object)ex.getMessage());
                }
            }
            Properties props = new Properties();
            try {
                Class.forName(DERBY_DRIVER).newInstance();
            }
            catch (Exception ex) {
                this.log.error("Driver load failed: ", (Throwable)ex);
                throw new SQLException("Driver load failed: ", ex);
            }
            this.connection = DriverManager.getConnection(DERBY_PROTOCOL + SECURITY_DATABASE + ";create=true", props);
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws AccessControlException {
        String threadedShutdownMessage = DERBY_DRIVER + " is not registered with the JDBC driver manager";
        try {
            DriverManager.getConnection(DERBY_PROTOCOL + ";shutdown=true");
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 50000 && ex.getSQLState().equals("XJ015")) {
            } else if (!ex.getMessage().equals(threadedShutdownMessage)) {
                this.log.error("Error during database shutdown:", (Throwable)ex);
                throw new AccessControlException("Error during database shutdown:", (Throwable)ex);
            }
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (SQLException ex) {
                this.log.error("Error closing connection:", (Throwable)ex);
            }
        }
    }

    public AccessControlSchema getEmptySchema() {
        return new DerbySchema();
    }

    public List<AccessControlSchema> getSchemas(String recordId) throws AccessControlException {
        try {
            DerbySchema schema;
            List<String> roles = this.searchRoles(recordId);
            if (roles == null || roles.isEmpty()) {
                return new ArrayList<AccessControlSchema>();
            }
            ArrayList<AccessControlSchema> schemas = new ArrayList<AccessControlSchema>();
            for (String role : roles) {
                schema = new DerbySchema();
                schema.init(recordId);
                schema.set("role", role);
                schemas.add((AccessControlSchema)schema);
            }
            List<String> users = this.searchUsers(recordId);
            if (users == null || users.isEmpty()) {
                return new ArrayList<AccessControlSchema>();
            }
            for (String user : users) {
                schema = new DerbySchema();
                schema.init(recordId);
                schema.set("user", user);
                schemas.add((AccessControlSchema)schema);
            }
            return schemas;
        }
        catch (Exception ex) {
            this.log.error("Error searching security database: ", (Throwable)ex);
            throw new AccessControlException("Error searching security database");
        }
    }

    public void applySchema(AccessControlSchema newSecurity) throws AccessControlException {
        String recordId = newSecurity.getRecordId();
        if (recordId == null || recordId.equals("")) {
            throw new AccessControlException("No record provided by schema.");
        }
        String role = newSecurity.get("role");
        if (role != null && !role.equals("")) {
            this.processRoleSchema(recordId, role);
            return;
        }
        String user = newSecurity.get("user");
        if (user != null && !user.equals("")) {
            this.processUserSchema(recordId, user);
            return;
        }
        this.log.error("Should have returned from applySchema:", (Object)newSecurity);
        throw new AccessControlException("No security role or user provided by schema.");
    }

    private void processUserSchema(String recordId, String user) throws AccessControlException {
        List<String> user_list;
        try {
            user_list = this.searchUsers(recordId);
        }
        catch (Exception ex) {
            this.log.error("Error searching security database: ", (Throwable)ex);
            throw new AccessControlException("Error searching security database");
        }
        if (user_list != null && user_list.contains(user)) {
            throw new AccessControlException("Duplicate! That user has already been applied to this record.");
        }
        try {
            if (user_list == null) {
                this.newRecord(recordId);
            }
            this.grantUserAccess(recordId, user);
        }
        catch (Exception ex) {
            this.log.error("Error updating security database: ", (Throwable)ex);
            throw new AccessControlException("Error updating security database");
        }
    }

    private void processRoleSchema(String recordId, String role) throws AccessControlException {
        List<String> role_list;
        try {
            role_list = this.searchRoles(recordId);
        }
        catch (Exception ex) {
            this.log.error("Error searching security database: ", (Throwable)ex);
            throw new AccessControlException("Error searching security database");
        }
        if (role_list != null && role_list.contains(role)) {
            throw new AccessControlException("Duplicate! That role has already been applied to this record.");
        }
        try {
            if (role_list == null) {
                this.newRecord(recordId);
            }
            this.grantRoleAccess(recordId, role);
        }
        catch (Exception ex) {
            this.log.error("Error updating security database: ", (Throwable)ex);
            throw new AccessControlException("Error updating security database");
        }
    }

    public void removeSchema(AccessControlSchema oldSecurity) throws AccessControlException {
        String recordId = oldSecurity.getRecordId();
        if (StringUtils.isBlank((String)recordId)) {
            throw new AccessControlException("No record provided by schema.");
        }
        String role = oldSecurity.get("role");
        if (!StringUtils.isBlank((String)role)) {
            this.removeRole(recordId, role);
            return;
        }
        String user = oldSecurity.get("user");
        if (!StringUtils.isBlank((String)user)) {
            this.removeUser(recordId, user);
            return;
        }
        throw new AccessControlException("No security role/user provided by schema.");
    }

    private void removeUser(String recordId, String user) throws AccessControlException {
        List<String> user_list;
        try {
            user_list = this.searchUsers(recordId);
        }
        catch (Exception ex) {
            this.log.error("Error searching security database: ", (Throwable)ex);
            throw new AccessControlException("Error searching security database");
        }
        if (user_list == null || !user_list.contains(user)) {
            throw new AccessControlException("That user does not have access to this record.");
        }
        try {
            this.revokeUserAccess(recordId, user);
        }
        catch (Exception ex) {
            this.log.error("Error updating security database: ", (Throwable)ex);
            throw new AccessControlException("Error updating security database");
        }
    }

    private void removeRole(String recordId, String role) throws AccessControlException {
        List<String> role_list;
        try {
            role_list = this.searchRoles(recordId);
        }
        catch (Exception ex) {
            this.log.error("Error searching security database: ", (Throwable)ex);
            throw new AccessControlException("Error searching security database");
        }
        if (role_list == null || !role_list.contains(role)) {
            throw new AccessControlException("That role does not have access to this record.");
        }
        try {
            this.revokeRoleAccess(recordId, role);
        }
        catch (Exception ex) {
            this.log.error("Error updating security database: ", (Throwable)ex);
            throw new AccessControlException("Error updating security database");
        }
    }

    public List<String> getUsers(String recordId) throws AccessControlException {
        try {
            return this.searchUsers(recordId);
        }
        catch (SQLException ex) {
            this.log.error("Error searching security database: ", (Throwable)ex);
            throw new AccessControlException("Error searching security database");
        }
    }

    public List<String> getRoles(String recordId) throws AccessControlException {
        try {
            return this.searchRoles(recordId);
        }
        catch (SQLException ex) {
            this.log.error("Error searching security database: ", (Throwable)ex);
            throw new AccessControlException("Error searching security database");
        }
    }

    public List<String> getPossibilities(String field) throws AccessControlException {
        throw new AccessControlException("Not supported by this plugin. Use any freetext role name.");
    }

    private void checkTable(String table) throws SQLException {
        boolean tableFound = this.findTable(table);
        if (!tableFound) {
            this.log.debug("Table '{}' not found, creating now!", (Object)table);
            this.createTable(table);
            if (!this.findTable(table)) {
                this.log.error("Unknown error creating table '{}'", (Object)table);
                throw new SQLException("Could not find or create table '" + table + "'");
            }
        }
    }

    private boolean findTable(String table) throws SQLException {
        boolean tableFound = false;
        DatabaseMetaData meta = this.connection().getMetaData();
        ResultSet result = meta.getTables(null, null, null, null);
        while (result.next() && !tableFound) {
            if (!result.getString("TABLE_NAME").equalsIgnoreCase(table)) continue;
            tableFound = true;
        }
        this.close(result);
        return tableFound;
    }

    private void createTable(String table) throws SQLException {
        if (table.equals(RECORD_TABLE)) {
            Statement sql = this.connection().createStatement();
            sql.execute("CREATE TABLE " + RECORD_TABLE + "(recordId VARCHAR(255) NOT NULL, " + "PRIMARY KEY (recordId))");
            this.close(sql);
            return;
        }
        if (table.equals(ROLE_TABLE)) {
            Statement sql = this.connection().createStatement();
            sql.execute("CREATE TABLE " + ROLE_TABLE + "(recordId VARCHAR(255) NOT NULL, " + "role VARCHAR(255) NOT NULL, " + "PRIMARY KEY (recordId, role))");
            this.close(sql);
            return;
        }
        if (table.equals(USER_TABLE)) {
            Statement sql = this.connection().createStatement();
            sql.execute("CREATE TABLE " + USER_TABLE + "(recordId VARCHAR(255) NOT NULL, " + "username VARCHAR(255) NOT NULL, " + "PRIMARY KEY (recordId, username))");
            this.close(sql);
            return;
        }
        throw new SQLException("Unknown table '" + table + "' requested!");
    }

    private void revokeRoleAccess(String recordId, String role) throws SQLException {
        PreparedStatement sql = this.connection().prepareStatement("DELETE FROM " + ROLE_TABLE + " WHERE recordId = ? AND role = ?");
        sql.setString(1, recordId);
        sql.setString(2, role);
        sql.executeUpdate();
        this.close(sql);
    }

    private void revokeUserAccess(String recordId, String user) throws SQLException {
        PreparedStatement sql = this.connection().prepareStatement("DELETE FROM " + USER_TABLE + " WHERE recordId = ? AND username = ?");
        sql.setString(1, recordId);
        sql.setString(2, user);
        sql.executeUpdate();
        this.close(sql);
    }

    private void grantRoleAccess(String recordId, String role) throws SQLException {
        PreparedStatement sql = this.connection().prepareStatement("INSERT INTO " + ROLE_TABLE + " VALUES (?, ?)");
        sql.setString(1, recordId);
        sql.setString(2, role);
        sql.executeUpdate();
        this.close(sql);
    }

    private void grantUserAccess(String recordId, String user) throws SQLException {
        PreparedStatement sql = this.connection().prepareStatement("INSERT INTO " + USER_TABLE + " VALUES (?, ?)");
        sql.setString(1, recordId);
        sql.setString(2, user);
        sql.executeUpdate();
        this.close(sql);
    }

    private void newRecord(String recordId) throws SQLException {
        PreparedStatement sql = this.connection().prepareStatement("INSERT INTO " + RECORD_TABLE + " VALUES (?)");
        sql.setString(1, recordId);
        sql.executeUpdate();
        this.close(sql);
    }

    private List<String> searchRoles(String recordId) throws SQLException {
        ArrayList<String> roles = new ArrayList<String>();
        PreparedStatement sql = this.connection().prepareStatement("SELECT * FROM " + ROLE_TABLE + " WHERE recordId = ?");
        sql.setString(1, recordId);
        ResultSet result = sql.executeQuery();
        while (result.next()) {
            roles.add(result.getString("role"));
        }
        this.close(result);
        this.close(sql);
        if (roles.isEmpty()) {
            if (this.checkRecord(recordId)) {
                return new ArrayList<String>();
            }
            return null;
        }
        return roles;
    }

    private List<String> searchUsers(String recordId) throws SQLException {
        ArrayList<String> roles = new ArrayList<String>();
        PreparedStatement sql = this.connection().prepareStatement("SELECT * FROM " + USER_TABLE + " WHERE recordId = ?");
        sql.setString(1, recordId);
        ResultSet result = sql.executeQuery();
        while (result.next()) {
            roles.add(result.getString("username"));
        }
        this.close(result);
        this.close(sql);
        if (roles.isEmpty()) {
            if (this.checkRecord(recordId)) {
                return new ArrayList<String>();
            }
            return null;
        }
        return roles;
    }

    private boolean checkRecord(String recordId) throws SQLException {
        PreparedStatement sql = this.connection().prepareStatement("SELECT count(*) as total FROM " + RECORD_TABLE + " WHERE recordId = ?");
        sql.setString(1, recordId);
        ResultSet result = sql.executeQuery();
        boolean response = false;
        if (result.next() && result.getInt("total") == 1) {
            response = true;
        }
        this.close(result);
        this.close(sql);
        return response;
    }

    private void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                this.log.error("Error closing result set: ", (Throwable)ex);
            }
        }
        resultSet = null;
    }

    private void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                this.log.error("Error closing statement: ", (Throwable)ex);
            }
        }
        statement = null;
    }
}

