/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.access.hibernate;

import com.googlecode.fascinator.access.hibernate.HibernateAccessSchema;
import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.access.AccessControl;
import com.googlecode.fascinator.api.access.AccessControlException;
import com.googlecode.fascinator.api.access.AccessControlSchema;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.model.Role;
import com.googlecode.fascinator.model.User;
import com.googlecode.fascinator.model.service.HibernateAccessControlService;
import com.googlecode.fascinator.spring.ApplicationContextProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateAccessControl
implements AccessControl {
    private final Logger log = LoggerFactory.getLogger(HibernateAccessControl.class);
    private JsonSimple config;
    private HibernateAccessControlService hibernateService;

    public String getId() {
        return "hibernateAccessControl";
    }

    public String getName() {
        return "Hibernate Access Control Plugin";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(File jsonFile) throws PluginException {
        try {
            this.setConfig(new JsonSimple(jsonFile));
        }
        catch (IOException ioe) {
            throw new AccessControlException((Throwable)ioe);
        }
    }

    public void init(String jsonString) throws PluginException {
        try {
            this.setConfig(new JsonSimple(jsonString));
        }
        catch (IOException ioe) {
            throw new AccessControlException((Throwable)ioe);
        }
    }

    private void setConfig(JsonSimple config) throws AccessControlException {
        this.log.debug("Access control getting config...");
        this.config = config;
        if (!ApplicationContextProvider.getApplicationContext().containsBean("hibernateAccessControlService")) {
            throw new AccessControlException("hibernateAccessControlService bean not available, please check your Spring configuration.");
        }
        this.hibernateService = (HibernateAccessControlService)ApplicationContextProvider.getApplicationContext().getBean("hibernateAccessControlService");
    }

    public void shutdown() throws PluginException {
        this.log.debug("Access control shutting down...");
    }

    public AccessControlSchema getEmptySchema() {
        return new HibernateAccessSchema();
    }

    public List<AccessControlSchema> getSchemas(String recordId) throws AccessControlException {
        this.log.debug("Getting schemas for:" + recordId);
        ArrayList<AccessControlSchema> schemas = new ArrayList<AccessControlSchema>();
        try {
            HibernateAccessSchema schema;
            List<Role> roles = this.hibernateService.getRoles(recordId);
            List<User> users = this.hibernateService.getUsers(recordId);
            if ((roles == null || roles.isEmpty()) && (users == null || users.isEmpty())) {
                return new ArrayList<AccessControlSchema>();
            }
            for (Role role : roles) {
                schema = new HibernateAccessSchema();
                schema.init(recordId);
                schema.set("role", role.getRole());
                schemas.add((AccessControlSchema)schema);
            }
            for (User user : users) {
                schema = new HibernateAccessSchema();
                schema.init(recordId);
                schema.set("user", user.getUsername());
                schemas.add((AccessControlSchema)schema);
            }
        }
        catch (Exception ex) {
            this.log.error("Error searching security database: ", (Throwable)ex);
            throw new AccessControlException("Error searching security database");
        }
        return schemas;
    }

    public void applySchema(AccessControlSchema newSecurity) throws AccessControlException {
        this.log.debug("Applying new schema...");
        String recordId = newSecurity.getRecordId();
        if (recordId == null || recordId.equals("")) {
            throw new AccessControlException("No record provided by schema.");
        }
        String role = newSecurity.get("role");
        if (role != null && !role.equals("")) {
            this.processRoleSchema(recordId, role);
            return;
        }
        String user = newSecurity.get("user");
        if (user != null && !user.equals("")) {
            this.processUserSchema(recordId, user);
            return;
        }
        this.log.error("Should have returned from applySchema:", (Object)newSecurity);
        throw new AccessControlException("No security role or user provided by schema.");
    }

    private void processUserSchema(String recordId, String username) throws AccessControlException {
        List<User> users = this.hibernateService.getUsers(recordId);
        for (User user : users) {
            if (!user.getUsername().equalsIgnoreCase(username)) continue;
            throw new AccessControlException("Duplicate! That user has already been applied to this record.");
        }
        if (users.isEmpty()) {
            this.hibernateService.createOrGetRecord(recordId);
        }
        this.hibernateService.grantUserAccess(recordId, username);
    }

    private void processRoleSchema(String recordId, String role) throws AccessControlException {
        List<Role> roles = this.hibernateService.getRoles(recordId);
        for (Role curRole : roles) {
            if (!curRole.getRole().equalsIgnoreCase(role)) continue;
            throw new AccessControlException("Duplicate! That role has already been applied to this record.");
        }
        if (roles.isEmpty()) {
            this.hibernateService.createOrGetRecord(recordId);
        }
        this.hibernateService.grantRoleAccess(recordId, role);
    }

    public void removeSchema(AccessControlSchema oldSecurity) throws AccessControlException {
        this.log.debug("Removing schema...");
        String recordId = oldSecurity.getRecordId();
        if (StringUtils.isBlank((String)recordId)) {
            throw new AccessControlException("No record provided by schema.");
        }
        String role = oldSecurity.get("role");
        if (!StringUtils.isBlank((String)role)) {
            this.removeRole(recordId, role);
            return;
        }
        String user = oldSecurity.get("user");
        if (!StringUtils.isBlank((String)user)) {
            this.removeUser(recordId, user);
            return;
        }
        throw new AccessControlException("No security role/user provided by schema.");
    }

    private void removeUser(String recordId, String user) throws AccessControlException {
        User curUser = this.hibernateService.getUser(recordId, user);
        if (curUser == null) {
            throw new AccessControlException("That user does not have access to this record.");
        }
        try {
            this.hibernateService.revokeUserAccess(curUser);
        }
        catch (Exception ex) {
            this.log.error("Error updating security database: ", (Throwable)ex);
            throw new AccessControlException("Error updating security database");
        }
    }

    private void removeRole(String recordId, String role) throws AccessControlException {
        Role curRole = this.hibernateService.getRole(recordId, role);
        if (curRole == null) {
            throw new AccessControlException("That role does not have access to this record.");
        }
        try {
            this.hibernateService.revokeRoleAccess(curRole);
        }
        catch (Exception ex) {
            this.log.error("Error updating security database: ", (Throwable)ex);
            throw new AccessControlException("Error updating security database");
        }
    }

    public List<String> getRoles(String recordId) throws AccessControlException {
        this.log.debug("Getting roles...");
        ArrayList<String> role_list = new ArrayList<String>();
        List<Role> roles = this.hibernateService.getRoles(recordId);
        for (Role role : roles) {
            role_list.add(role.getRole());
        }
        return role_list;
    }

    public List<String> getUsers(String recordId) throws AccessControlException {
        this.log.debug("Getting users...");
        ArrayList<String> user_list = new ArrayList<String>();
        List<User> users = this.hibernateService.getUsers(recordId);
        for (User user : users) {
            user_list.add(user.getUsername());
        }
        return user_list;
    }

    public List<String> getPossibilities(String field) throws AccessControlException {
        throw new AccessControlException("Not supported by this plugin. Use any freetext role name.");
    }
}

