/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.model.service;

import com.googlecode.fascinator.dao.GenericDao;
import com.googlecode.fascinator.model.Record;
import com.googlecode.fascinator.model.Role;
import com.googlecode.fascinator.model.User;
import com.googlecode.fascinator.model.pk.RolePk;
import com.googlecode.fascinator.model.pk.UserPk;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="hibernateAccessControlService")
public class HibernateAccessControlService {
    private final Logger log = LoggerFactory.getLogger(HibernateAccessControlService.class);
    @Autowired
    private GenericDao<User, UserPk> userDao;
    @Autowired
    private GenericDao<Role, RolePk> roleDao;
    @Autowired
    private GenericDao<Record, String> recordDao;

    public Role getRole(String recordId, String role) {
        return (Role)this.roleDao.get((Serializable)new RolePk(recordId, role));
    }

    public User getUser(String recordId, String username) {
        return (User)this.userDao.get((Serializable)new UserPk(recordId, username));
    }

    @Transactional
    public List<Role> getRoles(String recordId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("recordId", recordId);
        return this.roleDao.query("getRoles", params);
    }

    @Transactional
    public List<User> getUsers(String recordId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("recordId", recordId);
        return this.userDao.query("getUsers", params);
    }

    public Record createOrGetRecord(String recordId) {
        Record oldRec = this.getRecord(recordId);
        if (oldRec != null) {
            return oldRec;
        }
        Record newRec = new Record(recordId);
        this.recordDao.create((Object)newRec);
        return newRec;
    }

    public Record getRecord(String recordId) {
        return (Record)this.recordDao.get((Serializable)((Object)recordId));
    }

    public User grantUserAccess(String recordId, String username) {
        User user = new User(recordId, username);
        this.userDao.create((Object)user);
        return user;
    }

    @Transactional
    public Role grantRoleAccess(String recordId, String role) {
        Role newRole = new Role(recordId, role);
        this.roleDao.create((Object)newRole);
        return newRole;
    }

    @Transactional
    public void revokeUserAccess(User user) {
        this.userDao.delete((Object)user);
    }

    @Transactional
    public void revokeRoleAccess(Role role) {
        this.roleDao.delete((Object)role);
    }
}

