/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.authentication.internal;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.authentication.Authentication;
import com.googlecode.fascinator.api.authentication.AuthenticationException;
import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.authentication.internal.InternalUser;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalAuthentication
implements Authentication {
    private static String DEFAULT_FILE_NAME = "users.properties";
    private final Logger log = LoggerFactory.getLogger(InternalAuthentication.class);
    private InternalUser user_object;
    private String file_path;
    private Properties file_store;

    public String getId() {
        return "internal";
    }

    public String getName() {
        return "Internal Authentication";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(String jsonString) throws AuthenticationException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonString));
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationException((Throwable)e);
        }
        catch (IOException e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws AuthenticationException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonFile));
        }
        catch (IOException ioe) {
            throw new AuthenticationException((Throwable)ioe);
        }
    }

    private void setConfig(JsonSimpleConfig config) throws IOException {
        this.user_object = new InternalUser();
        this.file_path = config.getString(null, new Object[]{"authentication", "internal", "path"});
        this.loadUsers();
    }

    private void loadUsers() throws IOException {
        this.file_store = new Properties();
        try {
            File user_file = new File(this.file_path);
            if (!user_file.exists()) {
                user_file.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(user_file);
                IOUtils.copy((InputStream)this.getClass().getResourceAsStream("/" + DEFAULT_FILE_NAME), (OutputStream)out);
                ((OutputStream)out).close();
            }
            this.file_store.load(new FileInputStream(this.file_path));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void saveUsers() throws IOException {
        if (this.file_store != null) {
            try {
                this.file_store.store(new FileOutputStream(this.file_path), "");
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private String encryptPassword(String password) throws AuthenticationException {
        byte[] passwordBytes = password.getBytes();
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(passwordBytes);
            byte[] messageDigest = algorithm.digest();
            BigInteger number = new BigInteger(1, messageDigest);
            password = number.toString(16);
            if (password.length() == 31) {
                password = "0" + password;
            }
        }
        catch (Exception e) {
            throw new AuthenticationException("Internal password encryption failure: " + e.getMessage());
        }
        return password;
    }

    public void shutdown() throws AuthenticationException {
    }

    public User logIn(String username, String password) throws AuthenticationException {
        String uPwd = this.file_store.getProperty(username);
        if (uPwd == null) {
            throw new AuthenticationException("User '" + username + "' not found.");
        }
        String ePwd = this.encryptPassword(password);
        if (ePwd.equals(uPwd)) {
            return this.getUser(username);
        }
        throw new AuthenticationException("Invalid password.");
    }

    public void logOut(User user) throws AuthenticationException {
    }

    public boolean supportsUserManagement() {
        return true;
    }

    public String describeUser() {
        return this.user_object.describeMetadata();
    }

    public User createUser(String username, String password) throws AuthenticationException {
        String user = this.file_store.getProperty(username);
        if (user != null) {
            throw new AuthenticationException("User '" + username + "' already exists.");
        }
        String ePwd = this.encryptPassword(password);
        this.file_store.put(username, ePwd);
        try {
            this.saveUsers();
        }
        catch (IOException e) {
            throw new AuthenticationException("Error changing password: ", (Throwable)e);
        }
        return this.getUser(username);
    }

    public void deleteUser(String username) throws AuthenticationException {
        String user = this.file_store.getProperty(username);
        if (user == null) {
            throw new AuthenticationException("User '" + username + "' not found.");
        }
        this.file_store.remove(username);
        try {
            this.saveUsers();
        }
        catch (IOException e) {
            throw new AuthenticationException("Error deleting user: ", (Throwable)e);
        }
    }

    public void changePassword(String username, String password) throws AuthenticationException {
        String user = this.file_store.getProperty(username);
        if (user == null) {
            throw new AuthenticationException("User '" + username + "' not found.");
        }
        String ePwd = this.encryptPassword(password);
        this.file_store.put(username, ePwd);
        try {
            this.saveUsers();
        }
        catch (IOException e) {
            throw new AuthenticationException("Error changing password: ", (Throwable)e);
        }
    }

    public User modifyUser(String username, String property, String newValue) throws AuthenticationException {
        throw new AuthenticationException("This class does not support user modification.");
    }

    public User modifyUser(String username, String property, int newValue) throws AuthenticationException {
        throw new AuthenticationException("This class does not support user modification.");
    }

    public User modifyUser(String username, String property, boolean newValue) throws AuthenticationException {
        throw new AuthenticationException("This class does not support user modification.");
    }

    public User getUser(String username) throws AuthenticationException {
        String user = this.file_store.getProperty(username);
        if (user == null) {
            throw new AuthenticationException("User '" + username + "' not found.");
        }
        this.user_object = new InternalUser();
        this.user_object.init(username);
        return this.user_object;
    }

    public List<User> searchUsers(String search) throws AuthenticationException {
        String[] users = this.file_store.keySet().toArray(new String[this.file_store.size()]);
        ArrayList<User> found = new ArrayList<User>();
        for (int i = 0; i < users.length; ++i) {
            if (!users[i].toLowerCase().contains(search.toLowerCase())) continue;
            found.add(this.getUser(users[i]));
        }
        return found;
    }
}

