/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.authentication.ldap;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.authentication.Authentication;
import com.googlecode.fascinator.api.authentication.AuthenticationException;
import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.authentication.ldap.LDAPUser;
import com.googlecode.fascinator.authentication.ldap.LdapAuthenticationHandler;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPAuthentication
implements Authentication {
    private final Logger log = LoggerFactory.getLogger(LDAPAuthentication.class);
    private LDAPUser user_object;
    private LdapAuthenticationHandler ldapAuth;

    public String getId() {
        return "ldap";
    }

    public String getName() {
        return "LDAP Authentication";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(String jsonString) throws AuthenticationException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonString));
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationException((Throwable)e);
        }
        catch (IOException e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws AuthenticationException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonFile));
        }
        catch (IOException ioe) {
            throw new AuthenticationException((Throwable)ioe);
        }
    }

    private void setConfig(JsonSimpleConfig config) throws IOException {
        this.user_object = new LDAPUser();
        String url = config.getString(null, new Object[]{"authentication", "ldap", "baseURL"});
        String baseDN = config.getString(null, new Object[]{"authentication", "ldap", "baseDN"});
        String idAttribute = config.getString(null, new Object[]{"authentication", "ldap", "idAttribute"});
        this.ldapAuth = new LdapAuthenticationHandler(url, baseDN, "objectClass", idAttribute);
    }

    public void shutdown() throws AuthenticationException {
    }

    public User logIn(String username, String password) throws AuthenticationException {
        if (this.ldapAuth.authenticate(username, password)) {
            return this.getUser(username);
        }
        throw new AuthenticationException("Invalid password or username.");
    }

    public void logOut(User user) throws AuthenticationException {
    }

    public boolean supportsUserManagement() {
        return false;
    }

    public String describeUser() {
        return this.user_object.describeMetadata();
    }

    public User createUser(String username, String password) throws AuthenticationException {
        throw new AuthenticationException("Cannot create a new LDAP user.");
    }

    public void deleteUser(String username) throws AuthenticationException {
        throw new AuthenticationException("Cannot delete an LDAP user.");
    }

    public void changePassword(String username, String password) throws AuthenticationException {
        throw new AuthenticationException("Cannot change password in LDAP.");
    }

    public User modifyUser(String username, String property, String newValue) throws AuthenticationException {
        throw new AuthenticationException("This class does not support user modification.");
    }

    public User modifyUser(String username, String property, int newValue) throws AuthenticationException {
        throw new AuthenticationException("This class does not support user modification.");
    }

    public User modifyUser(String username, String property, boolean newValue) throws AuthenticationException {
        throw new AuthenticationException("This class does not support user modification.");
    }

    public User getUser(String username) throws AuthenticationException {
        this.user_object = new LDAPUser();
        String cn = this.ldapAuth.getAttr(username, "cn");
        if (cn.equals("")) {
            this.user_object.init(username);
        } else {
            this.user_object.init(username, cn);
        }
        return this.user_object;
    }

    public List<User> searchUsers(String search) throws AuthenticationException {
        ArrayList<User> found = new ArrayList<User>();
        return found;
    }
}

