/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.authentication.ldap;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapAuthenticationHandler {
    private Logger log = LoggerFactory.getLogger(LdapAuthenticationHandler.class);
    private Hashtable<String, String> env;
    private String baseDn;
    private String ldapRoleAttr;
    private String idAttr;
    private String baseUrl;
    private String filterPrefix = "";
    private String filterSuffix = "";
    private Map<String, List<String>> ldapRolesMap;

    public LdapAuthenticationHandler(String baseUrl, String baseDn) {
        this(baseUrl, baseDn, "objectClass", "uid");
    }

    public LdapAuthenticationHandler(String baseUrl, String baseDn, String ldapRoleAttr, String idAttr) {
        this.baseDn = baseDn;
        this.idAttr = idAttr;
        this.ldapRoleAttr = ldapRoleAttr;
        this.baseUrl = baseUrl;
        this.env = new Hashtable();
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.provider.url", baseUrl);
        this.env.put("java.naming.security.authentication", "simple");
    }

    public LdapAuthenticationHandler(String baseUrl, String baseDn, String ldapRoleAttr, String idAttr, Map<String, List<String>> ldapRolesMap) {
        this(baseUrl, baseDn, ldapRoleAttr, idAttr);
        this.ldapRolesMap = ldapRolesMap;
    }

    public LdapAuthenticationHandler(String baseUrl, String baseDn, String ldapRoleAttr, String idAttr, String filterPrefix, String filterSuffix, Map<String, List<String>> ldapRolesMap) {
        this(baseUrl, baseDn, ldapRoleAttr, idAttr, ldapRolesMap);
        this.filterPrefix = filterPrefix;
        this.filterSuffix = filterSuffix;
    }

    private boolean doAuthenticate(String username, String password, String dn) {
        try {
            String principal = dn.equals("") ? String.format("%s=%s,%s", this.idAttr, username, this.baseDn) : dn;
            this.env.put("java.naming.security.principal", principal);
            this.env.put("java.naming.security.credentials", password);
            InitialDirContext ctx = new InitialDirContext(this.env);
            ctx.lookup(principal);
            ctx.close();
            return true;
        }
        catch (NamingException ne) {
            this.log.warn("Failed LDAP lookup", (Throwable)ne);
            return false;
        }
    }

    public boolean authenticate(String username, String password) {
        if (this.doAuthenticate(username, password, "")) {
            return true;
        }
        return this.doAuthenticate(username, password, this.getDN(username));
    }

    private String getDN(String username) {
        try {
            Hashtable<String, String> env1 = new Hashtable<String, String>();
            env1.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env1.put("java.naming.provider.url", this.baseUrl);
            env1.put("java.naming.security.authentication", "simple");
            InitialDirContext dc = new InitialDirContext(env1);
            SearchControls sc = new SearchControls();
            sc.setSearchScope(2);
            String filter = "(" + this.filterPrefix + this.idAttr + "=" + username + this.filterSuffix + ")";
            NamingEnumeration<SearchResult> ne = dc.search(this.baseDn, filter, sc);
            this.log.trace(String.format("LDAP search, baseDn: %s, filter: %s", this.baseDn, filter));
            if (ne.hasMore()) {
                SearchResult sr = ne.next();
                ne.close();
                dc.close();
                return sr.getNameInNamespace();
            }
            ne.close();
            dc.close();
        }
        catch (NamingException ne) {
            this.log.warn("Failed LDAP lookup", (Throwable)ne);
        }
        return "";
    }

    private NamingEnumeration<SearchResult> performLdapSearch(String username, DirContext dc) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        String filter = "(" + this.filterPrefix + this.idAttr + "=" + username + this.filterSuffix + ")";
        NamingEnumeration<SearchResult> ne = dc.search(this.baseDn, filter, sc);
        this.log.trace(String.format("performing LDAP search using baseDn: %s, filter: %s", this.baseDn, filter));
        return ne;
    }

    private String getAttrValue(String attrName, SearchResult sr) throws NamingException {
        Attributes entry = sr.getAttributes();
        Attribute attrValues = entry.get(attrName);
        String[] strArr = attrValues.toString().split(":");
        return strArr[1].trim();
    }

    public String getAttr(String username, String attrName) {
        String val = "";
        try {
            InitialDirContext dc = new InitialDirContext(this.env);
            NamingEnumeration<SearchResult> ne = this.performLdapSearch(username, dc);
            if (ne.hasMore()) {
                val = this.getAttrValue(attrName, ne.next());
            }
            ne.close();
            dc.close();
        }
        catch (NamingException ne) {
            this.log.warn("Failed LDAP lookup", (Throwable)ne);
        }
        this.log.trace(String.format("getAttr search result: %s", val));
        return val;
    }

    public List<String> getAllAttrs(String username, String attrName) {
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            InitialDirContext dc = new InitialDirContext(this.env);
            NamingEnumeration<SearchResult> ne = this.performLdapSearch(username, dc);
            while (ne.hasMore()) {
                resultList.add(this.getAttrValue(attrName, ne.next()));
            }
            ne.close();
            dc.close();
        }
        catch (NamingException ne) {
            this.log.warn("Failed LDAP lookup", (Throwable)ne);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("getAllAttrs search result: " + resultList);
        }
        return resultList;
    }

    public boolean testIfInObjectClass(String username, String testSubj) {
        try {
            List<String> attrValues = this.getAllAttrs(username, this.ldapRoleAttr);
            for (String attrValue : attrValues) {
                String[] allVals = attrValue.split(",");
                for (int i = 0; i < allVals.length; ++i) {
                    if (!testSubj.equals(allVals[i].trim())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public List<String> getRoles(String username) {
        LinkedHashSet<String> roles = new LinkedHashSet<String>();
        List<String> attrValues = this.getAllAttrs(username, this.ldapRoleAttr);
        for (String attrValue : attrValues) {
            String[] allVals;
            for (String objectClass : allVals = attrValue.split(",")) {
                List<String> roleList = this.ldapRolesMap.get(objectClass.trim());
                if (roleList == null) continue;
                roles.addAll(roleList);
            }
        }
        this.log.trace(String.format("getRoles found %d roles for username: %s", roles.size(), username));
        return new ArrayList<String>(roles);
    }
}

