/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.authentication.ldap;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.authentication.Authentication;
import com.googlecode.fascinator.api.authentication.AuthenticationException;
import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.authentication.ldap.LDAPUser;
import com.googlecode.fascinator.authentication.ldap.LdapAuthenticationHandler;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPAuthentication
implements Authentication {
    private final Logger log = LoggerFactory.getLogger(LDAPAuthentication.class);
    private LDAPUser user_object;
    private LdapAuthenticationHandler ldapAuth;
    private List<String> userAttributes;
    private List<String> displayNameAttributes;
    private String displayNameDelimiter;
    private boolean useSystemCredForAttributes;
    private HashMap<String, LDAPUser> userCache;

    public String getId() {
        return "ldap";
    }

    public String getName() {
        return "LDAP Authentication";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(String jsonString) throws AuthenticationException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonString));
        }
        catch (UnsupportedEncodingException e) {
            throw new AuthenticationException((Throwable)e);
        }
        catch (IOException e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws AuthenticationException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonFile));
        }
        catch (IOException ioe) {
            throw new AuthenticationException((Throwable)ioe);
        }
    }

    private void setConfig(JsonSimpleConfig config) throws IOException {
        this.log.debug("Loading the LDAP plugin");
        this.user_object = new LDAPUser();
        String url = config.getString(null, new Object[]{"authentication", "ldap", "baseURL"});
        String baseDN = config.getString(null, new Object[]{"authentication", "ldap", "baseDN"});
        String idAttribute = config.getString(null, new Object[]{"authentication", "ldap", "idAttribute"});
        String secPrinc = config.getString(null, new Object[]{"authentication", "ldap", "ldapSecurityPrincipal"});
        String secCreds = config.getString(null, new Object[]{"authentication", "ldap", "ldapSecurityCredentials"});
        this.userAttributes = config.getStringList(new Object[]{"authentication", "ldap", "userAttributes"});
        this.displayNameAttributes = config.getStringList(new Object[]{"authentication", "ldap", "displayNameAttributes"});
        this.displayNameDelimiter = config.getString(" ", new Object[]{"authentication", "ldap", "displayNameDelimiter"});
        this.useSystemCredForAttributes = config.getBoolean(new Boolean(false), new Object[]{"authentication", "ldap", "useSystemCredForAttributes"});
        this.ldapAuth = new LdapAuthenticationHandler(url, baseDN, secPrinc, secCreds, "objectClass", idAttribute);
        this.userCache = new HashMap();
        this.log.debug("Finished loading the LDAP plugin");
    }

    public void shutdown() throws AuthenticationException {
    }

    public User logIn(String username, String password) throws AuthenticationException {
        this.log.debug("Attempting to login via LDAP username: " + username);
        if (this.ldapAuth.authenticate(username, password)) {
            LDAPUser user = (LDAPUser)this.getCustomAttributes((LDAPUser)this.getUser(username));
            this.userCache.put(user.getUsername(), user);
            return user;
        }
        throw new AuthenticationException("Invalid password or username.");
    }

    public void logOut(User user) throws AuthenticationException {
        if (user instanceof LDAPUser) {
            String username = ((LDAPUser)user).getUsername();
            this.log.info("User logged out, removed from user cache:" + username);
            this.userCache.remove(username);
        } else {
            this.log.info("User logged out, but not an LDAPUser, doing nothing.");
        }
    }

    public boolean supportsUserManagement() {
        return false;
    }

    public String describeUser() {
        return this.user_object.describeMetadata();
    }

    public User createUser(String username, String password) throws AuthenticationException {
        throw new AuthenticationException("Cannot create a new LDAP user.");
    }

    public void deleteUser(String username) throws AuthenticationException {
        throw new AuthenticationException("Cannot delete an LDAP user.");
    }

    public void changePassword(String username, String password) throws AuthenticationException {
        throw new AuthenticationException("Cannot change password in LDAP.");
    }

    public User modifyUser(String username, String property, String newValue) throws AuthenticationException {
        throw new AuthenticationException("This class does not support user modification.");
    }

    public User modifyUser(String username, String property, int newValue) throws AuthenticationException {
        throw new AuthenticationException("This class does not support user modification.");
    }

    public User modifyUser(String username, String property, boolean newValue) throws AuthenticationException {
        throw new AuthenticationException("This class does not support user modification.");
    }

    public User getUser(String username) throws AuthenticationException {
        if (this.userCache.containsKey(username)) {
            return (User)this.userCache.get(username);
        }
        this.user_object = new LDAPUser();
        String cn = this.ldapAuth.getAttr(username, "cn");
        if (cn.equals("")) {
            this.user_object.init(username);
        } else {
            this.user_object.init(username, cn);
        }
        this.getCustomAttributes(this.user_object);
        return this.user_object;
    }

    private User getCustomAttributes(LDAPUser user) {
        if (this.useSystemCredForAttributes) {
            this.ldapAuth.useSystemCred();
        }
        if (this.displayNameAttributes != null && this.displayNameAttributes.size() > 0) {
            StringBuilder nameBuff = new StringBuilder();
            for (String dispNameAttr : this.displayNameAttributes) {
                String nameAttrVal = this.ldapAuth.getAttr(user.getUsername(), dispNameAttr);
                nameBuff.append(nameAttrVal);
                nameBuff.append(this.displayNameDelimiter);
            }
            user.set("displayName", nameBuff.toString());
        }
        if (this.userAttributes != null && this.userAttributes.size() > 0) {
            this.log.info("LDAP User retrieving attributes...");
            for (String userAttr : this.userAttributes) {
                String attrVal = this.ldapAuth.getAttr(user.getUsername(), userAttr);
                user.set(userAttr, attrVal);
                this.log.info("Retrieved attribute: " + userAttr + ", value:" + attrVal);
            }
        }
        return user;
    }

    public List<User> searchUsers(String search) throws AuthenticationException {
        ArrayList<User> found = new ArrayList<User>();
        return found;
    }
}

