/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.harvester.csv;

import au.com.bytecode.opencsv.CSVReader;
import com.googlecode.fascinator.api.harvester.HarvesterException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.harvester.impl.GenericHarvester;
import com.googlecode.fascinator.common.storage.StorageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVHarvester
extends GenericHarvester {
    private static final char DEFAULT_DELIMITER = ',';
    private static final String DEFAULT_PAYLOAD_ID = "metadata.json";
    private static final int DEFAULT_BATCH_SIZE = 50;
    private Logger log = LoggerFactory.getLogger(CSVHarvester.class);
    private List<String> dataFields;
    private List<String> ignoredFields;
    private List<String> includedFields;
    private String idColumn;
    private String idPrefix;
    private long maxRows;
    private String payloadId;
    private int batchSize;
    private long currentRow;
    private boolean hasMore;
    private CSVReader csvReader;
    private String filename;

    public CSVHarvester() {
        super("csv", "CSV Harvester");
    }

    public void init() throws HarvesterException {
        JsonSimple options = new JsonSimple(this.getJsonConfig().getObject(new Object[]{"harvester", "csv"}));
        String filePath = options.getString(null, new Object[]{"fileLocation"});
        if (filePath == null) {
            throw new HarvesterException("No data file provided!");
        }
        File csvDataFile = new File(filePath);
        if (csvDataFile == null || !csvDataFile.exists()) {
            throw new HarvesterException("Could not find CSV file '" + filePath + "'");
        }
        this.filename = csvDataFile.getName();
        this.idPrefix = options.getString("", new Object[]{"recordIDPrefix"});
        this.maxRows = options.getInteger(Integer.valueOf(-1), new Object[]{"maxRows"}).intValue();
        this.ignoredFields = this.getStringList(options, "ignoreFields");
        this.includedFields = this.getStringList(options, "includedFields");
        this.payloadId = options.getString(DEFAULT_PAYLOAD_ID, new Object[]{"payloadId"});
        this.batchSize = options.getInteger(Integer.valueOf(50), new Object[]{"batchSize"});
        this.hasMore = true;
        try {
            InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(csvDataFile), "UTF-8");
            char delimiter = options.getString(String.valueOf(','), new Object[]{"delimiter"}).charAt(0);
            this.csvReader = new CSVReader((Reader)fileReader, delimiter);
            this.dataFields = options.getBoolean(Boolean.valueOf(true), new Object[]{"headerRow"}) != false ? Arrays.asList(this.csvReader.readNext()) : this.getStringList(options, "headerList");
            this.idColumn = options.getString(null, new Object[]{"idColumn"});
            if (this.idColumn != null && !this.dataFields.contains(this.idColumn)) {
                throw new HarvesterException("'" + this.idColumn + "' is invalid!");
            }
        }
        catch (IOException ioe) {
            throw new HarvesterException((Throwable)ioe);
        }
    }

    private List<String> getStringList(JsonSimple json, Object ... path) {
        List<String> list = json.getStringList(path);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public void shutdown() throws HarvesterException {
        if (this.csvReader != null) {
            try {
                this.csvReader.close();
            }
            catch (IOException ioe) {
                this.log.warn("Failed to close CSVReader!", (Throwable)ioe);
            }
            this.csvReader = null;
        }
    }

    public boolean hasMoreObjects() {
        return this.hasMore;
    }

    public Set<String> getObjectIdList() throws HarvesterException {
        HashSet<String> objectIdList = new HashSet<String>();
        try {
            String[] row = null;
            int rowCount = 0;
            boolean done = false;
            while (!done && (row = this.csvReader.readNext()) != null) {
                ++this.currentRow;
                objectIdList.add(this.createRecord(row));
                if (++rowCount % this.batchSize == 0) {
                    this.log.debug("Batch size reached at row {}", (Object)this.currentRow);
                    break;
                }
                done = this.maxRows > 0L && this.currentRow < this.maxRows;
            }
            this.hasMore = row != null;
        }
        catch (IOException ioe) {
            throw new HarvesterException((Throwable)ioe);
        }
        if (objectIdList.size() > 0) {
            this.log.debug("Created {} objects", (Object)objectIdList.size());
        }
        return objectIdList;
    }

    private String createRecord(String[] columns) throws HarvesterException {
        String recordId = Long.toString(this.currentRow);
        JsonObject data = new JsonObject();
        for (int index = 0; index < columns.length; ++index) {
            String field = this.dataFields.get(index);
            String value = columns[index];
            if (this.includedFields.contains(field) && !this.ignoredFields.contains(field)) {
                data.put((Object)field, (Object)value);
            }
            if (!field.equals(this.idColumn)) continue;
            recordId = value;
        }
        JsonObject meta = new JsonObject();
        meta.put((Object)"dc.identifier", (Object)(this.idPrefix + recordId));
        JsonObject json = new JsonObject();
        json.put((Object)"recordIDPrefix", (Object)this.idPrefix);
        json.put((Object)"data", (Object)data);
        json.put((Object)"metadata", (Object)meta);
        try {
            String oid = DigestUtils.md5Hex((String)(this.filename + this.idPrefix + recordId));
            DigitalObject object = StorageUtils.getDigitalObject((Storage)this.getStorage(), (String)oid);
            JsonSimple jsonSimple = new JsonSimple(json);
            String jsonString = jsonSimple.toString(true);
            InputStream jsonStream = IOUtils.toInputStream((String)jsonString, (String)"UTF-8");
            Payload payload = StorageUtils.createOrUpdatePayload((DigitalObject)object, (String)this.payloadId, (InputStream)jsonStream);
            payload.setContentType("application/json");
            payload.close();
            object.getMetadata().setProperty("render-pending", "true");
            object.close();
            return oid;
        }
        catch (Exception e) {
            throw new HarvesterException("Failed to store metadata", (Throwable)e);
        }
    }
}

