/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.harvester.csv;

import au.com.bytecode.opencsv.CSVReader;
import com.googlecode.fascinator.api.harvester.HarvesterException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.harvester.impl.GenericHarvester;
import com.googlecode.fascinator.common.storage.StorageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVHarvester
extends GenericHarvester {
    private static final char DEFAULT_DELIMITER = ',';
    private static final String DEFAULT_PAYLOAD_ID = "metadata.json";
    private static final int DEFAULT_BATCH_SIZE = 50;
    private static final char DEFAULT_MULTI_VALUE_FIELD_DELIMITER = ';';
    private Logger log = LoggerFactory.getLogger(CSVHarvester.class);
    private List<String> dataFields;
    private List<String> ignoredFields;
    private List<String> includedFields;
    private List<String> multiValueFields;
    private String idColumn;
    private String idPrefix;
    private char delimiter;
    private char multiValueFieldDelimiter;
    private long maxRows;
    private String payloadId;
    private int batchSize;
    private long currentRow;
    private boolean hasMore;
    private CSVReader csvReader;
    private String filename;

    public CSVHarvester() {
        super("csv", "CSV Harvester");
    }

    public void init() throws HarvesterException {
        JsonSimple options = new JsonSimple(this.getJsonConfig().getObject(new Object[]{"harvester", "csv"}));
        String filePath = options.getString(null, new Object[]{"fileLocation"});
        if (filePath == null) {
            throw new HarvesterException("No data file provided!");
        }
        File csvDataFile = new File(filePath);
        if (csvDataFile == null || !csvDataFile.exists()) {
            throw new HarvesterException("Could not find CSV file '" + filePath + "'");
        }
        this.filename = csvDataFile.getName();
        this.idPrefix = options.getString("", new Object[]{"recordIDPrefix"});
        this.maxRows = options.getInteger(Integer.valueOf(-1), new Object[]{"maxRows"}).intValue();
        this.delimiter = options.getString(String.valueOf(','), new Object[]{"delimiter"}).charAt(0);
        this.ignoredFields = this.getStringList(options, "ignoreFields");
        this.includedFields = this.getStringList(options, "includedFields");
        this.multiValueFields = this.getStringList(options, "multiValueFields");
        this.multiValueFieldDelimiter = options.getString(String.valueOf(';'), new Object[]{"multiValueFieldDelimiter"}).charAt(0);
        this.payloadId = options.getString(DEFAULT_PAYLOAD_ID, new Object[]{"payloadId"});
        this.batchSize = options.getInteger(Integer.valueOf(50), new Object[]{"batchSize"});
        this.hasMore = true;
        if (this.delimiter == this.multiValueFieldDelimiter) {
            throw new HarvesterException("Cannot parse CSV: The requested delimiters for the CSV and multivalue fields are the same: " + this.delimiter);
        }
        try {
            InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(csvDataFile), "UTF-8");
            this.csvReader = new CSVReader((Reader)fileReader, this.delimiter);
            this.dataFields = options.getBoolean(Boolean.valueOf(true), new Object[]{"headerRow"}) != false ? Arrays.asList(this.csvReader.readNext()) : this.getStringList(options, "headerList");
            this.idColumn = options.getString(null, new Object[]{"idColumn"});
            if (this.idColumn != null && !this.dataFields.contains(this.idColumn)) {
                throw new HarvesterException("ID column '" + this.idColumn + "' was invalid or not found in the data!");
            }
        }
        catch (IOException ioe) {
            throw new HarvesterException((Throwable)ioe);
        }
    }

    private List<String> getStringList(JsonSimple json, Object ... path) {
        List<String> list = json.getStringList(path);
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public void shutdown() throws HarvesterException {
        if (this.csvReader != null) {
            try {
                this.csvReader.close();
            }
            catch (IOException ioe) {
                this.log.warn("Failed to close CSVReader!", (Throwable)ioe);
            }
            this.csvReader = null;
        }
    }

    public boolean hasMoreObjects() {
        return this.hasMore;
    }

    public Set<String> getObjectIdList() throws HarvesterException {
        HashSet<String> objectIdList = new HashSet<String>();
        try {
            String[] row = null;
            int rowCount = 0;
            boolean done = false;
            while (!done && (row = this.csvReader.readNext()) != null) {
                ++this.currentRow;
                objectIdList.add(this.createRecord(row));
                if (++rowCount % this.batchSize == 0) {
                    this.log.debug("Batch size reached at row {}", (Object)this.currentRow);
                    break;
                }
                done = this.maxRows > 0L && this.currentRow < this.maxRows;
            }
            this.hasMore = row != null;
        }
        catch (IOException ioe) {
            throw new HarvesterException((Throwable)ioe);
        }
        if (objectIdList.size() > 0) {
            this.log.debug("Created {} objects", (Object)objectIdList.size());
        }
        return objectIdList;
    }

    private String createRecord(String[] columns) throws HarvesterException {
        String recordId = Long.toString(this.currentRow);
        JsonObject data = new JsonObject();
        for (int index = 0; index < columns.length; ++index) {
            String field = this.dataFields.get(index);
            String value = columns[index];
            if (this.includedFields.contains(field) && !this.ignoredFields.contains(field)) {
                if (this.multiValueFields.contains(field)) {
                    this.log.debug("Processing a multi-value field: " + field + " with value: " + value);
                    try {
                        CSVReader multi = new CSVReader((Reader)new StringReader(value), this.multiValueFieldDelimiter);
                        String[] values = multi.readNext();
                        multi.close();
                        JSONArray list = new JSONArray();
                        for (String item : values) {
                            this.log.debug(" Individual value:" + item);
                            list.add((Object)item);
                        }
                        data.put((Object)field, (Object)list);
                    }
                    catch (IOException ioe) {
                        throw new HarvesterException((Throwable)ioe);
                    }
                } else {
                    data.put((Object)field, (Object)value);
                }
            }
            if (!field.equals(this.idColumn)) continue;
            recordId = value;
        }
        this.log.debug(data.toJSONString());
        JsonObject meta = new JsonObject();
        meta.put((Object)"dc.identifier", (Object)(this.idPrefix + recordId));
        String oid = DigestUtils.md5Hex((String)(this.filename + this.idPrefix + recordId));
        this.storeJsonInObject(data, meta, oid);
        return oid;
    }

    private void storeJsonInObject(JsonObject dataJson, JsonObject metaJson, String oid) throws HarvesterException {
        DigitalObject object = null;
        try {
            object = this.getStorage().getObject(oid);
            this.storeJsonInPayload(dataJson, metaJson, object);
        }
        catch (StorageException ex) {
            try {
                object = StorageUtils.getDigitalObject((Storage)this.getStorage(), (String)oid);
                this.storeJsonInPayload(dataJson, metaJson, object);
            }
            catch (StorageException ex2) {
                throw new HarvesterException("Error creating new digital object: ", (Throwable)ex2);
            }
        }
        if (object != null) {
            try {
                object.getMetadata().setProperty("render-pending", "true");
                object.close();
            }
            catch (Exception ex) {
                this.log.error("Error setting 'render-pending' flag: ", (Throwable)ex);
            }
        }
    }

    private void storeJsonInPayload(JsonObject dataJson, JsonObject metaJson, DigitalObject object) throws HarvesterException {
        Payload payload = null;
        JsonSimple json = new JsonSimple();
        try {
            payload = object.getPayload(this.payloadId);
            try {
                json = new JsonSimple(payload.open());
            }
            catch (IOException ex) {
                this.log.error("Error parsing existing JSON: '{}' => '{}'", (Object)object.getId(), (Object)this.payloadId);
                throw new HarvesterException("Error parsing existing JSON: ", (Throwable)ex);
            }
            finally {
                payload.close();
            }
            try {
                InputStream in = this.streamMergedJson(dataJson, metaJson, json);
                object.updatePayload(this.payloadId, in);
            }
            catch (IOException ex2) {
                throw new HarvesterException("Error processing JSON data: ", (Throwable)ex2);
            }
            catch (StorageException ex2) {
                throw new HarvesterException("Error updating payload: ", (Throwable)ex2);
            }
        }
        catch (StorageException ex) {
            try {
                InputStream in = this.streamMergedJson(dataJson, metaJson, json);
                payload = object.createStoredPayload(this.payloadId, in);
            }
            catch (IOException ex2) {
                throw new HarvesterException("Error parsing JSON encoding: ", (Throwable)ex2);
            }
            catch (StorageException ex2) {
                throw new HarvesterException("Error creating new payload: ", (Throwable)ex2);
            }
        }
        if (payload != null) {
            try {
                payload.setContentType("application/json");
                payload.close();
            }
            catch (Exception ex) {
                this.log.error("Error setting Payload MIME type and closing: ", (Throwable)ex);
            }
        }
    }

    private InputStream streamMergedJson(JsonObject dataJson, JsonObject metaJson, JsonSimple existing) throws IOException {
        existing.getJsonObject().put((Object)"recordIDPrefix", (Object)this.idPrefix);
        JsonObject existingData = existing.writeObject(new Object[]{"data"});
        existingData.putAll((Map)dataJson);
        JsonObject existingMeta = existing.writeObject(new Object[]{"metadata"});
        existingMeta.putAll((Map)metaJson);
        String jsonString = existing.toString(true);
        return IOUtils.toInputStream((String)jsonString, (String)"UTF-8");
    }
}

