/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.harvester.filesystem;

import com.googlecode.fascinator.api.harvester.HarvesterException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.harvester.impl.GenericHarvester;
import com.googlecode.fascinator.common.storage.StorageUtils;
import com.googlecode.fascinator.harvester.filesystem.DerbyCache;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemHarvester
extends GenericHarvester {
    private static final String DEFAULT_IGNORE_PATTERNS = ".svn";
    private Logger log = LoggerFactory.getLogger(FileSystemHarvester.class);
    private List<JsonSimple> targets;
    private Integer targetIndex;
    private File nextFile;
    private Stack<File> fileStack;
    private String facetBase;
    private boolean hasMore;
    private IgnoreFilter ignoreFilter;
    private boolean recursive;
    private boolean force;
    private boolean link;
    private Map<String, Map<String, List<String>>> renderChains;
    private DerbyCache cache;
    private boolean supportDeletes;

    public FileSystemHarvester() {
        super("file-system", "File System Harvester");
    }

    public void init() throws HarvesterException {
        this.targets = this.getJsonConfig().getJsonSimpleList(new Object[]{"harvester", "file-system", "targets"});
        if (this.targets.isEmpty()) {
            throw new HarvesterException("No targets specified");
        }
        this.fileStack = new Stack();
        this.targetIndex = null;
        this.hasMore = true;
        try {
            this.cache = new DerbyCache(this.getJsonConfig());
            this.cache.resetFlags();
            this.supportDeletes = false;
        }
        catch (Exception ex) {
            this.log.error("Error instantiating cache: ", (Throwable)ex);
            throw new HarvesterException((Throwable)ex);
        }
        this.renderChains = new LinkedHashMap<String, Map<String, List<String>>>();
        Map renderTypes = this.getJsonConfig().getJsonSimpleMap(new Object[]{"renderTypes"});
        if (renderTypes != null) {
            for (Map.Entry entry : renderTypes.entrySet()) {
                HashMap<String, List> details = new HashMap<String, List>();
                details.put("fileTypes", ((JsonSimple)entry.getValue()).getStringList(new Object[]{"fileTypes"}));
                details.put("harvestQueue", ((JsonSimple)entry.getValue()).getStringList(new Object[]{"harvestQueue"}));
                details.put("indexOnHarvest", ((JsonSimple)entry.getValue()).getStringList(new Object[]{"indexOnHarvest"}));
                details.put("renderQueue", ((JsonSimple)entry.getValue()).getStringList(new Object[]{"renderQueue"}));
                this.renderChains.put((String)entry.getKey(), (Map<String, List<String>>)details);
            }
        }
        this.nextFile = this.getNextFile();
    }

    private File getNextFile() {
        File next = null;
        next = this.fileStack.empty() ? this.getNextTarget() : this.fileStack.pop();
        if (next == null) {
            this.hasMore = false;
        }
        return next;
    }

    private File getNextTarget() {
        if (this.targetIndex == null) {
            this.targetIndex = 0;
        } else {
            Integer n = this.targetIndex;
            Integer n2 = this.targetIndex = Integer.valueOf(this.targetIndex + 1);
        }
        if (this.targetIndex >= this.targets.size()) {
            return null;
        }
        JsonSimple target = this.targets.get(this.targetIndex);
        String path = target.getString(null, new Object[]{"baseDir"});
        if (path == null) {
            this.log.warn("No path provided for target, skipping!");
            return this.getNextTarget();
        }
        File file = new File(path);
        if (!file.exists()) {
            this.log.warn("Path '{}' does not exist, skipping!", (Object)path);
            return this.getNextTarget();
        }
        this.log.info("Target file/directory found: '{}'", (Object)path);
        this.updateConfig(target, path);
        return file;
    }

    private void updateConfig(JsonSimple tConfig, String path) {
        this.recursive = tConfig.getBoolean(Boolean.valueOf(false), new Object[]{"recursive"});
        this.ignoreFilter = new IgnoreFilter(tConfig.getString(DEFAULT_IGNORE_PATTERNS, new Object[]{"ignoreFilter"}).split("\\|"));
        this.force = tConfig.getBoolean(Boolean.valueOf(false), new Object[]{"force"});
        this.link = tConfig.getBoolean(Boolean.valueOf(false), new Object[]{"link"});
        this.facetBase = tConfig.getString(path, new Object[]{"facetDir"});
    }

    public void shutdown() throws HarvesterException {
        if (this.cache != null) {
            try {
                this.cache.shutdown();
            }
            catch (Exception ex) {
                this.log.error("Error shutting down cache: ", (Throwable)ex);
                throw new HarvesterException((Throwable)ex);
            }
        }
    }

    public Set<String> getObjectIdList() throws HarvesterException {
        HashSet<String> fileObjectIdList = new HashSet<String>();
        if (this.nextFile == null) {
            this.hasMore = false;
            return fileObjectIdList;
        }
        if (this.nextFile.isDirectory()) {
            File[] children;
            for (File child : children = this.nextFile.listFiles(this.ignoreFilter)) {
                if (child.isDirectory()) {
                    if (!this.recursive) continue;
                    this.fileStack.push(child);
                    continue;
                }
                this.harvestFile(fileObjectIdList, child);
            }
        } else {
            this.harvestFile(fileObjectIdList, this.nextFile);
        }
        this.nextFile = this.getNextFile();
        return fileObjectIdList;
    }

    private void harvestFile(Set<String> list, File file) throws HarvesterException {
        String oid = StorageUtils.generateOid((File)file);
        if (this.cache.hasChanged(oid, file) || this.force) {
            try {
                list.add(this.createDigitalObject(file));
            }
            catch (StorageException se) {
                this.log.warn("File not harvested {}: {}", (Object)file, (Object)se.getMessage());
            }
        }
    }

    public boolean hasMoreObjects() {
        if (!this.hasMore) {
            this.supportDeletes = true;
        }
        return this.hasMore;
    }

    public Set<String> getDeletedObjectIdList() throws HarvesterException {
        if (!this.supportDeletes) {
            String msg = "This plugin only supports deletion if caching is enabled and all 'add' and 'update' harvesting has been processed first. Please ensure caching is configured correctly and that harvesting has continued until hasMoreObjects() returns false. ";
            throw new HarvesterException(msg);
        }
        this.supportDeletes = false;
        Set<String> response = this.cache.getUnsetFlags();
        this.cache.purgeUnsetFlags();
        return response;
    }

    public boolean hasMoreDeletedObjects() {
        return this.supportDeletes;
    }

    private String createDigitalObject(File file) throws HarvesterException, StorageException {
        DigitalObject object = StorageUtils.storeFile((Storage)this.getStorage(), (File)file, (boolean)this.link);
        Properties props = object.getMetadata();
        props.setProperty("render-pending", "true");
        props.setProperty("file.path", FilenameUtils.separatorsToUnix((String)file.getAbsolutePath()));
        props.setProperty("base.file.path", FilenameUtils.separatorsToUnix((String)this.facetBase));
        String ext = FilenameUtils.getExtension((String)file.getName());
        for (String chain : this.renderChains.keySet()) {
            Map<String, List<String>> details = this.renderChains.get(chain);
            if (!details.get("fileTypes").contains(ext)) continue;
            this.storeList(props, details, "harvestQueue");
            this.storeList(props, details, "indexOnHarvest");
            this.storeList(props, details, "renderQueue");
        }
        object.close();
        return object.getId();
    }

    private void storeList(Properties props, Map<String, List<String>> details, String field) {
        LinkedHashSet<String> valueSet = new LinkedHashSet<String>();
        String currentValue = props.getProperty(field, "");
        if (!"".equals(currentValue)) {
            String[] currentList = currentValue.split(",");
            valueSet.addAll(Arrays.asList(currentList));
        }
        valueSet.addAll((Collection)details.get(field));
        String joinedList = StringUtils.join(valueSet, (String)",");
        props.setProperty(field, joinedList);
    }

    private class IgnoreFilter
    implements FileFilter {
        private String[] patterns;

        public IgnoreFilter(String[] patterns) {
            this.patterns = patterns;
        }

        @Override
        public boolean accept(File path) {
            for (String pattern : this.patterns) {
                if (!FilenameUtils.wildcardMatch((String)path.getName(), (String)pattern)) continue;
                return false;
            }
            return true;
        }
    }
}

