/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.harvester.oaipmh.http;

import com.googlecode.fascinator.common.BasicHttpClient;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Date;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.httpclient.util.HttpURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Handler
extends URLStreamHandler {
    private static final int DEFAULT_RETRY_COUNT = 3;
    private static final int DEFAULT_RETRY_AFTER = 10;
    private static final int MAX_RETRY_AFTER = 60000;
    private Logger log = LoggerFactory.getLogger(Handler.class);

    @Override
    public URLConnection openConnection(URL url) throws IOException {
        this.log.debug("openConnection: {}", (Object)url);
        String uri = url.toString();
        BasicHttpClient client = new BasicHttpClient(uri);
        GetMethod getMethod = new GetMethod(uri);
        int retryCount = 0;
        int status = 0;
        long retryAfter = 10L;
        do {
            Header h;
            if ((status = client.executeMethod((HttpMethodBase)getMethod)) != 503 || (h = getMethod.getResponseHeader("Retry-After")) == null) continue;
            String value = h.getValue();
            try {
                Date retryAfterDate = DateUtil.parseDate((String)value);
                retryAfter = (retryAfterDate.getTime() - System.currentTimeMillis()) * 1000L;
            }
            catch (DateParseException dpe) {
                retryAfter = Integer.parseInt(value);
            }
            if (retryAfter > 60000L) {
                this.log.warn("Retry-After is too far in the future: {}", (Object)value);
                break;
            }
            if (retryAfter < 0L) {
                this.log.warn("Retry-After is in the past: {}", (Object)value);
                continue;
            }
            ++retryCount;
            try {
                this.log.debug("Waiting for {}s before retrying...", (Object)retryAfter);
                Thread.sleep(retryAfter * 1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (status == 503 && retryCount < 3);
        return new HttpURLConnection((HttpMethod)getMethod, url);
    }
}

