/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.harvester.oaipmh;

import com.googlecode.fascinator.api.harvester.HarvesterException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.harvester.impl.GenericHarvester;
import com.googlecode.fascinator.common.storage.StorageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.kb.oai.OAIException;
import se.kb.oai.pmh.ErrorResponseException;
import se.kb.oai.pmh.OaiPmhServer;
import se.kb.oai.pmh.Record;
import se.kb.oai.pmh.RecordsList;
import se.kb.oai.pmh.ResumptionToken;

public class OaiPmhHarvester
extends GenericHarvester {
    private static final String PROTOCOL_HANDLER_KEY = "java.protocol.handler.pkgs";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'hh:mm:ss'Z'";
    public static final String DEFAULT_METADATA_PREFIX = "oai_dc";
    private Logger log = LoggerFactory.getLogger(OaiPmhHarvester.class);
    private OaiPmhServer server;
    private boolean started;
    private ResumptionToken token;
    private int numRequests;
    private int numObjects;
    private int maxRequests;
    private int maxObjects;
    private String recordID;
    private String protocolHandlerPkgs;
    private String dateFrom;
    private String dateUntil;
    private List<String> metadataPrefixes;
    private String setSpec;
    private boolean useSetInStorage;

    public OaiPmhHarvester() {
        super("oai-pmh", "OAI-PMH Harvester");
    }

    public void init() throws HarvesterException {
        String url = this.getJsonConfig().getString(null, new Object[]{"harvester", "oai-pmh", "url"});
        if (url == null) {
            throw new HarvesterException("OAI-PMH : No server URL provided!");
        }
        this.server = new OaiPmhServer(url);
        this.recordID = this.getJsonConfig().getString(null, new Object[]{"harvester", "oai-pmh", "recordID"});
        this.maxRequests = this.getJsonConfig().getInteger(Integer.valueOf(-1), new Object[]{"harvester", "oai-pmh", "maxRequests"});
        if (this.maxRequests == -1) {
            this.maxRequests = Integer.MAX_VALUE;
        }
        this.maxObjects = this.getJsonConfig().getInteger(Integer.valueOf(-1), new Object[]{"harvester", "oai-pmh", "maxObjects"});
        if (this.maxObjects == -1) {
            this.maxObjects = Integer.MAX_VALUE;
        }
        this.started = false;
        this.numRequests = 0;
        this.numObjects = 0;
        this.dateFrom = this.validDate(this.getJsonConfig().getString(null, new Object[]{"harvester", "oai-pmh", "from"}));
        this.dateUntil = this.validDate(this.getJsonConfig().getString(null, new Object[]{"harvester", "oai-pmh", "until"}));
        if (this.dateFrom == null) {
            this.log.info("Harvesting all records");
        } else {
            this.log.info("Harvesting records from {} to {}", (Object)this.dateFrom, (Object)(this.dateUntil == null ? this.dateUntil : " now"));
        }
        JsonObject configNode = this.getJsonConfig().getObject(new Object[]{"harvester", "oai-pmh"});
        this.metadataPrefixes = JsonSimple.getStringList((JsonObject)configNode, (String)"metadataPrefix");
        if (this.metadataPrefixes == null || this.metadataPrefixes.isEmpty()) {
            this.metadataPrefixes = new ArrayList<String>();
            this.metadataPrefixes.add(DEFAULT_METADATA_PREFIX);
        }
        this.setSpec = this.getJsonConfig().getString(null, new Object[]{"harvester", "oai-pmh", "setSpec"});
        this.useSetInStorage = this.getJsonConfig().getBoolean(Boolean.valueOf(false), new Object[]{"harvester", "oai-pmh", "useSetInStorage"});
    }

    private String basicDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat(DATETIME_FORMAT);
        if (date != null) {
            try {
                Date objDate = format.parse(date);
                format = new SimpleDateFormat(DATE_FORMAT);
                return format.format(objDate);
            }
            catch (ParseException pe) {
                this.log.warn("Failed to parse date: '{}'", (Object)date, (Object)pe);
                return null;
            }
        }
        return null;
    }

    private String validDate(String date) {
        SimpleDateFormat format = new SimpleDateFormat(DATETIME_FORMAT);
        if (date != null) {
            try {
                format.parse(date);
                return date;
            }
            catch (ParseException pe) {
                this.log.warn("Failed to parse date: '{}'", (Object)date, (Object)pe);
                return null;
            }
        }
        return null;
    }

    public Set<String> getObjectIdList() throws HarvesterException {
        System.setProperty(PROTOCOL_HANDLER_KEY, ((Object)((Object)this)).getClass().getPackage().getName());
        HashSet<String> items = new HashSet<String>();
        RecordsList records = null;
        try {
            ++this.numRequests;
            if (this.recordID != null) {
                this.log.info("Requesting record {}", (Object)this.recordID);
                Iterator<String> i$ = this.metadataPrefixes.iterator();
                if (i$.hasNext()) {
                    String metadataPrefix = i$.next();
                    Record record = this.server.getRecord(this.recordID, metadataPrefix);
                    try {
                        items.add(this.createOaiPmhDigitalObject(record, metadataPrefix));
                    }
                    catch (HarvesterException he) {
                    }
                    catch (StorageException se) {
                        this.log.error("Failed to create object", (Throwable)se);
                    }
                    catch (IOException ioe) {
                        this.log.error("Failed to read object", (Throwable)ioe);
                    }
                    return items;
                }
            } else if (this.started) {
                records = this.server.listRecords(this.token);
                this.log.info("Resuming harvest using token {}", (Object)this.token.getId());
            } else {
                this.started = true;
                try {
                    records = this.server.listRecords(this.metadataPrefixes.get(0), this.dateFrom, this.dateUntil, this.setSpec);
                }
                catch (ErrorResponseException ere) {
                    if (ere.getMessage().startsWith("Max granularity")) {
                        this.log.warn(ere.getMessage());
                        this.dateFrom = this.basicDate(this.dateFrom);
                        this.dateUntil = this.basicDate(this.dateUntil);
                    }
                    this.log.info("Harvesting records from {} to {}", (Object)this.dateFrom, (Object)(this.dateUntil == null ? this.dateUntil : " now"));
                    records = this.server.listRecords(this.metadataPrefixes.get(0), this.dateFrom, this.dateUntil, this.setSpec);
                }
            }
            for (Record record : records.asList()) {
                if (this.numObjects >= this.maxObjects) continue;
                ++this.numObjects;
                try {
                    items.add(this.createOaiPmhDigitalObject(record, this.metadataPrefixes.get(0)));
                    if (this.metadataPrefixes.size() <= 1) continue;
                    String id = record.getHeader().getIdentifier();
                    for (int count = 1; count < this.metadataPrefixes.size(); ++count) {
                        Record otherRecord = this.server.getRecord(id, this.metadataPrefixes.get(count));
                        this.log.info("..... recordId {}", (Object)otherRecord.getHeader().getIdentifier());
                        this.createOaiPmhDigitalObject(otherRecord, this.metadataPrefixes.get(count));
                    }
                }
                catch (HarvesterException he) {
                }
                catch (StorageException se) {
                    this.log.error("Failed to create object", (Throwable)se);
                }
                catch (IOException ioe) {
                    this.log.error("Failed to read object", (Throwable)ioe);
                }
            }
            ResumptionToken tempToken = records.getResumptionToken();
            if (tempToken != null) {
                String safeToken = URLEncoder.encode(tempToken.getId(), "UTF-8");
                this.token = new ResumptionToken(safeToken, tempToken.getExpirationDate());
            } else {
                this.token = null;
            }
        }
        catch (OAIException oe) {
            throw new HarvesterException((Throwable)oe);
        }
        catch (UnsupportedEncodingException oe) {
            throw new HarvesterException((Throwable)oe);
        }
        if (this.protocolHandlerPkgs == null) {
            System.getProperties().remove(PROTOCOL_HANDLER_KEY);
        } else {
            System.setProperty(PROTOCOL_HANDLER_KEY, this.protocolHandlerPkgs);
        }
        return items;
    }

    private String createOaiPmhDigitalObject(Record record, String metadataPrefix) throws HarvesterException, IOException, StorageException {
        Storage storage = this.getStorage();
        String oid = record.getHeader().getIdentifier();
        if (this.useSetInStorage && this.setSpec != null) {
            oid = oid + "-" + this.setSpec;
        }
        String metadata = null;
        try {
            metadata = record.getMetadataAsString();
        }
        catch (Exception ex) {
            this.log.error("Unable to access record metadata for ID: '{}'. Delete event?", (Object)oid);
            throw new HarvesterException("Record has not metadata to store!");
        }
        oid = DigestUtils.md5Hex((String)oid);
        DigitalObject object = StorageUtils.getDigitalObject((Storage)storage, (String)oid);
        String pid = metadataPrefix + ".xml";
        Payload payload = StorageUtils.createOrUpdatePayload((DigitalObject)object, (String)pid, (InputStream)IOUtils.toInputStream((String)metadata, (String)"UTF-8"));
        payload.setContentType("text/xml");
        if (object.getSourceId() == null) {
            payload.setType(PayloadType.Source);
            object.setSourceId(pid);
        } else {
            payload.setType(PayloadType.Enrichment);
        }
        payload.close();
        Properties props = object.getMetadata();
        props.setProperty("render-pending", "true");
        object.close();
        return object.getId();
    }

    public boolean hasMoreObjects() {
        return this.token != null && this.numRequests < this.maxRequests && this.numObjects < this.maxObjects;
    }
}

