/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.harvester.skos;

import com.googlecode.fascinator.api.harvester.HarvesterException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.harvester.impl.GenericHarvester;
import com.googlecode.fascinator.common.storage.StorageUtils;
import com.googlecode.fascinator.vocabulary.SKOS;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.ontoware.aifbcommons.collection.ClosableIterator;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.Reasoning;
import org.ontoware.rdf2go.exception.ModelRuntimeException;
import org.ontoware.rdf2go.impl.jena24.ModelImplJena24;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Statement;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.NodeOrVariable;
import org.ontoware.rdf2go.model.node.ResourceOrVariable;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.UriOrVariable;
import org.ontoware.rdf2go.model.node.Variable;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkosHarvester
extends GenericHarvester {
    private Logger log = LoggerFactory.getLogger(SkosHarvester.class);
    private Model rdfModel;
    private URI conceptScheme;
    private RDFContainer container;
    private String baseUri;
    private String rootNode;

    public SkosHarvester() {
        super("skos", "SKOS Harvester");
    }

    public void init() throws HarvesterException {
        JsonSimpleConfig config;
        this.log.info("Initialising SKOS harvester...");
        try {
            config = new JsonSimpleConfig(this.getJsonConfig().toString());
        }
        catch (IOException ex) {
            throw new HarvesterException("Failed reading configuration", (Throwable)ex);
        }
        String baseFile = config.getString("", new Object[]{"harvester", "skos", "baseFile"});
        if (baseFile.equals("")) {
            throw new HarvesterException("No SKOS file specified");
        }
        File skosFile = new File(baseFile);
        this.baseUri = config.getString("", new Object[]{"harvester", "skos", "baseUri"});
        this.rootNode = config.getString("skos", new Object[]{"harvester", "skos", "rootNode"});
        try {
            this.rdfModel = this.getRdfModel(new FileInputStream(skosFile));
            this.setConceptScheme();
            this.container = new RDFContainerImpl(this.rdfModel, this.conceptScheme);
        }
        catch (FileNotFoundException e) {
            this.log.error("SKOS RDF file not found");
        }
    }

    public Set<String> getObjectIdList() throws HarvesterException {
        String type;
        HashSet<String> skosObjectIdList = new HashSet<String>();
        String newUri = this.rootNode;
        if (!"".equals(newUri) && !newUri.endsWith("/")) {
            newUri = newUri + "/";
        }
        if (!"".equals(type = this.getType(this.conceptScheme.toString()))) {
            newUri = newUri + type + "/";
        }
        try {
            skosObjectIdList.add(this.createSkosObject(this.conceptScheme, newUri));
        }
        catch (StorageException e1) {
            throw new HarvesterException("Fail to create object " + e1.getMessage());
        }
        catch (IOException e1) {
            throw new HarvesterException("Fail to create payload " + e1.getMessage());
        }
        Collection concepts = this.container.getAll(SKOS.hasTopConcept);
        try {
            this.createConceptStructure(skosObjectIdList, concepts, newUri);
        }
        catch (StorageException e) {
            throw new HarvesterException("Fail to create SKOS object");
        }
        catch (IOException e) {
            throw new HarvesterException("File creation file");
        }
        return skosObjectIdList;
    }

    private void createConceptStructure(Set<String> skosObjectIdList, Collection<?> collection, String conceptUri) throws HarvesterException, StorageException, IOException {
        for (Node node : collection) {
            String conceptType = this.getType(node.toString());
            String newConceptUri = conceptUri + conceptType + "/";
            RDFContainerImpl conceptContainer = new RDFContainerImpl(this.rdfModel, node.toString());
            Collection narrowers = conceptContainer.getAll(SKOS.narrower);
            skosObjectIdList.add(this.createSkosObject((URI)new URIImpl(node.toString()), newConceptUri));
            if (narrowers.size() <= 0) continue;
            this.createConceptStructure(skosObjectIdList, narrowers, newConceptUri);
        }
    }

    private String getType(String uri) {
        String type = uri;
        if (uri.startsWith(this.baseUri)) {
            type = uri.substring(this.baseUri.length());
        }
        return type;
    }

    private void setConceptScheme() throws HarvesterException {
        ClosableIterator it = this.rdfModel.findStatements((ResourceOrVariable)Variable.ANY, (UriOrVariable)new URIImpl(RDF.type.getURI()), (NodeOrVariable)SKOS.ConceptScheme);
        this.conceptScheme = null;
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            this.conceptScheme = new URIImpl(s.getSubject().toString());
        }
        if (this.conceptScheme == null) {
            throw new HarvesterException("skos:conceptScheme not found!");
        }
    }

    public URI getConceptScheme() {
        return this.conceptScheme;
    }

    public boolean hasMoreObjects() {
        return false;
    }

    private String createSkosObject(URI conceptUri, String newConceptUri) throws HarvesterException, StorageException, IOException {
        Storage storage = this.getStorage();
        String conceptId = this.getType(conceptUri.toString());
        this.log.info("Extracting SKOS RDF fragment for {}", (Object)conceptId);
        String oid = DigestUtils.md5Hex((String)conceptId);
        DigitalObject object = StorageUtils.getDigitalObject((Storage)storage, (String)oid);
        String pid = conceptId + ".rdf";
        Payload payload = StorageUtils.createOrUpdatePayload((DigitalObject)object, (String)pid, (InputStream)IOUtils.toInputStream((String)this.serialize(conceptUri), (String)"UTF-8"));
        payload.setContentType("text/xml");
        payload.close();
        Properties props = object.getMetadata();
        props.setProperty("render-pending", "true");
        props.setProperty("skos-uri", newConceptUri.replaceAll("//", "/"));
        props.setProperty("concept-uri", conceptUri.toString());
        object.close();
        return object.getId();
    }

    private String serialize(URI uri) {
        ClosableIterator iterator = this.rdfModel.findStatements((ResourceOrVariable)uri, (UriOrVariable)Variable.ANY, (NodeOrVariable)Variable.ANY);
        Model m = RDF2Go.getModelFactory().createModel();
        m.open();
        m.addAll((Iterator)iterator);
        return m.serialize(Syntax.RdfXml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model getRdfModel(InputStream rdfIn) {
        ModelImplJena24 model = null;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(rdfIn, "UTF-8");
            model = new ModelImplJena24(Reasoning.rdfs);
            model.open();
            model.readFrom((Reader)reader);
        }
        catch (ModelRuntimeException mre) {
            this.log.error("Failed to create RDF model", (Throwable)mre);
        }
        catch (IOException ioe) {
            this.log.error("Failed to read RDF input", (Throwable)ioe);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException ioe) {}
            }
        }
        return model;
    }
}

