/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.harvester.workflow;

import com.googlecode.fascinator.api.harvester.HarvesterException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.harvester.impl.GenericHarvester;
import com.googlecode.fascinator.common.storage.StorageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowHarvester
extends GenericHarvester {
    private Logger log = LoggerFactory.getLogger(WorkflowHarvester.class);
    private boolean forceLocalStorage;
    private boolean forceUpdate;
    private Map<String, Map<String, List<String>>> renderChains;

    public WorkflowHarvester() {
        super("workflow-harvester", "Workflow Harvester");
    }

    public void init() throws HarvesterException {
        this.forceLocalStorage = this.getJsonConfig().getBoolean(Boolean.valueOf(true), new Object[]{"harvester", "workflow-harvester", "force-storage"});
        this.forceUpdate = this.getJsonConfig().getBoolean(Boolean.valueOf(false), new Object[]{"harvester", "workflow-harvester", "force-update"});
        this.renderChains = new LinkedHashMap<String, Map<String, List<String>>>();
        JsonObject renderTypes = this.getJsonConfig().getObject(new Object[]{"renderTypes"});
        if (renderTypes != null) {
            for (Object name : renderTypes.keySet()) {
                HashMap<String, List> details = new HashMap<String, List>();
                JsonObject chain = (JsonObject)renderTypes.get(name);
                details.put("fileTypes", JsonSimple.getStringList((JsonObject)chain, (String)"fileTypes"));
                details.put("harvestQueue", JsonSimple.getStringList((JsonObject)chain, (String)"harvestQueue"));
                details.put("indexOnHarvest", JsonSimple.getStringList((JsonObject)chain, (String)"indexOnHarvest"));
                details.put("renderQueue", JsonSimple.getStringList((JsonObject)chain, (String)"renderQueue"));
                this.renderChains.put((String)name, details);
            }
        }
    }

    public Set<String> getObjectIdList() throws HarvesterException {
        return Collections.emptySet();
    }

    public Set<String> getObjectId(File uploadedFile) throws HarvesterException {
        HashSet<String> objectIds = new HashSet<String>();
        try {
            objectIds.add(this.createDigitalObject(uploadedFile));
        }
        catch (StorageException se) {
            throw new HarvesterException((Throwable)se);
        }
        return objectIds;
    }

    public boolean hasMoreObjects() {
        return false;
    }

    private String createDigitalObject(File file) throws HarvesterException, StorageException {
        DigitalObject object;
        if (this.forceUpdate) {
            object = StorageUtils.storeFile((Storage)this.getStorage(), (File)file, (!this.forceLocalStorage ? 1 : 0) != 0);
        } else {
            String oid = StorageUtils.generateOid((File)file);
            String pid = StorageUtils.generatePid((File)file);
            object = this.getStorage().createObject(oid);
            if (this.forceLocalStorage) {
                try {
                    object.createStoredPayload(pid, (InputStream)new FileInputStream(file));
                }
                catch (FileNotFoundException ex) {
                    throw new HarvesterException((Throwable)ex);
                }
            } else {
                object.createLinkedPayload(pid, file.getAbsolutePath());
            }
        }
        Properties props = object.getMetadata();
        props.setProperty("render-pending", "true");
        props.setProperty("file.path", FilenameUtils.separatorsToUnix((String)file.getAbsolutePath()));
        String objectId = object.getId();
        String ext = FilenameUtils.getExtension((String)file.getName());
        for (String chain : this.renderChains.keySet()) {
            Map<String, List<String>> details = this.renderChains.get(chain);
            if (!details.get("fileTypes").contains(ext)) continue;
            this.storeList(props, details, "harvestQueue");
            this.storeList(props, details, "indexOnHarvest");
            this.storeList(props, details, "renderQueue");
        }
        object.close();
        return objectId;
    }

    private void storeList(Properties props, Map<String, List<String>> details, String field) {
        LinkedHashSet<String> valueSet = new LinkedHashSet<String>();
        String currentValue = props.getProperty(field, "");
        if (!"".equals(currentValue)) {
            String[] currentList = currentValue.split(",");
            valueSet.addAll(Arrays.asList(currentList));
        }
        valueSet.addAll((Collection)details.get(field));
        String joinedList = StringUtils.join(valueSet, (String)",");
        props.setProperty(field, joinedList);
    }
}

