/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.indexer.rules;

import com.googlecode.fascinator.api.indexer.rule.AddDoc;
import com.googlecode.fascinator.api.indexer.rule.Field;
import com.googlecode.fascinator.api.indexer.rule.Rule;
import com.googlecode.fascinator.api.indexer.rule.RuleException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;

public class DeleteField
extends Rule {
    private String fieldName;
    private String regex;

    public DeleteField(String fieldName) {
        this(fieldName, "^\\s*$");
    }

    public DeleteField(String fieldName, String regex) {
        super("Delete field");
        this.fieldName = fieldName;
        this.regex = regex;
    }

    public void run(Reader in, Writer out) throws RuleException {
        this.log("Deleting '" + this.fieldName + "' fields that match '" + this.regex + "'");
        try {
            AddDoc addDoc = AddDoc.read((Reader)in);
            List fields = addDoc.getFields(this.fieldName);
            ArrayList<Field> deletedFields = new ArrayList<Field>();
            for (Field field : fields) {
                String value = field.getValue();
                boolean match = Pattern.matches(this.regex, field.getValue());
                if (match) {
                    deletedFields.add(field);
                    this.log("Deleted matching value '" + value + "'");
                    continue;
                }
                this.log("Keep unmatched value '" + value + "'");
            }
            for (Field field : deletedFields) {
                addDoc.getFields().remove(field);
            }
            addDoc.write(out);
        }
        catch (JAXBException jaxbe) {
            throw new RuleException(jaxbe.getLinkedException());
        }
    }
}

