/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.indexer.rules;

import com.googlecode.fascinator.api.indexer.rule.Rule;
import com.googlecode.fascinator.api.indexer.rule.RuleException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XslTransform
extends Rule {
    private Transformer transformer;

    public XslTransform(InputStream xsl) throws RuleException {
        this(xsl, null);
    }

    public XslTransform(InputStream xsl, Map<String, String> params) throws RuleException {
        super("XSLT transform", true);
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            Templates t = tf.newTemplates(new StreamSource(xsl));
            this.transformer = t.newTransformer();
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    this.transformer.setParameter(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (TransformerConfigurationException tce) {
            tce.printStackTrace();
            throw new RuleException("Failed to load stylesheet", (Throwable)tce);
        }
    }

    public void run(Reader in, Writer out) throws RuleException {
        StreamSource source = new StreamSource(in);
        StreamResult result = new StreamResult(out);
        try {
            this.transformer.transform(source, result);
        }
        catch (TransformerException te) {
            throw new RuleException("Failed to transform", (Throwable)te);
        }
    }
}

