/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.indexer;

import com.googlecode.fascinator.api.indexer.rule.Rule;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleManager {
    private Logger log = LoggerFactory.getLogger(RuleManager.class);
    private List<Rule> rules = new ArrayList<Rule>();
    private List<File> tempFiles;
    private File workDir = new File(System.getProperty("java.io.tmpdir"));
    private boolean cancelled = false;

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void add(Rule rule) {
        this.rules.add(rule);
    }

    public void remove(Rule rule) {
        this.rules.remove(rule);
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public void run(Reader in, Writer out) throws IOException {
        Reader tmpIn = in;
        OutputStreamWriter tmpOut = null;
        this.cancelled = false;
        for (Rule rule : this.rules) {
            try {
                File tmpFile = this.createTempFile("rule", ".xml");
                FileOutputStream tmpOutStream = new FileOutputStream(tmpFile);
                tmpOut = new OutputStreamWriter((OutputStream)tmpOutStream, "UTF-8");
                rule.run(tmpIn, (Writer)tmpOut);
                ((Writer)tmpOut).close();
                ((OutputStream)tmpOutStream).close();
                tmpIn.close();
                tmpIn = new InputStreamReader((InputStream)new FileInputStream(tmpFile), "UTF-8");
            }
            catch (Exception e) {
                if (rule.isRequired()) {
                    this.cancelled = true;
                    this.log.error("Stopping since " + rule + " failed: ", (Throwable)e);
                    break;
                }
                this.log.warn("Rule " + rule + " failed: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (!this.cancelled) {
            IOUtils.copy((Reader)tmpIn, (Writer)out);
        }
        tmpIn.close();
        out.close();
        this.cleanupTempFiles();
    }

    private File createTempFile(String prefix, String postfix) throws IOException {
        File tempFile = File.createTempFile(prefix, postfix, this.workDir);
        tempFile.deleteOnExit();
        if (this.tempFiles == null) {
            this.tempFiles = Collections.synchronizedList(new ArrayList());
        }
        this.tempFiles.add(tempFile);
        return tempFile;
    }

    private void cleanupTempFiles() {
        if (this.tempFiles != null) {
            for (File tempFile : this.tempFiles) {
                if (!tempFile.exists()) continue;
                tempFile.delete();
            }
            this.tempFiles = null;
        }
    }
}

