/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.indexer;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.IndexerException;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.api.indexer.rule.RuleException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.PythonUtils;
import com.googlecode.fascinator.common.messaging.MessagingException;
import com.googlecode.fascinator.common.messaging.MessagingServices;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.common.solr.SolrResult;
import com.googlecode.fascinator.indexer.SolrSearcher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.DirectXmlRequest;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexer
implements Indexer {
    private static String ANOTAR_RULES_OID = "FakeAnotarRulesOid1234";
    private static String SCRIPT_CLASS_NAME = "IndexData";
    private static String SCRIPT_ACTIVATE_METHOD = "__activate__";
    private static String DEFAULT_METADATA_PAYLOAD = "TF-OBJ-META";
    private String propertiesId;
    private Logger log = LoggerFactory.getLogger(SolrIndexer.class);
    private JsonSimpleConfig config;
    private Storage storage;
    private SolrServer solr;
    private SolrServer anotar;
    private boolean anotarAutoCommit;
    private Map<String, String> usernameMap;
    private Map<String, String> passwordMap;
    private boolean loaded = false;
    private Map<String, String> customParams;
    private PythonUtils pyUtils;
    private HashMap<String, PyObject> scriptCache;
    private HashMap<String, JsonSimpleConfig> configCache;
    private boolean useCache;
    private MessagingServices messaging;
    private Map<String, SolrServer> solrServerMap;

    public String getId() {
        return "solr";
    }

    public String getName() {
        return "Apache Solr Indexer";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    private PythonUtils getPyUtils() throws IndexerException {
        if (this.pyUtils == null) {
            try {
                this.pyUtils = new PythonUtils(this.config);
            }
            catch (PluginException ex) {
                throw new IndexerException((Throwable)ex);
            }
        }
        return this.pyUtils;
    }

    private MessagingServices getMessaging() {
        if (this.messaging == null) {
            try {
                this.messaging = MessagingServices.getInstance();
            }
            catch (MessagingException ex) {
                this.log.error("Failed to start connection: {}", (Object)ex.getMessage());
            }
        }
        return this.messaging;
    }

    public void init(String jsonString) throws IndexerException {
        try {
            this.config = new JsonSimpleConfig(jsonString);
            this.init();
        }
        catch (IOException e) {
            throw new IndexerException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws IndexerException {
        try {
            this.config = new JsonSimpleConfig(jsonFile);
            this.init();
        }
        catch (IOException ioe) {
            throw new IndexerException((Throwable)ioe);
        }
    }

    private void init() throws IndexerException {
        if (!this.loaded) {
            this.loaded = true;
            String storageType = this.config.getString(null, new Object[]{"storage", "type"});
            try {
                this.storage = PluginManager.getStorage((String)storageType);
                this.storage.init(this.config.toString());
            }
            catch (PluginException pe) {
                throw new IndexerException((Throwable)pe);
            }
            this.usernameMap = new HashMap<String, String>();
            this.passwordMap = new HashMap<String, String>();
            this.solr = this.initCore("solr");
            this.anotar = this.initCore("anotar");
            this.solrServerMap = new HashMap<String, SolrServer>();
            JsonObject indexerConfig = this.config.getObject(new Object[]{"indexer"});
            List<String> hardcodedValues = Arrays.asList("type", "properties", "useCache", "buffer", "solr", "anotar");
            for (Object key : indexerConfig.keySet()) {
                String keyString;
                if (!(key instanceof String) || hardcodedValues.contains(keyString = (String)key)) continue;
                this.solrServerMap.put(keyString, this.initCore(keyString));
            }
            this.anotarAutoCommit = this.config.getBoolean(Boolean.valueOf(true), new Object[]{"indexer", "anotar", "autocommit"});
            this.propertiesId = this.config.getString(DEFAULT_METADATA_PAYLOAD, new Object[]{"indexer", "propertiesId"});
            this.customParams = new HashMap<String, String>();
            this.scriptCache = new HashMap();
            this.configCache = new HashMap();
            this.useCache = this.config.getBoolean(Boolean.valueOf(true), new Object[]{"indexer", "useCache"});
        }
        this.loaded = true;
    }

    public void setCustomParam(String property, String value) {
        this.customParams.put(property, value);
    }

    private SolrServer initCore(String coreName) {
        try {
            String uri = this.config.getString(null, new Object[]{"indexer", coreName, "uri"});
            if (uri == null) {
                this.log.error("No URI provided for core: '{}'", (Object)coreName);
                return null;
            }
            URI solrUri = new URI(uri);
            CommonsHttpSolrServer thisCore = new CommonsHttpSolrServer(solrUri.toURL());
            String username = this.config.getString(null, new Object[]{"indexer", coreName, "username"});
            String password = this.config.getString(null, new Object[]{"indexer", coreName, "password"});
            this.usernameMap.put(coreName, username);
            this.passwordMap.put(coreName, password);
            if (username != null && password != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
                HttpClient hc = thisCore.getHttpClient();
                hc.getParams().setAuthenticationPreemptive(true);
                hc.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
            }
            return thisCore;
        }
        catch (MalformedURLException mue) {
            this.log.error(coreName + " : Malformed URL", (Throwable)mue);
        }
        catch (URISyntaxException urise) {
            this.log.error(coreName + " : Invalid URI", (Throwable)urise);
        }
        return null;
    }

    public void shutdown() throws PluginException {
        this.getPyUtils().shutdown();
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void search(SearchRequest request, OutputStream response) throws IndexerException {
        SolrSearcher searcher = new SolrSearcher(((CommonsHttpSolrServer)this.solr).getBaseURL());
        String username = this.usernameMap.get("solr");
        String password = this.passwordMap.get("solr");
        if (username != null && password != null) {
            searcher.authenticate(username, password);
        }
        try {
            request.addParam("wt", "json");
            InputStream result = searcher.get(request.getQuery(), request.getParamsMap(), false);
            IOUtils.copy((InputStream)result, (OutputStream)response);
            result.close();
        }
        catch (IOException ioe) {
            throw new IndexerException((Throwable)ioe);
        }
    }

    public void search(SearchRequest request, OutputStream response, String format) throws IndexerException {
        SolrSearcher searcher = new SolrSearcher(((CommonsHttpSolrServer)this.solr).getBaseURL());
        String username = this.usernameMap.get("solr");
        String password = this.passwordMap.get("solr");
        if (username != null && password != null) {
            searcher.authenticate(username, password);
        }
        try {
            request.addParam("wt", format);
            InputStream result = searcher.get(request.getQuery(), request.getParamsMap(), false);
            IOUtils.copy((InputStream)result, (OutputStream)response);
            result.close();
        }
        catch (IOException ioe) {
            throw new IndexerException((Throwable)ioe);
        }
    }

    public void remove(String oid) throws IndexerException {
        this.log.debug("Deleting " + oid + " from index");
        try {
            this.solr.deleteByQuery("storage_id:\"" + oid + "\"");
            this.solr.commit();
        }
        catch (SolrServerException sse) {
            throw new IndexerException((Throwable)sse);
        }
        catch (IOException ioe) {
            throw new IndexerException((Throwable)ioe);
        }
    }

    public void remove(String oid, String pid) throws IndexerException {
        this.log.debug("Deleting {}::{} from index", (Object)oid, (Object)pid);
        try {
            this.solr.deleteByQuery("storage_id:\"" + oid + "\" AND identifer:\"" + pid + "\"");
            this.solr.commit();
        }
        catch (SolrServerException sse) {
            throw new IndexerException((Throwable)sse);
        }
        catch (IOException ioe) {
            throw new IndexerException((Throwable)ioe);
        }
    }

    public void annotateRemove(String oid) throws IndexerException {
        this.log.debug("Deleting " + oid + " from Anotar index");
        try {
            this.anotar.deleteByQuery("rootUri:\"" + oid + "\"");
            this.anotar.commit();
        }
        catch (SolrServerException sse) {
            throw new IndexerException((Throwable)sse);
        }
        catch (IOException ioe) {
            throw new IndexerException((Throwable)ioe);
        }
    }

    public void annotateRemove(String oid, String annoId) throws IndexerException {
        this.log.debug("Deleting {}::{} from Anotar index", (Object)oid, (Object)annoId);
        try {
            this.anotar.deleteByQuery("rootUri:\"" + oid + "\" AND id:\"" + annoId + "\"");
            this.anotar.commit();
        }
        catch (SolrServerException sse) {
            throw new IndexerException((Throwable)sse);
        }
        catch (IOException ioe) {
            throw new IndexerException((Throwable)ioe);
        }
    }

    public void index(String oid) throws IndexerException {
        try {
            DigitalObject object = this.storage.getObject(oid);
            String[] oldManifest = new String[]{};
            for (String payloadId : oldManifest = object.getPayloadIdList().toArray(oldManifest)) {
                Payload payload = object.getPayload(payloadId);
                this.index(object, payload);
            }
        }
        catch (StorageException ex) {
            throw new IndexerException((Throwable)ex);
        }
    }

    public void index(String oid, String pid) throws IndexerException {
        try {
            DigitalObject object = this.storage.getObject(oid);
            Payload payload = object.getPayload(pid);
            this.index(object, payload);
        }
        catch (StorageException ex) {
            throw new IndexerException((Throwable)ex);
        }
    }

    public void index(DigitalObject object, Payload payload) throws IndexerException {
        Properties props;
        String oid = object.getId();
        String pid = payload.getId();
        if (pid.startsWith("anotar.")) {
            this.annotate(object, payload);
            return;
        }
        try {
            props = object.getMetadata();
        }
        catch (StorageException ex) {
            throw new IndexerException("Failed loading properties : ", (Throwable)ex);
        }
        try {
            String confOid = props.getProperty("jsonConfigOid");
            String rulesOid = props.getProperty("rulesOid");
            String doc = this.index(object, payload, confOid, rulesOid, props);
            String toClose = props.getProperty("objectRequiresClose");
            if (toClose != null) {
                this.log.debug("Indexing has altered metadata, closing object.");
                props.remove("objectRequiresClose");
                object.close();
                try {
                    props = object.getMetadata();
                }
                catch (StorageException ex) {
                    throw new IndexerException("Failed loading properties : ", (Throwable)ex);
                }
            }
            this.addToBuffer(oid + "/" + pid, doc);
        }
        catch (Exception e) {
            this.log.error("Indexing failed!\n-----\n", (Throwable)e);
        }
    }

    public void commit() {
        this.sendToIndex("{ \"event\" : \"commit\" }");
    }

    private void addToBuffer(String index, String document) {
        JsonObject message = new JsonObject();
        message.put((Object)"event", (Object)"index");
        message.put((Object)"index", (Object)index);
        message.put((Object)"document", (Object)document);
        this.sendToIndex(message.toString());
    }

    public void sendIndexToBuffer(String index, Map<String, List<String>> fields) {
        String doc = this.pyUtils.solrDocument(fields);
        this.addToBuffer(index, doc);
    }

    private void sendToIndex(String message) {
        try {
            this.getMessaging().queueMessage("solrwrapper", message);
        }
        catch (MessagingException ex) {
            this.log.error("Unable to send message: ", (Throwable)ex);
        }
    }

    public void annotate(String oid, String pid) throws IndexerException {
        try {
            DigitalObject object = this.storage.getObject(oid);
            Payload payload = object.getPayload(pid);
            this.annotate(object, payload);
        }
        catch (StorageException ex) {
            throw new IndexerException((Throwable)ex);
        }
    }

    private void annotate(DigitalObject object, Payload payload) throws IndexerException {
        String pid = payload.getId();
        if (this.propertiesId.equals(pid)) {
            return;
        }
        try {
            Properties props = new Properties();
            props.setProperty("metaPid", pid);
            String doc = this.index(object, payload, null, ANOTAR_RULES_OID, props);
            if (doc != null) {
                doc = "<add>" + doc + "</add>";
                this.anotar.request((SolrRequest)new DirectXmlRequest("/update", doc));
                if (this.anotarAutoCommit) {
                    this.anotar.commit();
                }
            }
        }
        catch (Exception e) {
            this.log.error("Indexing failed!\n-----\n", (Throwable)e);
        }
    }

    public void searchByIndex(SearchRequest request, OutputStream response, String indexName) throws IndexerException {
        SolrSearcher searcher = new SolrSearcher(((CommonsHttpSolrServer)this.solrServerMap.get(indexName)).getBaseURL());
        String username = this.usernameMap.get(indexName);
        String password = this.passwordMap.get(indexName);
        if (username != null && password != null) {
            searcher.authenticate(username, password);
        }
        try {
            request.addParam("wt", "json");
            InputStream result = searcher.get(request.getQuery(), request.getParamsMap(), false);
            IOUtils.copy((InputStream)result, (OutputStream)response);
            result.close();
        }
        catch (IOException ioe) {
            throw new IndexerException((Throwable)ioe);
        }
    }

    public void annotateSearch(SearchRequest request, OutputStream response) throws IndexerException {
        SolrSearcher searcher = new SolrSearcher(((CommonsHttpSolrServer)this.anotar).getBaseURL());
        String username = this.usernameMap.get("anotar");
        String password = this.passwordMap.get("anotar");
        if (username != null && password != null) {
            searcher.authenticate(username, password);
        }
        try {
            request.addParam("wt", "json");
            InputStream result = searcher.get(request.getQuery(), request.getParamsMap(), false);
            IOUtils.copy((InputStream)result, (OutputStream)response);
            result.close();
        }
        catch (IOException ioe) {
            throw new IndexerException((Throwable)ioe);
        }
    }

    private String index(DigitalObject object, Payload payload, String confOid, String rulesOid, Properties props) throws IOException, RuleException {
        try {
            JsonSimpleConfig jsonConfig = this.getConfigFile(confOid);
            HashMap<String, Object> bindings = new HashMap<String, Object>();
            HashMap fields = new HashMap();
            bindings.put("fields", fields);
            bindings.put("jsonConfig", jsonConfig);
            bindings.put("indexer", this);
            bindings.put("object", object);
            bindings.put("payload", payload);
            bindings.put("params", props);
            bindings.put("pyUtils", this.getPyUtils());
            bindings.put("log", this.log);
            PyObject script = this.getPythonObject(rulesOid);
            if (script.__findattr__(SCRIPT_ACTIVATE_METHOD) != null) {
                script.invoke(SCRIPT_ACTIVATE_METHOD, Py.java2py(bindings));
                object.close();
            } else {
                this.log.warn("Activation method not found!");
            }
            return this.getPyUtils().solrDocument(fields);
        }
        catch (Exception e) {
            throw new RuleException((Throwable)e);
        }
    }

    private PyObject getPythonObject(String oid) {
        PyObject rulesObject = this.deCachePythonObject(oid);
        if (rulesObject != null) {
            return rulesObject;
        }
        if (oid.equals(ANOTAR_RULES_OID)) {
            InputStream inStream = this.getClass().getResourceAsStream("/anotar.py");
            this.log.debug("First time parsing rules script: 'ANOTAR'");
            rulesObject = this.evalScript(inStream, "anotar.py");
            this.cachePythonObject(oid, rulesObject);
            return rulesObject;
        }
        try {
            DigitalObject object = this.storage.getObject(oid);
            String scriptName = object.getSourceId();
            Payload payload = object.getPayload(scriptName);
            InputStream inStream = payload.open();
            this.log.debug("First time parsing rules script: '{}'", (Object)oid);
            rulesObject = this.evalScript(inStream, scriptName);
            payload.close();
            this.cachePythonObject(oid, rulesObject);
            return rulesObject;
        }
        catch (StorageException ex) {
            this.log.error("Rules file could not be retrieved! '{}'", (Object)oid, (Object)ex);
            return null;
        }
    }

    private JsonSimpleConfig getConfigFile(String oid) {
        if (oid == null) {
            return null;
        }
        JsonSimpleConfig configFile = this.deCacheConfig(oid);
        if (configFile != null) {
            return configFile;
        }
        try {
            DigitalObject object = this.storage.getObject(oid);
            Payload payload = object.getPayload(object.getSourceId());
            this.log.debug("First time parsing config file: '{}'", (Object)oid);
            configFile = new JsonSimpleConfig(payload.open());
            payload.close();
            this.cacheConfig(oid, configFile);
            return configFile;
        }
        catch (IOException ex) {
            this.log.error("Rules file could not be parsed! '{}'", (Object)oid, (Object)ex);
            return null;
        }
        catch (StorageException ex) {
            this.log.error("Rules file could not be retrieved! '{}'", (Object)oid, (Object)ex);
            return null;
        }
    }

    private PyObject evalScript(InputStream inStream, String scriptName) {
        PythonInterpreter python = new PythonInterpreter();
        python.execfile(inStream, scriptName);
        PyObject scriptClass = python.get(SCRIPT_CLASS_NAME);
        python.cleanup();
        return scriptClass.__call__();
    }

    private void cachePythonObject(String oid, PyObject pyObject) {
        if (this.useCache && pyObject != null) {
            this.scriptCache.put(oid, pyObject);
        }
    }

    private PyObject deCachePythonObject(String oid) {
        if (this.useCache && this.scriptCache.containsKey(oid)) {
            return this.scriptCache.get(oid);
        }
        return null;
    }

    private void cacheConfig(String oid, JsonSimpleConfig config) {
        if (this.useCache && config != null) {
            this.configCache.put(oid, config);
        }
    }

    private JsonSimpleConfig deCacheConfig(String oid) {
        if (this.useCache && this.configCache.containsKey(oid)) {
            return this.configCache.get(oid);
        }
        return null;
    }

    public List<Object> getJsonObjectWithField(String fieldName, String fieldValue) throws IndexerException {
        ArrayList<Object> objects = new ArrayList<Object>();
        try {
            String query = fieldName + ":" + fieldValue;
            this.log.debug("getJsonObjectWithField Query: " + query);
            SearchRequest request = new SearchRequest(query);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.search(request, out);
            SolrResult results = new SolrResult((InputStream)new ByteArrayInputStream(out.toByteArray()));
            this.log.debug("getJsonObjectWithField number of results: " + results.getNumFound());
            for (SolrDoc result : results.getResults()) {
                objects.add(result);
            }
        }
        catch (Exception ex) {
            this.log.debug("getJsonObjectWithField exception : " + ex);
            throw new IndexerException((Throwable)ex);
        }
        return objects;
    }
}

