/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.indexer.rules;

import com.googlecode.fascinator.api.indexer.rule.AddDoc;
import com.googlecode.fascinator.api.indexer.rule.Field;
import com.googlecode.fascinator.api.indexer.rule.Rule;
import com.googlecode.fascinator.api.indexer.rule.RuleException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBException;

public class ModifyField
extends Rule {
    private String fieldName;
    private String regex;
    private String replacement;

    public ModifyField(String fieldName, String replacement) {
        this(fieldName, null, replacement);
    }

    public ModifyField(String fieldName, String regex, String replacement) {
        super("Modify field", false);
        this.fieldName = fieldName;
        this.regex = regex;
        this.replacement = replacement;
    }

    public void run(Reader in, Writer out) throws RuleException {
        if (this.regex == null) {
            this.log("Changing all '" + this.fieldName + "' to value '" + this.replacement + "'");
        } else {
            this.log("Modifying '" + this.fieldName + "' matching '" + this.regex + "' with replacement '" + this.replacement + "'");
        }
        try {
            AddDoc addDoc = AddDoc.read((Reader)in);
            List fields = addDoc.getFields(this.fieldName);
            for (Field field : fields) {
                String newValue;
                if (this.regex == null) {
                    field.setValue(this.replacement);
                    continue;
                }
                String value = field.getValue();
                if (value.equals(newValue = value.replaceAll(this.regex, this.replacement))) {
                    this.log("Value '" + value + "' was unmodified");
                    continue;
                }
                field.setValue(newValue);
                this.log("Modified value '" + value + "' to '" + newValue + "'");
            }
            addDoc.write(out);
        }
        catch (JAXBException jaxbe) {
            throw new RuleException(jaxbe.getLinkedException());
        }
    }
}

