/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.indexer;

import com.googlecode.fascinator.common.BasicHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrSearcher {
    public static String QUERY_ALL = "*:*";
    private Logger log = LoggerFactory.getLogger(SolrSearcher.class);
    private BasicHttpClient client;
    private String baseUrl;

    public SolrSearcher(String solrBaseUrl) {
        this.baseUrl = solrBaseUrl;
        this.client = new BasicHttpClient(solrBaseUrl);
    }

    public void authenticate(String username, String password) {
        this.client.authenticate(username, password);
    }

    public InputStream get() throws IOException {
        return this.get(null);
    }

    public InputStream get(String query) throws IOException {
        return this.get(query, true);
    }

    public InputStream get(String query, boolean escape) throws IOException {
        return this.get(query, null, escape);
    }

    public InputStream get(String query, Map<String, Set<String>> extras, boolean escape) throws IOException {
        if (query == null) {
            query = "*:*";
        } else if (!QUERY_ALL.equals(query) && escape) {
            query = query.replaceAll(":", "\\\\:");
        }
        String selectUrl = this.baseUrl + "/select";
        NameValuePair[] postData = this.getPostData(query, extras);
        this.log.debug("URL:{}, POSTDATA:{}", (Object)selectUrl, (Object)postData);
        PostMethod method = new PostMethod(selectUrl);
        method.addRequestHeader("Content-type", "application/x-www-form-urlencoded; charset=UTF-8");
        method.setRequestBody(postData);
        int status = this.client.executeMethod((HttpMethodBase)method, true);
        if (status == 200) {
            return method.getResponseBodyAsStream();
        }
        return null;
    }

    private NameValuePair[] getPostData(String query, Map<String, Set<String>> extras) throws UnsupportedEncodingException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new NameValuePair("q", query));
        if (extras != null) {
            for (String key : extras.keySet()) {
                Set<String> values = extras.get(key);
                for (String value : values) {
                    params.add(new NameValuePair(key, value));
                }
            }
        }
        return params.toArray(new NameValuePair[0]);
    }
}

