/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.indexer.rules;

import com.googlecode.fascinator.api.indexer.rule.AddDoc;
import com.googlecode.fascinator.api.indexer.rule.Field;
import com.googlecode.fascinator.api.indexer.rule.Rule;
import com.googlecode.fascinator.api.indexer.rule.RuleException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;

public class CheckField
extends Rule {
    private String fieldName;
    private String regex;
    private boolean matchAll;

    public CheckField(String fieldName) {
        this(fieldName, ".+", false);
    }

    public CheckField(String fieldName, String regex) {
        this(fieldName, regex, false);
    }

    public CheckField(String fieldName, boolean matchAll) {
        this(fieldName, ".+", matchAll);
    }

    public CheckField(String fieldName, String regex, boolean matchAll) {
        super("Check field", true);
        this.fieldName = fieldName;
        this.regex = regex;
        this.matchAll = matchAll;
    }

    public void run(Reader in, Writer out) throws RuleException {
        this.log("Checking " + (this.matchAll ? "ALL '" : "AT LEAST ONE '") + this.fieldName + "' match '" + this.regex + "'");
        try {
            AddDoc addDoc = AddDoc.read((Reader)in);
            List fields = addDoc.getFields(this.fieldName);
            int valid = 0;
            for (Field field : fields) {
                String value = field.getValue();
                boolean match = Pattern.matches(this.regex, field.getValue());
                if (match) {
                    ++valid;
                    this.log("'" + value + "' matches");
                    continue;
                }
                this.log("'" + value + "' does not match");
            }
            int diff = fields.size() - valid;
            if (this.matchAll && diff > 0) {
                throw new RuleException("All " + this.fieldName + " values must match " + this.regex);
            }
            if (!this.matchAll && valid == 0) {
                throw new RuleException("At least one " + this.fieldName + " value must match " + this.regex);
            }
            this.log("OK");
            addDoc.write(out);
        }
        catch (JAXBException jaxbe) {
            throw new RuleException(jaxbe.getLinkedException());
        }
    }
}

