/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.indexer.rules;

import com.googlecode.fascinator.api.indexer.rule.AddDoc;
import com.googlecode.fascinator.api.indexer.rule.Field;
import com.googlecode.fascinator.api.indexer.rule.Rule;
import com.googlecode.fascinator.api.indexer.rule.RuleException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBException;

public class CopyField
extends Rule {
    private String sourceFieldName;
    private String newFieldName;

    public CopyField(String newFieldName, String sourceFieldName) {
        super("Copy field");
        this.newFieldName = newFieldName;
        this.sourceFieldName = sourceFieldName;
    }

    public void run(Reader in, Writer out) throws RuleException {
        this.log("Copying field " + this.sourceFieldName + " as " + this.newFieldName);
        try {
            AddDoc addDoc = AddDoc.read((Reader)in);
            List sourceFields = addDoc.getFields(this.sourceFieldName);
            for (Field sourceField : sourceFields) {
                Field newField = new Field(this.newFieldName, sourceField.getValue());
                addDoc.getFields().add(newField);
            }
            addDoc.write(out);
        }
        catch (JAXBException jaxbe) {
            throw new RuleException(jaxbe.getLinkedException());
        }
    }
}

