/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.indexer.rules;

import com.googlecode.fascinator.api.indexer.rule.AddDoc;
import com.googlecode.fascinator.api.indexer.rule.Field;
import com.googlecode.fascinator.api.indexer.rule.Rule;
import com.googlecode.fascinator.api.indexer.rule.RuleException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBException;

public class LowercaseField
extends Rule {
    private String fieldName;

    public LowercaseField(String fieldName) {
        super("Lowercase field", false);
        this.fieldName = fieldName;
    }

    public void run(Reader in, Writer out) throws RuleException {
        this.log("Changing '" + this.fieldName + "' value to lower case");
        try {
            AddDoc addDoc = AddDoc.read((Reader)in);
            List fields = addDoc.getFields(this.fieldName);
            for (Field field : fields) {
                field.setValue(field.getValue().toLowerCase());
            }
            addDoc.write(out);
        }
        catch (JAXBException jaxbe) {
            throw new RuleException(jaxbe.getLinkedException());
        }
    }
}

