/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.roles.internal;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.roles.Roles;
import com.googlecode.fascinator.api.roles.RolesException;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalRoles
implements Roles {
    private final Logger log = LoggerFactory.getLogger(InternalRoles.class);
    private static String DEFAULT_FILE_NAME = "roles.properties";
    private String file_path;
    private Properties file_store;
    private Map<String, List<String>> user_list;
    private Map<String, List<String>> role_list;
    private String[] defaultRoles = null;

    public String getId() {
        return "internal";
    }

    public String getName() {
        return "Internal Roles";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(String jsonString) throws RolesException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonString));
        }
        catch (IOException e) {
            throw new RolesException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws RolesException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonFile));
        }
        catch (IOException ioe) {
            throw new RolesException((Throwable)ioe);
        }
    }

    public void setConfig(JsonSimpleConfig config) throws IOException {
        this.file_path = config.getString(null, new Object[]{"roles", "internal", "path"});
        this.loadRoles();
        JSONArray roleJsonArray = (JSONArray)config.getObject(new Object[]{"roles", "internal"}).get((Object)"defaultRoles");
        if (roleJsonArray != null) {
            this.defaultRoles = (String[])Arrays.copyOf(roleJsonArray.toArray(), roleJsonArray.size(), String[].class);
        }
    }

    public void loadRoles() throws IOException {
        this.file_store = new Properties();
        try {
            String[] users;
            File user_file = new File(this.file_path);
            if (!user_file.exists()) {
                user_file.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(user_file);
                IOUtils.copy((InputStream)this.getClass().getResourceAsStream("/" + DEFAULT_FILE_NAME), (OutputStream)out);
                ((OutputStream)out).close();
            }
            this.file_store.load(new FileInputStream(this.file_path));
            this.user_list = new LinkedHashMap<String, List<String>>();
            this.role_list = new LinkedHashMap<String, List<String>>();
            ArrayList<String> my_roles = new ArrayList<String>();
            List<String> users_with_role = new ArrayList<String>();
            for (String user : users = this.file_store.keySet().toArray(new String[this.file_store.size()])) {
                String[] roles;
                my_roles = new ArrayList();
                for (String role : roles = this.file_store.getProperty(user).split(",")) {
                    users_with_role = new ArrayList();
                    my_roles.add(role);
                    if (this.role_list.containsKey(role)) {
                        users_with_role = this.role_list.get(role);
                    }
                    users_with_role.add(user);
                    this.role_list.put(role, users_with_role);
                }
                this.user_list.put(user, my_roles);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void saveRoles() throws IOException {
        if (this.file_store != null) {
            try {
                this.file_store.store(new FileOutputStream(this.file_path), "");
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void shutdown() throws RolesException {
    }

    public String[] getRoles(String username) {
        if (this.user_list.containsKey(username)) {
            return this.user_list.get(username).toArray(new String[0]);
        }
        if (this.defaultRoles == null) {
            return new String[0];
        }
        return this.defaultRoles;
    }

    public String[] getUsersInRole(String role) {
        if (this.role_list.containsKey(role)) {
            return this.role_list.get(role).toArray(new String[0]);
        }
        return new String[0];
    }

    public boolean supportsRoleManagement() {
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setRole(String username, String newrole) throws RolesException {
        ArrayList arrayList = new ArrayList();
        if (this.user_list.containsKey(username)) {
            void var3_5;
            List<String> roles_of_user = this.user_list.get(username);
            if (roles_of_user.contains(newrole)) throw new RolesException("User '" + username + "' already has role '" + newrole + "'!");
            roles_of_user.add(newrole);
            this.user_list.put(username, roles_of_user);
            if (this.role_list.containsKey(newrole)) {
                List<String> list = this.role_list.get(newrole);
            }
            var3_5.add(username);
            this.role_list.put(newrole, (List<String>)var3_5);
            String roles = StringUtils.join((Object[])roles_of_user.toArray(new String[0]), (String)",");
            this.file_store.setProperty(username, roles);
            try {
                this.saveRoles();
                return;
            }
            catch (IOException e) {
                throw new RolesException((Throwable)e);
            }
        } else {
            ArrayList empty = new ArrayList();
            this.user_list.put(username, empty);
            this.setRole(username, newrole);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeRole(String username, String oldrole) throws RolesException {
        void var3_5;
        ArrayList arrayList = new ArrayList();
        if (!this.user_list.containsKey(username)) throw new RolesException("User '" + username + "' does not exist!");
        List<String> roles_of_user = this.user_list.get(username);
        if (!roles_of_user.contains(oldrole)) throw new RolesException("User '" + username + "' does not have the role '" + oldrole + "'!");
        roles_of_user.remove(oldrole);
        this.user_list.put(username, roles_of_user);
        if (this.role_list.containsKey(oldrole)) {
            List<String> list = this.role_list.get(oldrole);
        }
        var3_5.remove(username);
        if (var3_5.size() < 1) {
            this.role_list.remove(oldrole);
        } else {
            this.role_list.put(oldrole, (List<String>)var3_5);
        }
        String roles = StringUtils.join((Object[])roles_of_user.toArray(new String[0]), (String)",");
        this.file_store.setProperty(username, roles);
        try {
            this.saveRoles();
            return;
        }
        catch (IOException e) {
            throw new RolesException((Throwable)e);
        }
    }

    public void createRole(String rolename) throws RolesException {
        throw new RolesException("Role creation is not support by this plugin as a stand-alone function. Call setRole() with a new role and it will be created automatically.");
    }

    public void deleteRole(String rolename) throws RolesException {
        if (this.role_list.containsKey(rolename)) {
            List<String> users_with_role = this.role_list.get(rolename);
            for (String user : users_with_role) {
                List<String> roles_of_user = this.user_list.get(user);
                roles_of_user.remove(rolename);
                this.user_list.put(user, roles_of_user);
                String roles = StringUtils.join((Object[])roles_of_user.toArray(new String[0]), (String)",");
                this.file_store.setProperty(user, roles);
            }
            this.role_list.remove(rolename);
            try {
                this.saveRoles();
            }
            catch (IOException e) {
                throw new RolesException((Throwable)e);
            }
        } else {
            throw new RolesException("Cannot find role '" + rolename + "'!");
        }
    }

    public void renameRole(String oldrole, String newrole) throws RolesException {
        if (this.role_list.containsKey(oldrole)) {
            List<String> users_with_role = this.role_list.get(oldrole);
            for (String user : users_with_role) {
                List<String> roles_of_user = this.user_list.get(user);
                roles_of_user.remove(oldrole);
                roles_of_user.add(newrole);
                this.user_list.put(user, roles_of_user);
                String roles = StringUtils.join((Object[])roles_of_user.toArray(new String[0]), (String)",");
                this.file_store.setProperty(user, roles);
            }
            this.role_list.remove(oldrole);
            this.role_list.put(newrole, users_with_role);
            try {
                this.saveRoles();
            }
            catch (IOException e) {
                throw new RolesException((Throwable)e);
            }
        } else {
            throw new RolesException("Cannot find role '" + oldrole + "'!");
        }
    }

    public String[] searchRoles(String search) throws RolesException {
        String[] roles = this.role_list.keySet().toArray(new String[this.role_list.size()]);
        ArrayList<String> found = new ArrayList<String>();
        for (int i = 0; i < roles.length; ++i) {
            if (!roles[i].toLowerCase().contains(search.toLowerCase())) continue;
            found.add(roles[i]);
        }
        return found.toArray(new String[found.size()]);
    }
}

