/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.roles.ldap;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.roles.Roles;
import com.googlecode.fascinator.api.roles.RolesException;
import com.googlecode.fascinator.authentication.ldap.LdapAuthenticationHandler;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPRoles
implements Roles {
    private static final String CONFIG_PROP_ROLES = "roles";
    private static final String CONFIG_PROP_LDAP = "ldap";
    private final Logger log = LoggerFactory.getLogger(LDAPRoles.class);
    private LdapAuthenticationHandler ldapAuthHandler;

    public String getId() {
        return CONFIG_PROP_LDAP;
    }

    public String getName() {
        return "LDAP Roles";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(String jsonString) throws RolesException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonString));
        }
        catch (IOException e) {
            throw new RolesException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws RolesException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonFile));
        }
        catch (IOException ioe) {
            throw new RolesException((Throwable)ioe);
        }
    }

    public void setConfig(JsonSimpleConfig config) throws IOException {
        String url = config.getString(null, new Object[]{CONFIG_PROP_ROLES, CONFIG_PROP_LDAP, "baseURL"});
        String baseDN = config.getString(null, new Object[]{CONFIG_PROP_ROLES, CONFIG_PROP_LDAP, "baseDN"});
        String idAttribute = config.getString(null, new Object[]{CONFIG_PROP_ROLES, CONFIG_PROP_LDAP, "idAttribute"});
        String filterPrefix = config.getString("", new Object[]{CONFIG_PROP_ROLES, CONFIG_PROP_LDAP, "filterPrefix"});
        String filterSuffix = config.getString("", new Object[]{CONFIG_PROP_ROLES, CONFIG_PROP_LDAP, "filterSuffix"});
        String ldapRoleAttribute = config.getString("objectClass", new Object[]{CONFIG_PROP_ROLES, CONFIG_PROP_LDAP, "ldapRoleAttribute"});
        HashMap<String, List> ldapToFascinatorRolesMap = new HashMap<String, List>();
        List objectClassRolesList = config.getJsonSimpleList(new Object[]{CONFIG_PROP_ROLES, CONFIG_PROP_LDAP, "ldapRoleMap"});
        if (objectClassRolesList != null) {
            for (JsonSimple q : objectClassRolesList) {
                String ldapRole = q.getString(null, new Object[]{"ldapRoleAttrValue"});
                List fascinatorRolesList = q.getStringList(new Object[]{CONFIG_PROP_ROLES});
                ldapToFascinatorRolesMap.put(ldapRole, fascinatorRolesList);
            }
        }
        this.ldapAuthHandler = new LdapAuthenticationHandler(url, baseDN, ldapRoleAttribute, idAttribute, filterPrefix, filterSuffix, ldapToFascinatorRolesMap);
    }

    public void shutdown() throws RolesException {
    }

    public String[] getRoles(String username) {
        return this.ldapAuthHandler.getRoles(username).toArray(new String[0]);
    }

    public String[] getUsersInRole(String role) {
        return new String[0];
    }

    public boolean supportsRoleManagement() {
        return false;
    }

    public void setRole(String username, String newrole) throws RolesException {
        throw new RolesException("Cannot set role with LDAP plugin!");
    }

    public void removeRole(String username, String oldrole) throws RolesException {
        throw new RolesException("Cannot remove role with LDAP plugin!");
    }

    public void createRole(String rolename) throws RolesException {
        throw new RolesException("Role creation is not support by this plugin as a stand-alone function. Call setRole() with a new role and it will be created automatically.");
    }

    public void deleteRole(String rolename) throws RolesException {
        throw new RolesException("Cannot delete role with LDAP plugin!");
    }

    public void renameRole(String oldrole, String newrole) throws RolesException {
        throw new RolesException("Cannot rename role with LDAP plugin!");
    }

    public String[] searchRoles(String search) throws RolesException {
        throw new RolesException("Cannot search roles with LDAP plugin!");
    }
}

