/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.storage.filesystem;

import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.MimeTypeUtil;
import com.googlecode.fascinator.common.storage.impl.GenericPayload;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemPayload
extends GenericPayload {
    private Logger log = LoggerFactory.getLogger(FileSystemPayload.class);
    private static PayloadType DEFAULT_PAYLOAD_TYPE = PayloadType.Enrichment;
    private static String METADATA_SUFFIX = ".meta";
    private File dataFile;
    private File metaFile;

    public FileSystemPayload(String id, File payloadFile) {
        super(id);
        this.dataFile = payloadFile;
        this.metaFile = new File(this.dataFile.getParentFile(), this.dataFile.getName() + METADATA_SUFFIX);
    }

    public void readExistingMetadata() {
        block11: {
            if (this.metaFile.exists()) {
                Properties props = new Properties();
                try {
                    FileReader metaReader = new FileReader(this.metaFile);
                    props.load(metaReader);
                    ((Reader)metaReader).close();
                }
                catch (FileNotFoundException ex) {
                    this.log.error("Failed reading metadata file", (Throwable)ex);
                }
                catch (IOException ex) {
                    this.log.error("Failed accessing metadata file", (Throwable)ex);
                }
                this.setId(props.getProperty("id", this.getId()));
                String type = props.getProperty("payloadType", DEFAULT_PAYLOAD_TYPE.toString());
                this.setType(PayloadType.valueOf((String)type));
                this.setLabel(props.getProperty("label", this.getId()));
                String link = props.getProperty("linked", String.valueOf(this.isLinked()));
                this.setLinked(Boolean.parseBoolean(link));
                if (this.isLinked()) {
                    try {
                        long fileSize = this.dataFile.length();
                        if (fileSize > 2000L) {
                            this.log.debug("Linked file '{}' is unusually large. It is most likely not really linked and is corrupt", (Object)this.dataFile.getAbsolutePath());
                            break block11;
                        }
                        String linkPath = FileUtils.readFileToString((File)this.dataFile);
                        File linkFile = new File(linkPath);
                        if (linkFile.exists()) {
                            this.setContentType(MimeTypeUtil.getMimeType((File)linkFile));
                            break block11;
                        }
                        this.log.debug("Linked file '{}' no longer exists!", (Object)linkFile.getAbsolutePath());
                    }
                    catch (IOException ioe) {
                        this.log.warn("Failed to get linked file", (Throwable)ioe);
                    }
                } else {
                    this.setContentType(MimeTypeUtil.getMimeType((File)this.dataFile));
                }
            } else {
                this.writeMetadata();
            }
        }
    }

    public void writeMetadata() {
        if (this.getLabel() == null) {
            this.setLabel(this.dataFile.getName());
        }
        if (this.getType() == null) {
            this.setType(PayloadType.Source);
        }
        if (this.getContentType() == null) {
            this.setContentType(MimeTypeUtil.getMimeType((File)this.dataFile));
        }
        try {
            if (!this.metaFile.exists()) {
                this.metaFile.getParentFile().mkdirs();
                this.metaFile.createNewFile();
            }
            Properties props = new Properties();
            FileOutputStream metaOut = new FileOutputStream(this.metaFile);
            props.setProperty("id", this.getId());
            props.setProperty("payloadType", this.getType().toString());
            props.setProperty("label", this.getLabel());
            props.setProperty("linked", String.valueOf(this.isLinked()));
            if (this.getContentType() != null) {
                props.setProperty("contentType", this.getContentType());
            }
            props.store(metaOut, "Payload metadata for " + this.dataFile.getAbsolutePath());
            ((OutputStream)metaOut).close();
        }
        catch (IOException ioe) {
            this.log.warn("Failed to read/write metaFile", (Throwable)ioe);
        }
    }

    public InputStream open() throws StorageException {
        if (this.isLinked()) {
            try {
                String linkPath = FileUtils.readFileToString((File)this.dataFile);
                File linkFile = new File(linkPath);
                if (!linkFile.exists()) {
                    throw new StorageException("External file not found : " + linkFile.getAbsolutePath());
                }
                FileInputStream in = new FileInputStream(linkFile);
                return in;
            }
            catch (IOException ex) {
                throw new StorageException((Throwable)ex);
            }
        }
        try {
            FileInputStream in = new FileInputStream(this.dataFile);
            return in;
        }
        catch (FileNotFoundException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    public void close() throws StorageException {
        super.close();
        if (this.hasMetaChanged()) {
            this.writeMetadata();
        }
    }

    public Long lastModified() {
        if (this.isLinked()) {
            try {
                String linkPath = FileUtils.readFileToString((File)this.dataFile);
                File linkFile = new File(linkPath);
                if (!linkFile.exists()) {
                    this.log.error("Error! File does not exist: '{}'", (Object)linkFile.getAbsolutePath());
                    return null;
                }
                return linkFile.lastModified();
            }
            catch (IOException ex) {
                this.log.error("Error reading file from disk: ", (Throwable)ex);
                return null;
            }
        }
        return this.dataFile.lastModified();
    }

    public Long size() {
        if (this.isLinked()) {
            try {
                String linkPath = FileUtils.readFileToString((File)this.dataFile);
                File linkFile = new File(linkPath);
                if (!linkFile.exists()) {
                    this.log.error("Error! File does not exist: '{}'", (Object)linkFile.getAbsolutePath());
                    return null;
                }
                return linkFile.length();
            }
            catch (IOException ex) {
                this.log.error("Error reading file from disk: ", (Throwable)ex);
                return null;
            }
        }
        return this.dataFile.length();
    }
}

