/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.storage.filesystem;

import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.DummyFileLock;
import com.googlecode.fascinator.common.storage.impl.GenericDigitalObject;
import com.googlecode.fascinator.storage.filesystem.FileSystemPayload;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemDigitalObject
extends GenericDigitalObject {
    private Logger log = LoggerFactory.getLogger(FileSystemDigitalObject.class);
    private static String METADATA_SUFFIX = ".meta";
    private static String MANIFEST_LOCK_FILE = "manifest.lock";
    private File homeDir;
    private File lockFile;
    private DummyFileLock manifestLock;

    public FileSystemDigitalObject(File homeDir, String oid) {
        super(oid);
        this.homeDir = homeDir;
        this.buildLock();
        this.lockManifest();
        this.buildManifest();
        this.unlockManifest();
    }

    public String getPath() {
        return this.homeDir.getAbsolutePath();
    }

    private void buildLock() {
        try {
            String lockPath = this.getPath() + File.separator + "manifest.lock";
            this.lockFile = new File(lockPath);
            if (!this.lockFile.exists()) {
                this.lockFile.getParentFile().mkdirs();
                this.lockFile.createNewFile();
            }
            this.manifestLock = new DummyFileLock(lockPath);
        }
        catch (IOException ex) {
            this.log.error("Failed accessing manifest lock", (Throwable)ex);
        }
    }

    private void lockManifest() {
        try {
            this.manifestLock.getLock();
        }
        catch (IOException ex) {
            this.log.error("Failed acquiring manifest lock : ", (Throwable)ex);
        }
    }

    private void unlockManifest() {
        try {
            this.manifestLock.release();
        }
        catch (IOException ex) {
            this.log.error("Failed releasing manifest lock : ", (Throwable)ex);
        }
    }

    private void buildManifest() {
        Map manifest = this.getManifest();
        this.readFromDisk(manifest, this.homeDir, 0);
    }

    private void readFromDisk(Map<String, Payload> manifest, File dir, int depth) {
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.endsWith(METADATA_SUFFIX)) {
                    return false;
                }
                return !name.endsWith(MANIFEST_LOCK_FILE);
            }
        });
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    FileSystemPayload payload = null;
                    File payloadFile = file;
                    if (depth > 0) {
                        File parentFile = file.getParentFile();
                        String relPath = "";
                        for (int i = 0; i < depth; ++i) {
                            relPath = parentFile.getName() + File.separator + relPath;
                            parentFile = parentFile.getParentFile();
                        }
                        payloadFile = new File(relPath, file.getName());
                        payload = new FileSystemPayload(relPath + file.getName(), new File(this.homeDir, payloadFile.getPath()));
                    } else {
                        payload = new FileSystemPayload(payloadFile.getName(), payloadFile);
                    }
                    payload.readExistingMetadata();
                    if (payload.getType().equals((Object)PayloadType.Source)) {
                        this.setSourceId(payload.getId());
                    }
                    manifest.put(payload.getId(), (Payload)payload);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.readFromDisk(manifest, file, depth + 1);
            }
        }
    }

    public Payload createStoredPayload(String pid, InputStream in) throws StorageException {
        Payload payload = this.createPayload(pid, in, false);
        return payload;
    }

    public Payload createLinkedPayload(String pid, String linkPath) throws StorageException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(linkPath.getBytes("UTF-8"));
            Payload payload = this.createPayload(pid, in, true);
            return payload;
        }
        catch (UnsupportedEncodingException ex) {
            throw new StorageException((Throwable)ex);
        }
    }

    private Payload createPayload(String pid, InputStream in, boolean linked) throws StorageException {
        this.lockManifest();
        Map manifest = this.getManifest();
        if (manifest.containsKey(pid)) {
            this.unlockManifest();
            throw new StorageException("ID '" + pid + "' already exists in manifest.");
        }
        File newFile = new File(this.homeDir, pid);
        if (newFile.exists()) {
            this.unlockManifest();
            throw new StorageException("ID '" + pid + "' already exists on disk.");
        }
        newFile.getParentFile().mkdirs();
        try {
            newFile.createNewFile();
        }
        catch (IOException ex) {
            this.unlockManifest();
            this.log.error("Error creating file (" + newFile.getAbsolutePath() + ")");
            throw new StorageException("Failed to create file", (Throwable)ex);
        }
        try {
            FileOutputStream out = new FileOutputStream(newFile);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
        }
        catch (FileNotFoundException ex) {
            this.log.error("Failed saving payload to disk", (Throwable)ex);
        }
        catch (IOException ex) {
            this.log.error("Failed saving payload to disk", (Throwable)ex);
        }
        FileSystemPayload payload = new FileSystemPayload(pid, newFile);
        if (this.getSourceId() == null) {
            payload.setType(PayloadType.Source);
            this.setSourceId(pid);
        } else {
            payload.setType(PayloadType.Enrichment);
        }
        payload.setLinked(linked);
        payload.writeMetadata();
        manifest.put(pid, payload);
        this.unlockManifest();
        return payload;
    }

    public Payload getPayload(String pid) throws StorageException {
        this.lockManifest();
        this.unlockManifest();
        Map man = this.getManifest();
        if (man.containsKey(pid)) {
            return (Payload)man.get(pid);
        }
        this.buildManifest();
        man = this.getManifest();
        if (man.containsKey(pid)) {
            return (Payload)man.get(pid);
        }
        throw new StorageException("ID '" + pid + "' does not exist.");
    }

    public void removePayload(String pid) throws StorageException {
        this.lockManifest();
        Map manifest = this.getManifest();
        if (!manifest.containsKey(pid)) {
            throw new StorageException("pID '" + pid + "' not found.");
        }
        ((Payload)manifest.get(pid)).close();
        File realFile = new File(this.homeDir, pid);
        File metaFile = new File(this.homeDir, pid + METADATA_SUFFIX);
        boolean result = false;
        if (realFile.exists() && !(result = FileUtils.deleteQuietly((File)realFile))) {
            System.out.println("Deleting : " + realFile.getAbsolutePath());
            throw new StorageException("Failed to delete : " + realFile.getAbsolutePath());
        }
        if (metaFile.exists() && !(result = FileUtils.deleteQuietly((File)metaFile))) {
            System.out.println("Deleting : " + realFile.getAbsolutePath());
            throw new StorageException("Failed to delete : " + metaFile.getAbsolutePath());
        }
        manifest.remove(pid);
        this.unlockManifest();
    }

    public Payload updatePayload(String pid, InputStream in) throws StorageException {
        this.lockManifest();
        File oldFile = new File(this.homeDir, pid);
        if (!oldFile.exists()) {
            throw new StorageException("pID '" + pid + "': file not found");
        }
        try {
            FileOutputStream out = new FileOutputStream(oldFile);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
        }
        catch (FileNotFoundException ex) {
            this.log.error("Failed saving payload to disk", (Throwable)ex);
        }
        catch (IOException ex) {
            this.log.error("Failed saving payload to disk", (Throwable)ex);
        }
        this.unlockManifest();
        FileSystemPayload payload = (FileSystemPayload)this.getPayload(pid);
        payload.writeMetadata();
        return payload;
    }

    public String toString() {
        return String.format("%s [%s]", this.getId(), this.homeDir);
    }

    public void close() throws StorageException {
        try {
            super.close();
        }
        catch (StorageException storageException) {
            // empty catch block
        }
        this.unlockManifest();
    }
}

