/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.storage.filesystem;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.FascinatorHome;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.storage.filesystem.FileSystemDigitalObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemStorage
implements Storage {
    private static final String DEFAULT_HOME_DIR = FascinatorHome.getPath((String)"storage");
    private static final String DEFAULT_EMAIL = "fascinator@usq.edu.au";
    private final Logger log = LoggerFactory.getLogger(FileSystemStorage.class);
    private File homeDir;
    private String email;
    private Set<String> objectList;
    private static String DEFAULT_METADATA_PAYLOAD = "TF-OBJ-META";

    public String getId() {
        return "file-system";
    }

    public String getName() {
        return "File System Storage";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public File getHomeDir() {
        return this.homeDir;
    }

    public void init(String jsonString) throws StorageException {
        try {
            this.setVariable(new JsonSimpleConfig(jsonString));
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws StorageException {
        try {
            this.setVariable(new JsonSimpleConfig(jsonFile));
        }
        catch (IOException ioe) {
            throw new StorageException((Throwable)ioe);
        }
    }

    private void setVariable(JsonSimpleConfig config) {
        this.email = config.getString(DEFAULT_EMAIL, new Object[]{"email"});
        String home = config.getString(DEFAULT_HOME_DIR, new Object[]{"storage", "file-system", "home"});
        this.homeDir = new File(home, DigestUtils.md5Hex((String)this.email));
        if (!this.homeDir.exists()) {
            this.homeDir.mkdirs();
        }
    }

    public void shutdown() throws StorageException {
    }

    private File getPath(String oid) throws StorageException {
        if (oid.length() < 6) {
            throw new StorageException("oID '" + oid + "' length must be greater than 6.");
        }
        String dir = oid.substring(0, 2) + File.separator + oid.substring(2, 4) + File.separator + oid.substring(4, 6) + File.separator;
        File file = new File(this.homeDir, dir + oid);
        return file;
    }

    public DigitalObject createObject(String oid) throws StorageException {
        File objHome = this.getPath(oid);
        if (objHome.exists()) {
            throw new StorageException("oID '" + oid + "' already exists in storage.");
        }
        return new FileSystemDigitalObject(objHome, oid);
    }

    public DigitalObject getObject(String oid) throws StorageException {
        File objHome = this.getPath(oid);
        if (objHome.exists()) {
            FileSystemDigitalObject obj = new FileSystemDigitalObject(objHome, oid);
            return obj;
        }
        throw new StorageException("oID '" + oid + "' doesn't exist in storage.");
    }

    public void removeObject(String oid) throws StorageException {
        File objHome = this.getPath(oid);
        if (objHome.exists()) {
            FileSystemDigitalObject object = new FileSystemDigitalObject(objHome, oid);
            String[] oldManifest = new String[]{};
            for (String pid : oldManifest = object.getPayloadIdList().toArray(oldManifest)) {
                try {
                    object.removePayload(pid);
                }
                catch (StorageException ex) {
                    this.log.error("Error deleting payload", (Throwable)ex);
                }
            }
            try {
                object.close();
                FileUtils.deleteDirectory((File)objHome);
            }
            catch (IOException ex) {
                throw new StorageException("Error deleting object", (Throwable)ex);
            }
        } else {
            throw new StorageException("oID '" + oid + "' doesn't exist in storage : " + objHome.getPath());
        }
    }

    public Set<String> getObjectIdList() {
        if (this.objectList == null) {
            this.objectList = new HashSet<String>();
            ArrayList<File> files = new ArrayList<File>();
            this.listFileRecur(files, this.homeDir);
            for (File file : files) {
                Properties sofMeta = new Properties();
                try {
                    FileInputStream is = new FileInputStream(file);
                    sofMeta.load(is);
                    String objectId = sofMeta.getProperty("objectId");
                    if (objectId == null) {
                        objectId = file.getParentFile().getName();
                        this.log.warn("Null object ID found in '{}', inferring from path: '{}'", (Object)file.getAbsolutePath(), (Object)objectId);
                    }
                    this.objectList.add(objectId);
                }
                catch (FileNotFoundException e) {
                    this.log.error("Error reading object metadata file", (Throwable)e);
                }
                catch (IOException e) {
                    this.log.error("Error loading properties metadata", (Throwable)e);
                }
            }
        }
        return this.objectList;
    }

    private void listFileRecur(List<File> files, File path) {
        if (path.isDirectory()) {
            for (File file : path.listFiles()) {
                if (path.isDirectory()) {
                    this.listFileRecur(files, file);
                    continue;
                }
                if (!file.getName().equals(DEFAULT_METADATA_PAYLOAD)) continue;
                files.add(file);
            }
        } else if (path.getName().equals(DEFAULT_METADATA_PAYLOAD)) {
            files.add(path);
        }
    }
}

