/*
 * Decompiled with CFR 0.152.
 */
package au.com.redboxresearchdata.fascinator.storage.mongo;

import au.com.redboxresearchdata.fascinator.storage.mongo.MongoPayload;
import com.googlecode.fascinator.api.storage.JsonDigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.storage.impl.GenericDigitalObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tika.Tika;
import org.bson.Document;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDigitalObject
extends GenericDigitalObject
implements JsonDigitalObject {
    private static String METADATA_PAYLOAD = "TF-OBJ-META";
    private static Logger log = LoggerFactory.getLogger(MongoDigitalObject.class);
    protected MongoDatabase mongoDb;
    protected String collectionName;
    protected String objectMetadataCollectionName;
    protected String oid;
    protected String sourceId;
    protected Document objectMetadata;
    protected Document recordMetadata;
    protected Properties metadataProp;
    protected PayloadBackend payloadBackend;
    protected Map<String, String> encodedChars;
    protected DateTimeFormatter df;

    public MongoDigitalObject(MongoDatabase mongoDb, String collectionName, String objectMetadataCollectionName, String oid, PayloadBackend payloadBackend) {
        super(oid);
        this.mongoDb = mongoDb;
        this.collectionName = collectionName;
        this.oid = oid;
        this.objectMetadataCollectionName = objectMetadataCollectionName;
        this.payloadBackend = payloadBackend;
        this.encodedChars = new HashMap<String, String>();
        this.encodedChars.put(".", "_dot_");
        this.encodedChars.put("$", "_dollar_");
        this.df = ISODateTimeFormat.dateTime();
    }

    public MongoDatabase getMongoDb() {
        return this.mongoDb;
    }

    public String getId() {
        return this.oid;
    }

    public void setId(String oid) {
        this.oid = oid;
    }

    public String getSourceId() {
        List<Map<String, Object>> files = this.getFileList();
        if (files != null) {
            for (Map<String, Object> fileInfo : files) {
                if (!PayloadType.Source.toString().equals(fileInfo.get("payloadType"))) continue;
                this.sourceId = (String)fileInfo.get("pid");
            }
        }
        if (files != null && files.size() > 0) {
            this.sourceId = (String)files.get(0).get("pid");
        }
        return this.sourceId;
    }

    public void setSourceId(String pid) {
        this.sourceId = pid;
    }

    public Properties getMetadata() throws StorageException {
        this.getObjectMetadata();
        if (this.metadataProp == null) {
            this.metadataProp = new Properties();
            this.metadataProp.putAll((Map<?, ?>)this.objectMetadata);
        }
        return this.metadataProp;
    }

    private Document getObjectMetadataFromDb() {
        MongoCollection<Document> metaCol = this.getObjectMetadataCollection();
        return (Document)metaCol.find(Filters.eq((String)"redboxOid", (Object)this.oid)).first();
    }

    private MongoCollection<Document> getObjectMetadataCollection() {
        return this.mongoDb.getCollection(this.objectMetadataCollectionName);
    }

    public Map<String, Payload> getManifest() {
        List<Map<String, Object>> payloads;
        Map manifest;
        if (this.objectMetadata == null) {
            try {
                this.getMetadata();
            }
            catch (StorageException e) {
                throw new RuntimeException("Failed to get metadata:", e);
            }
        }
        if ((manifest = super.getManifest()).isEmpty() && (payloads = this.getFileList()) != null && payloads.size() > 0) {
            for (Map<String, Object> payloadMeta : payloads) {
                String pid = (String)payloadMeta.get("pid");
                manifest.put(pid, new MongoPayload(this, pid, (String)payloadMeta.get("fileId"), this.payloadBackend));
            }
        }
        return manifest;
    }

    private Map<String, Object> getFileInfo(String pid) {
        Map<String, Object> fileInfo2 = null;
        List<Map<String, Object>> payloads = this.getFileList();
        if (payloads != null && payloads.size() > 0) {
            for (Map<String, Object> fileInfo2 : payloads) {
                String pidMeta = (String)fileInfo2.get("pid");
                if (!pidMeta.equals(pid)) continue;
                return fileInfo2;
            }
        }
        return fileInfo2;
    }

    public Set<String> getPayloadIdList() {
        return this.getManifest().keySet();
    }

    private synchronized Payload createPayload(String pid, InputStream source, boolean linked, PayloadType payloadType) throws IOException, StorageException {
        Map<String, Payload> manifest = this.getManifest();
        if (manifest.containsKey(pid)) {
            throw new StorageException("ID '" + pid + "' already exists in manifest.");
        }
        MongoPayload payload = new MongoPayload(this, pid, null, this.payloadBackend);
        payload.setLinked(linked);
        payload.setType(payloadType);
        Tika tika = new Tika();
        String mimeType = tika.detect(pid);
        payload.setContentType(mimeType);
        payload.create(source);
        manifest.put(pid, (Payload)payload);
        this.addFileMeta(payload);
        this.save();
        payload.setMetaChanged(false);
        return payload;
    }

    public synchronized Payload createStoredPayload(String pid, InputStream in) throws StorageException {
        if (pid == null || in == null) {
            throw new StorageException("Error; Null parameter recieved");
        }
        try {
            PayloadType type = null;
            if (METADATA_PAYLOAD.equals(pid)) {
                type = PayloadType.Annotation;
            } else if (this.getSourceId() == null) {
                if (pid.endsWith("json") || pid.endsWith("tfpackage")) {
                    type = PayloadType.Source;
                    this.setSourceId(pid);
                } else {
                    type = PayloadType.Annotation;
                }
            } else {
                type = PayloadType.Annotation;
            }
            Payload payload = this.createPayload(pid, in, false, type);
            return payload;
        }
        catch (Exception e) {
            throw new StorageException((Throwable)e);
        }
    }

    public Payload createLinkedPayload(String pid, String linkPath) throws StorageException {
        log.warn("This storage plugin does not support linked payloads... converting to stored.");
        try {
            FileInputStream in = new FileInputStream(linkPath);
            return this.createStoredPayload(pid, in);
        }
        catch (FileNotFoundException fnfe) {
            throw new StorageException((Throwable)fnfe);
        }
    }

    public Payload getPayload(String pid) throws StorageException {
        if (pid == null) {
            throw new StorageException("Error; Null PID recieved");
        }
        Map<String, Payload> manifest = this.getManifest();
        if (!manifest.containsKey(pid)) {
            throw new StorageException("pID '" + pid + "': was not found");
        }
        Map<String, Object> fileInfo = this.getFileInfo(pid);
        return new MongoPayload(this, pid, (String)fileInfo.get("payloadId"), this.payloadBackend);
    }

    public void removePayload(String pid) throws StorageException {
        MongoPayload payload = (MongoPayload)this.getPayload(pid);
        payload.remove();
        this.removeFileMeta(pid);
        this.getManifest().remove(pid);
        this.save();
    }

    public synchronized Payload updatePayload(String pid, InputStream in) throws StorageException {
        MongoPayload payload = (MongoPayload)this.getPayload(pid);
        this.getManifest().remove(pid);
        this.removeFileMeta(pid);
        payload.update(in);
        this.getManifest().put(pid, (Payload)payload);
        this.addFileMeta(payload);
        this.save();
        return payload;
    }

    public void close() throws StorageException {
        this.save();
    }

    public Map<String, Object> getObjectMetadata() {
        if (this.objectMetadata == null) {
            this.objectMetadata = this.getUnescapedDoc(this.getObjectMetadataFromDb());
            if (this.objectMetadata == null) {
                this.objectMetadata = new Document();
                this.objectMetadata.put("redboxOid", (Object)this.oid);
                this.objectMetadata.put("collectionName", (Object)this.collectionName);
                this.objectMetadata.put("date_object_created", (Object)this.df.print(new Date().getTime()));
            }
        }
        return this.objectMetadata;
    }

    public Map<String, Object> getRecordMetadata() {
        if (this.recordMetadata == null) {
            this.recordMetadata = this.getUnescapedDoc(this.getRecordMetadataFromDb());
            if (this.recordMetadata == null) {
                this.recordMetadata = new Document();
                this.recordMetadata.put("redboxOid", (Object)this.oid);
            }
        }
        return this.recordMetadata;
    }

    protected Document getRecordMetadataFromDb() {
        return (Document)this.getMetaCollection().find(Filters.eq((String)"redboxOid", (Object)this.oid)).first();
    }

    public boolean existsInStorage() {
        return this.getObjectMetadataFromDb() != null;
    }

    protected MongoCollection<Document> getMetaCollection() {
        return this.mongoDb.getCollection(this.collectionName);
    }

    public synchronized void save() throws StorageException {
        MongoCollection<Document> objectMetaCol = this.getObjectMetadataCollection();
        MongoCollection<Document> metaCol = this.getMetaCollection();
        boolean isInStorage = this.existsInStorage();
        if (!isInStorage) {
            this.getObjectMetadata();
            this.mergeMetaProp();
            objectMetaCol.insertOne((Object)this.getEscapedDoc(this.objectMetadata));
            this.getRecordMetadata();
            metaCol.insertOne((Object)this.getEscapedDoc(this.recordMetadata));
        } else {
            this.objectMetadata.put("date_object_modified", (Object)this.df.print(new Date().getTime()));
            this.mergeMetaProp();
            objectMetaCol.findOneAndReplace(Filters.eq((String)"redboxOid", (Object)this.oid), (Object)this.getEscapedDoc(this.objectMetadata));
            metaCol.findOneAndReplace(Filters.eq((String)"redboxOid", (Object)this.oid), (Object)this.getEscapedDoc(this.recordMetadata));
        }
    }

    private void mergeMetaProp() {
        if (this.metadataProp != null && !this.metadataProp.isEmpty()) {
            log.info("merging properties...");
            for (Map.Entry<Object, Object> entry : this.metadataProp.entrySet()) {
                this.objectMetadata.put((String)entry.getKey(), entry.getValue());
            }
            log.info(this.objectMetadata.toString());
        } else {
            log.info("Trying to merge meta properties, but there was nothing there.");
        }
    }

    public Document getEscapedDoc(Document source) {
        Document escapedVer = null;
        if (source != null) {
            escapedVer = new Document();
            for (String key : source.keySet()) {
                escapedVer.put(this.escapeKey(key), source.get((Object)key));
                Object val = source.get((Object)key);
                if (!(val instanceof Map) && !(val instanceof List)) continue;
                if (val instanceof List) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (Object entryVal : (List)val) {
                        if (entryVal instanceof Map) {
                            list.add(this.getEscapedDoc(new Document((Map)entryVal)));
                            continue;
                        }
                        list.add(entryVal);
                    }
                    escapedVer.put(this.escapeKey(key), list);
                    continue;
                }
                escapedVer.put(this.escapeKey(key), (Object)this.getEscapedDoc(new Document((Map)val)));
            }
        }
        return escapedVer;
    }

    public Document getUnescapedDoc(Document source) {
        Document unEscapedVer = null;
        if (source != null) {
            unEscapedVer = new Document();
            for (String key : source.keySet()) {
                unEscapedVer.put(this.unescapeKey(key), source.get((Object)key));
                Object val = source.get((Object)key);
                if (!(val instanceof Map) && !(val instanceof List)) continue;
                if (val instanceof List) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (Object entryVal : (List)val) {
                        if (entryVal instanceof Map) {
                            list.add(this.getUnescapedDoc((Document)entryVal));
                            continue;
                        }
                        list.add(entryVal);
                    }
                    unEscapedVer.put(this.unescapeKey(key), list);
                    continue;
                }
                unEscapedVer.put(this.unescapeKey(key), (Object)this.getUnescapedDoc((Document)source.get((Object)key)));
            }
        }
        return unEscapedVer;
    }

    private String escapeKey(String key) {
        for (String encodedKey : this.encodedChars.keySet()) {
            key = key.replace(encodedKey, this.encodedChars.get(encodedKey));
        }
        return key;
    }

    private String unescapeKey(String key) {
        for (String encodedKey : this.encodedChars.keySet()) {
            String decodedKey = this.encodedChars.get(encodedKey);
            key = key.replace(decodedKey, encodedKey);
        }
        return key;
    }

    public void load() throws StorageException {
        boolean isInStorage = this.existsInStorage();
        if (!isInStorage) {
            throw new StorageException("Object with OID: " + this.oid + ", doesn't exist!");
        }
        this.getObjectMetadata();
        this.getRecordMetadata();
    }

    public void remove() throws StorageException {
        MongoCollection<Document> objectMetaCol = this.getObjectMetadataCollection();
        MongoCollection<Document> metaCol = this.getMetaCollection();
        boolean isInStorage = this.existsInStorage();
        if (!isInStorage) {
            throw new StorageException("Object with OID: " + this.oid + ", doesn't exist!");
        }
        objectMetaCol.findOneAndDelete(Filters.eq((String)"redboxOid", (Object)this.oid));
        metaCol.findOneAndDelete(Filters.eq((String)"redboxOid", (Object)this.oid));
    }

    public List<Map<String, Object>> getFileList() {
        if (this.recordMetadata == null) {
            return null;
        }
        return (List)this.recordMetadata.get((Object)"files");
    }

    protected void addFileMeta(MongoPayload payload) {
        List<Map<String, Object>> files = this.getFileList();
        if (files == null) {
            files = new ArrayList<Map<String, Object>>();
            this.recordMetadata.put("files", files);
        }
        Map<String, Object> info = payload.getMetadataDoc();
        files.add(info);
    }

    protected void removeFileMeta(String pid) {
        List<Map<String, Object>> files = this.getFileList();
        Map<String, Object> metaToRemove = null;
        if (files != null) {
            for (Map<String, Object> info : files) {
                if (!info.get("pid").equals(pid)) continue;
                metaToRemove = info;
            }
            if (metaToRemove != null) {
                files.remove(metaToRemove);
            }
        }
    }

    public void updatePayloadMeta(MongoPayload payload) throws StorageException {
        this.removeFileMeta(payload.getId());
        this.addFileMeta(payload);
        this.save();
        payload.setMetaChanged(false);
    }

    public Map<String, Object> getPayloadMeta(String pid) {
        List<Map<String, Object>> files = this.getFileList();
        Map<String, Object> metaToFind = null;
        if (files != null) {
            for (Map<String, Object> info : files) {
                if (!info.get("pid").equals(pid)) continue;
                metaToFind = info;
            }
        }
        return metaToFind;
    }

    static enum PayloadBackend {
        MONGO;

    }
}

