/*
 * Decompiled with CFR 0.152.
 */
package au.com.redboxresearchdata.fascinator.storage.mongo;

import au.com.redboxresearchdata.fascinator.storage.mongo.MongoDigitalObject;
import au.com.redboxresearchdata.fascinator.storage.mongo.MongoPayloadBackend;
import au.com.redboxresearchdata.fascinator.storage.mongo.MongoPayloadBackendCollection;
import au.com.redboxresearchdata.fascinator.storage.mongo.MongoPayloadBackendGridFs;
import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.storage.impl.GenericPayload;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoPayload
extends GenericPayload {
    private static Logger log = LoggerFactory.getLogger(MongoPayload.class);
    protected MongoDigitalObject obj;
    protected Date lastModified;
    protected String pid;
    protected MongoDigitalObject.PayloadBackend backendType;
    protected MongoPayloadBackend backend;
    protected String fileId;
    protected boolean hasChangedBackendType;

    public MongoPayload(MongoDigitalObject obj, String pid, String fileId, MongoDigitalObject.PayloadBackend backend) {
        super(pid);
        List<Map<String, Object>> files;
        this.obj = obj;
        this.pid = pid;
        this.backendType = backend;
        this.setLabel(pid);
        this.setMetaChanged(false);
        this.fileId = fileId;
        if (fileId != null && (files = obj.getFileList()) != null) {
            for (Map<String, Object> fileInfo : files) {
                if (!pid.equals(fileInfo.get("pid"))) continue;
                this.setMetadataDoc(new Document(fileInfo));
            }
        }
    }

    public Map<String, Object> getMetadataDoc() {
        Document doc = new Document();
        doc.append("pid", (Object)this.getId());
        doc.append("linked", (Object)this.isLinked());
        doc.append("label", (Object)this.getLabel());
        doc.append("payloadType", (Object)this.getType().toString());
        doc.append("oid", (Object)this.obj.oid);
        doc.append("contentType", (Object)this.getContentType());
        doc.append("backend", (Object)this.backendType.toString());
        doc.append("backend_type", (Object)this.getBackend().getType());
        doc.append("payloadId", (Object)this.getPayloadId());
        doc.append("lastModified", (Object)this.lastModified);
        Document backendMeta = this.getBackend().getMetadata();
        if (backendMeta != null) {
            doc.append(this.getBackend().getId(), (Object)backendMeta);
        }
        System.out.println(doc.toJson());
        return doc;
    }

    private Document getMetadataDocLocal() {
        Document doc = new Document();
        doc.append("pid", (Object)this.getId());
        doc.append("oid", (Object)this.obj.oid);
        doc.append("contentType", (Object)this.getContentType());
        return doc;
    }

    public void setMetadataDoc(Document doc) {
        this.setId(doc.getString((Object)"pid"));
        this.setLinked(doc.getBoolean((Object)"linked", false));
        this.setLabel(doc.getString((Object)"label"));
        this.setType(PayloadType.valueOf((String)doc.getString((Object)"payloadType")));
        this.setContentType(doc.getString((Object)"contentType"));
        this.lastModified = doc.getDate((Object)"lastModified");
        this.getBackend().setId(doc.getString((Object)"payloadId"));
    }

    private Date getLastModified() {
        return this.lastModified;
    }

    private MongoPayloadBackend getBackend() {
        if (this.backend == null || this.hasChangedBackendType) {
            PayloadType type = this.getType();
            switch (type) {
                case Source: {
                    this.backend = new MongoPayloadBackendCollection(this.obj, this.pid);
                    break;
                }
                default: {
                    this.backend = new MongoPayloadBackendGridFs(this.obj.oid + "/" + this.pid, this.fileId, this.obj.getMongoDb());
                }
            }
            this.hasChangedBackendType = false;
        }
        return this.backend;
    }

    public void create(InputStream source) throws StorageException {
        this.lastModified = new Date();
        this.getBackend().create(source, this.getMetadataDocLocal());
        this.fileId = this.getBackend().getId();
    }

    public InputStream open() throws StorageException {
        return this.getBackend().open();
    }

    public void close() throws StorageException {
        this.save();
    }

    public void save() throws StorageException {
        if (this.hasMetaChanged()) {
            this.lastModified = new Date();
            this.obj.updatePayloadMeta(this);
        } else {
            System.out.println("Payload closed, not meta changed.");
        }
    }

    public Long size() {
        return this.getBackend().size();
    }

    public Long lastModified() {
        return this.getLastModified().getTime();
    }

    public String getPayloadId() {
        return this.getBackend().getId();
    }

    public void remove() {
        this.getBackend().remove();
        this.lastModified = null;
    }

    public void update(InputStream source) throws StorageException {
        this.remove();
        this.create(source);
    }

    public void setType(PayloadType type) {
        if (type != this.getType()) {
            this.hasChangedBackendType = true;
        }
        super.setType(type);
    }
}

