/*
 * Decompiled with CFR 0.152.
 */
package au.com.redboxresearchdata.fascinator.storage.mongo;

import au.com.redboxresearchdata.fascinator.storage.mongo.MongoDigitalObject;
import au.com.redboxresearchdata.fascinator.storage.mongo.MongoPayloadBackend;
import com.google.gson.Gson;
import com.googlecode.fascinator.api.storage.StorageException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.bson.Document;

public class MongoPayloadBackendCollection
implements MongoPayloadBackend {
    static String SOURCE_FIELD = "source";
    static String PAYLOAD_FIELD = "payload";
    static String METADATA_FIELD = "metadata";
    static String TYPE = "COLLECTION_EMBEDDED";
    MongoDigitalObject obj;
    String pid;
    Document mainDoc;

    public MongoPayloadBackendCollection(MongoDigitalObject obj, String pid) {
        this.obj = obj;
        this.pid = pid;
        Map<String, Object> payloadMeta = obj.getPayloadMeta(pid);
        if (payloadMeta != null) {
            this.mainDoc = (Document)payloadMeta.get(this.getId());
        }
        if (this.mainDoc == null) {
            this.mainDoc = new Document();
        }
    }

    @Override
    public Document getMetadata() {
        return this.mainDoc;
    }

    @Override
    public void setMetadata(Document doc) {
        this.mainDoc = doc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void create(InputStream source, Document metadata) throws StorageException {
        System.out.println("------------- Creating PID: " + this.pid);
        try {
            Document sourceDoc = this.getDocumentFromJsonStream(source);
            if (sourceDoc == null) {
                if (!this.obj.existsInStorage()) throw new StorageException("Cannot create payload with empty data.");
                System.out.println("Swallowing error.... there was an attempt to update a payload using empty data.");
                return;
            } else {
                this.mainDoc.put(PAYLOAD_FIELD, (Object)sourceDoc);
                this.mainDoc.put(METADATA_FIELD, (Object)metadata);
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new StorageException((Throwable)e);
        }
    }

    private Document getDocumentFromJsonStream(InputStream source) throws Exception {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)source, (Writer)writer, (String)"UTF-8");
            String jsonStr = writer.toString();
            System.out.println("Converint to Document:");
            System.out.println(jsonStr);
            Gson gson = new Gson();
            Document document = new Document();
            document = (Document)gson.fromJson(jsonStr, document.getClass());
            return document;
        }
        catch (Exception e) {
            System.out.println("Failed to create document from JSON stream:");
            e.printStackTrace();
            throw e;
        }
    }

    private Document getDoc() {
        return (Document)this.mainDoc.get((Object)PAYLOAD_FIELD);
    }

    @Override
    public InputStream open() {
        return new ByteArrayInputStream(this.getBytes());
    }

    private byte[] getBytes() {
        String s = this.getAsString();
        System.out.println("Get as string: " + s);
        return s.getBytes();
    }

    public String getAsString() {
        Document document = this.getDoc();
        StringBuilder writer = new StringBuilder();
        Gson gson = new Gson();
        gson.toJson((Object)document, (Appendable)writer);
        return writer.toString();
    }

    @Override
    public Long size() {
        return this.getBytes().length;
    }

    @Override
    public String getId() {
        return SOURCE_FIELD;
    }

    @Override
    public void remove() {
        this.obj.removeFileMeta(this.pid);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void setId(String id) {
    }
}

