/*
 * Decompiled with CFR 0.152.
 */
package au.com.redboxresearchdata.fascinator.storage.mongo;

import au.com.redboxresearchdata.fascinator.storage.mongo.MongoPayloadBackend;
import com.googlecode.fascinator.api.storage.StorageException;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import java.io.InputStream;
import org.bson.Document;
import org.bson.types.ObjectId;

public class MongoPayloadBackendGridFs
implements MongoPayloadBackend {
    static String TYPE = "GRIDFS";
    protected String payloadPath;
    protected ObjectId mongoFileId;
    protected GridFSDownloadStream ds;
    protected MongoDatabase mongoDb;

    public MongoPayloadBackendGridFs(String payloadPath, String fileId, MongoDatabase db) {
        this.payloadPath = payloadPath;
        this.mongoDb = db;
        if (fileId != null) {
            this.mongoFileId = new ObjectId(fileId);
        }
    }

    @Override
    public void create(InputStream source, Document metadata) throws StorageException {
        GridFSUploadOptions options = new GridFSUploadOptions().metadata(metadata);
        this.mongoFileId = this.getBucket().uploadFromStream(this.payloadPath, source, options);
    }

    @Override
    public InputStream open() {
        this.ds = this.getBucket().openDownloadStream(this.mongoFileId);
        GridFSFile file = this.ds.getGridFSFile();
        this.mongoFileId = file.getObjectId();
        return this.ds;
    }

    @Override
    public Long size() {
        if (this.ds == null) {
            this.ds = this.getBucket().openDownloadStream(this.mongoFileId);
        }
        return this.ds.getGridFSFile().getLength();
    }

    @Override
    public String getId() {
        return this.mongoFileId.toString();
    }

    @Override
    public void setId(String id) {
        this.mongoFileId = new ObjectId(id);
    }

    @Override
    public void remove() {
        this.getBucket().delete(this.mongoFileId);
        this.ds = null;
        this.mongoFileId = null;
    }

    private GridFSBucket getBucket() {
        return GridFSBuckets.create((MongoDatabase)this.mongoDb);
    }

    @Override
    public Document getMetadata() {
        return new Document();
    }

    @Override
    public void setMetadata(Document doc) {
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

