/*
 * Decompiled with CFR 0.152.
 */
package au.com.redboxresearchdata.fascinator.storage.mongo;

import au.com.redboxresearchdata.fascinator.storage.mongo.MongoDigitalObject;
import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.JsonDigitalObject;
import com.googlecode.fascinator.api.storage.JsonStorage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Projections;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoStorage
implements JsonStorage {
    private JsonSimpleConfig systemConfig;
    private MongoClient mongoClient;
    private MongoDatabase mongoDb;
    private String defaultCollection;
    private String objectMetadataCollectionName;
    private String recordMetadataViewName;
    private MongoDigitalObject.PayloadBackend payloadBackend;

    public String getId() {
        return "mongodb-storage";
    }

    public String getName() {
        return "MongoDB Storage Plugin";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(File jsonFile) throws PluginException {
        try {
            this.systemConfig = new JsonSimpleConfig(jsonFile);
            this.init();
        }
        catch (IOException ioe) {
            throw new StorageException("Failed to read file configuration!", (Throwable)ioe);
        }
    }

    public void init(String jsonString) throws PluginException {
        try {
            this.systemConfig = new JsonSimpleConfig(jsonString);
            this.init();
        }
        catch (IOException ioe) {
            throw new StorageException("Failed to read string configuration!", (Throwable)ioe);
        }
    }

    private void init() {
        String host = this.systemConfig.getString("localhost", new Object[]{"storage", "mongo", "host"});
        int port = this.systemConfig.getInteger(Integer.valueOf(27017), new Object[]{"storage", "mongo", "port"});
        String db = this.systemConfig.getString("redbox", new Object[]{"storage", "mongo", "db"});
        boolean sslEnable = this.systemConfig.getBoolean(Boolean.valueOf(false), new Object[]{"storage", "mongo", "sslEnable"});
        String username = this.systemConfig.getString(null, new Object[]{"storage", "mongo", "username"});
        String password = this.systemConfig.getString(null, new Object[]{"storage", "mongo", "password"});
        this.defaultCollection = this.systemConfig.getString("default", new Object[]{"storage", "mongo", "defaultCollection"});
        this.objectMetadataCollectionName = this.systemConfig.getString("tf_obj_meta", new Object[]{"storage", "mongo", "metadataCollection"});
        this.recordMetadataViewName = this.systemConfig.getString("metadataDocuments", new Object[]{"storage", "mongo", "recordMetadataCollection"});
        String payloadBackendName = this.systemConfig.getString("MONGO", new Object[]{"storage", "mongo", "payload_backend"});
        this.payloadBackend = MongoDigitalObject.PayloadBackend.valueOf(payloadBackendName);
        MongoClientOptions.Builder optionBuilder = MongoClientOptions.builder().sslEnabled(sslEnable);
        ServerAddress addr = new ServerAddress(new InetSocketAddress(host, port));
        if (username == null) {
            this.mongoClient = new MongoClient(addr, optionBuilder.build());
        } else {
            ArrayList<MongoCredential> credentialsList = new ArrayList<MongoCredential>();
            credentialsList.add(MongoCredential.createCredential((String)username, (String)db, (char[])password.toCharArray()));
            this.mongoClient = new MongoClient(addr, credentialsList, optionBuilder.build());
        }
        this.mongoDb = this.mongoClient.getDatabase(db);
        this.createMetadataDocumentsView();
        this.createPackageViews();
    }

    private void createPackageViews() {
        JsonObject packageTypes = this.systemConfig.getObject(new Object[]{"portal", "packageTypes"});
        if (packageTypes != null) {
            for (Object keyObject : packageTypes.keySet()) {
                String key = (String)keyObject;
                List<BsonDocument> pipeline = Arrays.asList(BsonDocument.parse((String)("{$match: { 'packageType' : '" + key + "'}}")));
                if (key.equals("default") || key.equals(this.recordMetadataViewName)) {
                    key = key + "_package";
                }
                try {
                    this.mongoDb.createView(key, this.recordMetadataViewName, pipeline);
                }
                catch (MongoCommandException e) {
                    if (e.getCode() == 48) continue;
                    throw e;
                }
            }
        }
    }

    private void createMetadataDocumentsView() {
        block2: {
            List<BsonDocument> pipeline = Arrays.asList(BsonDocument.parse((String)"{$match: {files: { $elemMatch:{ pid: 'metadata.tfpackage'}}}}"), BsonDocument.parse((String)"{ $project: { files: { '$filter': { input: '$files', as: 'files', cond: {$eq: ['$$files.pid','metadata.tfpackage']}}}}}"), BsonDocument.parse((String)"{ $unwind:  '$files' }"), BsonDocument.parse((String)"{ $project: { 'metadata':'$files.source.payload', 'redboxOid': '$files.oid'}}"), BsonDocument.parse((String)"{$lookup: { from: 'tf_obj_meta', localField:'redboxOid', foreignField: 'redboxOid', as: 'tfObj'}}"), BsonDocument.parse((String)"{ $addFields: { 'metadata': { 'redboxOid':  '$redboxOid', 'packageType':'$tfObj.packageType', 'date_object_created':'$tfObj.date_object_created', 'date_object_modified':'$tfObj.date_object_modified' }}}"), BsonDocument.parse((String)"{ $replaceRoot: { newRoot: '$metadata'}}"));
            try {
                this.mongoDb.createView(this.recordMetadataViewName, this.defaultCollection, pipeline);
                MongoCollection collection = this.mongoDb.getCollection(this.defaultCollection);
                IndexOptions options = new IndexOptions().sparse(true).background(true);
                collection.createIndex(Indexes.ascending((String[])new String[]{"files.pid"}), options);
                collection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"files.pid", "files.source.payload.metaMetadata.brandId", "files.source.payload.metaMetadata.type", "files.source.payload.workflow.stage"})}), options.name("metaViewIndex"));
                options = new IndexOptions().sparse(true).background(true);
                collection = this.mongoDb.getCollection("tf_obj_meta");
                collection.createIndex(Indexes.ascending((String[])new String[]{"redboxOid"}), options);
            }
            catch (MongoCommandException e) {
                if (e.getCode() == 48) break block2;
                throw e;
            }
        }
    }

    public void shutdown() throws PluginException {
        this.mongoClient.close();
    }

    public DigitalObject createObject(String oid) throws StorageException {
        return this.createObject(oid, this.defaultCollection);
    }

    public synchronized JsonDigitalObject createObject(String oid, String collectionName) throws StorageException {
        if (oid == null) {
            throw new StorageException("Cannot create object in storage with NULL oid");
        }
        MongoDigitalObject obj = new MongoDigitalObject(this.mongoDb, collectionName, this.objectMetadataCollectionName, oid, this.payloadBackend);
        if (obj.existsInStorage()) {
            throw new StorageException("Error; object '" + oid + "' already exists in MongoDB");
        }
        obj.save();
        return obj;
    }

    public DigitalObject getObject(String oid) throws StorageException {
        return this.getObject(oid, this.defaultCollection);
    }

    public JsonDigitalObject getObject(String oid, String collectionName) throws StorageException {
        MongoDigitalObject obj = new MongoDigitalObject(this.mongoDb, collectionName, this.objectMetadataCollectionName, oid, this.payloadBackend);
        obj.load();
        return obj;
    }

    public void removeObject(String oid) throws StorageException {
        this.removeObject(oid, this.defaultCollection);
    }

    public void removeObject(String oid, String collectionName) throws StorageException {
        MongoDigitalObject obj = new MongoDigitalObject(this.mongoDb, collectionName, this.objectMetadataCollectionName, oid, this.payloadBackend);
        obj.remove();
    }

    public Set<String> getObjectIdList() {
        HashSet<String> objectIdList = new HashSet<String>();
        MongoCollection objectMetaCol = this.mongoDb.getCollection(this.objectMetadataCollectionName);
        List objectIds = (List)objectMetaCol.find((Bson)new Document()).projection(Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{"redboxOid"}), Projections.excludeId()})).into(new ArrayList());
        for (Document doc : objectIds) {
            objectIdList.add(doc.getString((Object)"redboxOid"));
        }
        return objectIdList;
    }

    public void dropDb() throws Exception {
        this.mongoDb.drop();
    }

    public JsonSimple pagedQuery(String collection, String filterString) throws IOException {
        return this.pagedQuery(collection, filterString, 0, 10, null);
    }

    public JsonSimple pagedQuery(String collection, String filterString, int startIndex, int rows, String sort) throws IOException {
        System.out.println("Running paged query on: " + collection + " using: " + filterString + " sort:" + sort);
        long startStamp = System.currentTimeMillis();
        List<BsonDocument> pipeline = Arrays.asList(BsonDocument.parse((String)("{$match:" + filterString + "}")), BsonDocument.parse((String)"{'$group':{'_id': null, 'numFound': {'$sum': 1 }, 'docs':{ '$push':'$$ROOT' }} },"), BsonDocument.parse((String)("{'$project': { 'numFound':1 , 'docs' : {'$slice': ['$docs'," + startIndex + "," + rows + "] }   }}")));
        if (sort != null) {
            ArrayList<BsonDocument> newpipeline = new ArrayList<BsonDocument>(pipeline);
            newpipeline.add(1, BsonDocument.parse((String)("{'$sort': {" + sort + "}}")));
            pipeline = newpipeline;
        }
        System.out.println("Pipeline:");
        System.out.println(pipeline.toString());
        AggregateIterable result = this.mongoDb.getCollection(collection).aggregate(pipeline).allowDiskUse(Boolean.valueOf(true));
        if (result.first() != null) {
            System.out.println("Query took: " + (System.currentTimeMillis() - startStamp));
            return new JsonSimple(((Document)result.first()).toJson());
        }
        return new JsonSimple("{\"_id\": null,  \"numFound\": 0,  \"docs\": []}");
    }

    public FindIterable<Document> query(String collection, String filterString) {
        BsonDocument filter = BsonDocument.parse((String)filterString);
        return this.mongoDb.getCollection(collection).find((Bson)filter);
    }

    public AggregateIterable<Document> aggregate(String collection, List<BsonDocument> pipeline) {
        return this.mongoDb.getCollection(collection).aggregate(pipeline);
    }
}

