/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.storage.ram;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.storage.impl.GenericDigitalObject;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamStorage
implements Storage {
    private final Logger log = LoggerFactory.getLogger(RamStorage.class);
    private Map<String, DigitalObject> manifest;

    public String getId() {
        return "ram";
    }

    public String getName() {
        return "RAM Storage";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(File jsonFile) throws StorageException {
    }

    public void init(String jsonString) throws StorageException {
    }

    public void shutdown() throws StorageException {
    }

    public DigitalObject createObject(String oid) throws StorageException {
        GenericDigitalObject newObject = new GenericDigitalObject(oid);
        this.getManifest().put(oid, (DigitalObject)newObject);
        return newObject;
    }

    public DigitalObject getObject(String oid) throws StorageException {
        if (this.getManifest().containsKey(oid)) {
            return this.getManifest().get(oid);
        }
        throw new StorageException("ID '" + oid + "' does no exist.");
    }

    public Set<String> getObjectIdList() {
        return this.getManifest().keySet();
    }

    public void removeObject(String oid) throws StorageException {
        this.getManifest().remove(oid);
    }

    public Map<String, DigitalObject> getManifest() {
        if (this.manifest == null) {
            this.manifest = new HashMap<String, DigitalObject>();
        }
        return this.manifest;
    }
}

