/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.subscriber.solrEventLog;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.subscriber.Subscriber;
import com.googlecode.fascinator.api.subscriber.SubscriberException;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.DirectXmlRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SolrEventLogSubscriber
implements Subscriber {
    private final Logger log = LoggerFactory.getLogger(SolrEventLogSubscriber.class);
    private static Integer BUFFER_LIMIT_DOCS = 200;
    private static Integer BUFFER_LIMIT_SIZE = 204800;
    private static Integer BUFFER_LIMIT_TIME = 30;
    private URI uri;
    private CommonsHttpSolrServer core;
    private List<String> docBuffer;
    private long bufferOldest;
    private long bufferYoungest;
    private int bufferSize;
    private int bufferDocLimit;
    private int bufferSizeLimit;
    private int bufferTimeLimit;
    private Timer timer;
    private String timerMDC;

    public String getId() {
        return "solr-event-log";
    }

    public String getName() {
        return "Solr Event Log Subscriber";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(String jsonString) throws SubscriberException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonString));
        }
        catch (IOException e) {
            throw new SubscriberException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws SubscriberException {
        try {
            this.setConfig(new JsonSimpleConfig(jsonFile));
        }
        catch (IOException ioe) {
            throw new SubscriberException((Throwable)ioe);
        }
    }

    private void setConfig(JsonSimpleConfig config) throws SubscriberException {
        try {
            this.uri = new URI(config.getString(null, new Object[]{"subscriber", "solr", "uri"}));
            if (this.uri == null) {
                throw new SubscriberException("No Solr URI provided");
            }
            this.core = new CommonsHttpSolrServer(this.uri.toURL());
            Thread.sleep(200L);
            this.core.ping();
            this.docBuffer = new ArrayList<String>();
            this.bufferSize = 0;
            this.bufferOldest = 0L;
            this.bufferDocLimit = config.getInteger(BUFFER_LIMIT_DOCS, new Object[]{"subscriber", "solr", "buffer", "docLimit"});
            this.bufferSizeLimit = config.getInteger(BUFFER_LIMIT_SIZE, new Object[]{"subscriber", "solr", "buffer", "sizeLimit"});
            this.bufferTimeLimit = config.getInteger(BUFFER_LIMIT_TIME, new Object[]{"subscriber", "solr", "buffer", "timeLimit"});
            this.timer = new Timer("SolrEventLog:" + this.toString(), true);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    SolrEventLogSubscriber.this.checkTimeout();
                }
            }, 0L, 10000L);
        }
        catch (Exception ex) {
            throw new SubscriberException((Throwable)ex);
        }
    }

    private void addToBuffer(String document) {
        if (this.timerMDC == null) {
            this.timerMDC = MDC.get((String)"name");
        }
        int length = document.length();
        this.bufferYoungest = new Date().getTime();
        if (this.docBuffer.isEmpty()) {
            this.bufferOldest = new Date().getTime();
            this.log.debug("=== New buffer starting: {}", (Object)this.bufferOldest);
        }
        this.docBuffer.add(document);
        this.bufferSize += length;
        this.checkBuffer();
    }

    private void checkTimeout() {
        if (this.timerMDC != null) {
            MDC.put((String)"name", (String)this.timerMDC);
        }
        if (this.docBuffer.isEmpty()) {
            return;
        }
        long wait = (new Date().getTime() - this.bufferYoungest) / 1000L;
        if (wait < 20L) {
            return;
        }
        this.log.debug("=== Flushing old buffer: {}s", (Object)wait);
        this.submitBuffer(true);
    }

    private void checkBuffer() {
        if (this.docBuffer.size() >= this.bufferDocLimit) {
            this.log.debug("=== Buffer check: Doc limit reached '{}'", (Object)this.docBuffer.size());
            this.submitBuffer(false);
            return;
        }
        if (this.bufferSize > this.bufferSizeLimit) {
            this.log.debug("=== Buffer check: Size exceeded '{}'", (Object)this.bufferSize);
            this.submitBuffer(false);
            return;
        }
        long age = (new Date().getTime() - this.bufferOldest) / 1000L;
        if (age > (long)this.bufferTimeLimit) {
            this.log.debug("=== Buffer check: Age exceeded '{}s'", (Object)age);
            this.submitBuffer(false);
            return;
        }
    }

    private void submitBuffer(boolean forceCommit) {
        int size = this.docBuffer.size();
        if (size > 0) {
            this.log.debug("=== Submitting buffer: " + size + " documents");
            String submission = "";
            for (String doc : this.docBuffer) {
                submission = submission + doc;
            }
            if (!submission.equals("")) {
                submission = "<add>" + submission + "</add>";
                try {
                    this.core.request((SolrRequest)new DirectXmlRequest("/update", submission));
                }
                catch (Exception ex) {
                    this.log.error("Error submitting documents to Solr!", (Throwable)ex);
                }
                if (forceCommit) {
                    this.log.info("Running forced commit!");
                    try {
                        this.core.commit();
                    }
                    catch (Exception e) {
                        this.log.warn("Solr forced commit failed. Document will not be visible until Solr autocommit fires. Error message: {}", (Throwable)e);
                    }
                }
            }
        }
        this.purgeBuffer();
    }

    private void purgeBuffer() {
        this.docBuffer.clear();
        this.bufferSize = 0;
        this.bufferOldest = 0L;
        this.bufferYoungest = 0L;
    }

    public void shutdown() throws SubscriberException {
        this.timer.cancel();
    }

    private void addToIndex(Map<String, String> param) throws Exception {
        String doc = this.writeUpdateString(param);
        this.addToBuffer(doc);
    }

    private String writeUpdateString(Map<String, String> param) {
        String fieldStr = "";
        for (String paramName : param.keySet()) {
            fieldStr = fieldStr + "<field name=\"" + paramName + "\">" + StringEscapeUtils.escapeXml((String)param.get(paramName)) + "</field>";
        }
        return "<add><doc>" + fieldStr + "</doc></add>";
    }

    public void onEvent(Map<String, String> param) throws SubscriberException {
        try {
            this.addToIndex(param);
        }
        catch (Exception e) {
            throw new SubscriberException("Fail to add log to solr" + e.getMessage());
        }
    }
}

