/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.aperture;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.api.transformer.Transformer;
import com.googlecode.fascinator.api.transformer.TransformerException;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.MimeTypeUtil;
import com.googlecode.fascinator.common.storage.StorageUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.ontoware.rdf2go.RDF2Go;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.Syntax;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.model.node.impl.URIImpl;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.ExtractorFactory;
import org.semanticdesktop.aperture.extractor.FileExtractor;
import org.semanticdesktop.aperture.extractor.FileExtractorFactory;
import org.semanticdesktop.aperture.extractor.impl.DefaultExtractorRegistry;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.rdf.impl.RDFContainerImpl;
import org.semanticdesktop.aperture.vocabulary.NIE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApertureTransformer
implements Transformer {
    private static Logger log = LoggerFactory.getLogger(ApertureTransformer.class);
    private JsonSimpleConfig config;
    private String outputPath = "";
    private boolean firstRun = true;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Extractor\nUsage: java Extractor <file>");
            System.exit(-1);
        }
        try {
            String sourceId = "/tmp/test.jpg";
            RDFContainer rdf = ApertureTransformer.extractRDF(args[0], sourceId);
            if (rdf != null) {
                System.out.println(rdf.getModel().serialize(Syntax.RdfXml));
            } else {
                System.out.println("Cannot locate file");
            }
        }
        catch (Exception e) {
            System.out.println("EXCEPTION");
            e.printStackTrace();
        }
    }

    public void init(String jsonString) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonString);
            this.reset();
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonFile);
            this.reset();
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    private void reset() throws TransformerException {
        if (this.firstRun) {
            this.firstRun = false;
            log.info("--Initializing Extractor plugin--");
            this.outputPath = this.config.getString(System.getProperty("java.io.tmpdir"), new Object[]{"aperture", "outputPath"});
        }
    }

    public static RDFContainer extractRDF(String file, String sourceId) throws IOException, ExtractorException, URISyntaxException {
        File f = ApertureTransformer.getFile(file);
        if (f != null) {
            return ApertureTransformer.extractRDF(f, sourceId);
        }
        return null;
    }

    public static File getFile(String file) throws URISyntaxException {
        File f = null;
        try {
            URL url = new URL(file);
            if (url.getProtocol().equals("file")) {
                f = new File(url.toURI());
            }
        }
        catch (MalformedURLException e) {
            f = new File(file);
        }
        if (f == null) {
            return null;
        }
        if (!f.exists()) {
            return null;
        }
        return f;
    }

    public static RDFContainer extractRDF(File file, String sourceId) throws IOException, ExtractorException {
        String mimeType = MimeTypeUtil.getMimeType((File)file);
        if (mimeType == null) {
            log.error("MIME Type = NULL, skipping RDF extraction.");
            return null;
        }
        return ApertureTransformer.extractRDF(file, mimeType, sourceId);
    }

    public static RDFContainer extractRDF(File file, String mimeType, String sourceId) throws IOException, ExtractorException {
        RDFContainer container = ApertureTransformer.createRDFContainer(sourceId);
        ApertureTransformer.determineExtractor(file, mimeType, container);
        return container;
    }

    private static RDFContainer createRDFContainer(String sourceId) {
        URIImpl uri = new URIImpl(sourceId);
        Model model = RDF2Go.getModelFactory().createModel();
        model.open();
        return new RDFContainerImpl(model, (URI)uri);
    }

    private static void determineExtractor(File file, String mimeType, RDFContainer container) throws IOException, ExtractorException {
        URIImpl uri = new URIImpl(file.toURI().toString());
        DefaultExtractorRegistry extractorRegistry = new DefaultExtractorRegistry();
        Set factories = extractorRegistry.getExtractorFactories(mimeType);
        if (factories == null || factories.isEmpty()) {
            factories = extractorRegistry.getFileExtractorFactories(mimeType);
        }
        if (factories != null && !factories.isEmpty()) {
            Object factory = factories.iterator().next();
            if (factory instanceof ExtractorFactory) {
                Extractor extractor = ((ExtractorFactory)factory).get();
                FileInputStream stream = new FileInputStream(file);
                BufferedInputStream buffer = new BufferedInputStream(stream, 8192);
                extractor.extract((URI)uri, (InputStream)buffer, null, mimeType, container);
                try {
                    buffer.close();
                    stream.close();
                }
                catch (IOException ex) {}
            } else if (factory instanceof FileExtractorFactory) {
                FileExtractor extractor = ((FileExtractorFactory)factory).get();
                extractor.extract((URI)uri, file, null, mimeType, container);
            }
        }
        container.add(NIE.mimeType, mimeType);
    }

    public String getId() {
        return "aperture";
    }

    public String getName() {
        return "Aperture Extractor";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void shutdown() throws PluginException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigitalObject transform(DigitalObject in, String jsonConfig) throws TransformerException {
        File inFile;
        this.reset();
        String sourceId = in.getSourceId();
        try {
            inFile = new File(this.outputPath, sourceId);
            inFile.deleteOnExit();
            FileOutputStream tempFileOut = new FileOutputStream(inFile);
            Payload payload = in.getPayload(sourceId);
            IOUtils.copy((InputStream)payload.open(), (OutputStream)tempFileOut);
            payload.close();
            tempFileOut.close();
        }
        catch (IOException ex) {
            log.error("Error writing temp file : ", (Throwable)ex);
            return in;
        }
        catch (StorageException ex) {
            log.error("Error accessing storage data : ", (Throwable)ex);
            return in;
        }
        try {
            File oid = new File(in.getId());
            if (inFile.exists()) {
                RDFContainer rdf = ApertureTransformer.extractRDF(inFile, "urn:oid:" + in.getId());
                if (rdf != null) {
                    log.info("Done extraction: " + rdf.getClass());
                    Payload rdfPayload = StorageUtils.createOrUpdatePayload((DigitalObject)in, (String)"aperture.rdf", (InputStream)new ByteArrayInputStream(this.stripNonValidXMLCharacters(rdf).getBytes("UTF-8")));
                    rdfPayload.setLabel("Aperture rdf");
                    rdfPayload.setContentType("application/xml+rdf");
                    rdfPayload.setType(PayloadType.Enrichment);
                }
            } else {
                log.info("inFile '{}' does not exist!", (Object)inFile);
            }
        }
        catch (IOException e) {
            log.error("Error accessing metadata stream : ", (Throwable)e);
        }
        catch (ExtractorException e) {
            log.error("Error extracting metadata : ", (Throwable)e);
        }
        catch (StorageException e) {
            log.error("Error storing payload : ", (Throwable)e);
        }
        finally {
            if (inFile.exists()) {
                inFile.delete();
            }
        }
        return in;
    }

    public String stripNonValidXMLCharacters(RDFContainer rdf) {
        String rdfString = rdf.getModel().serialize(Syntax.RdfXml).toString();
        StringBuffer out = new StringBuffer();
        if (rdfString == null || "".equals(rdfString)) {
            return "";
        }
        for (int i = 0; i < rdfString.length(); ++i) {
            char current = rdfString.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }
}

