/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.basicVersioning;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.api.transformer.Transformer;
import com.googlecode.fascinator.api.transformer.TransformerException;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.storage.filesystem.FileSystemDigitalObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicVersioningTransformer
implements Transformer {
    private static String DEFAULT_PAYLOAD = "object.tfpackage";
    private String systemPayload;
    private static Logger log = LoggerFactory.getLogger(BasicVersioningTransformer.class);
    private JsonSimpleConfig systemConfig;
    private JsonSimple itemConfig;

    public DigitalObject transform(DigitalObject in, String config) throws TransformerException {
        try {
            this.itemConfig = new JsonSimple(config);
        }
        catch (IOException ex) {
            throw new TransformerException("Invalid configuration! '{}'", (Throwable)ex);
        }
        this.systemPayload = this.systemConfig.getString(DEFAULT_PAYLOAD, new Object[]{"transformerDefaults", "jsonVelocity", "sourcePayload"});
        String source = this.itemConfig.getString(this.systemPayload, new Object[]{"sourcePayload"});
        Payload sourcePayload = null;
        try {
            for (String payloadId : in.getPayloadIdList()) {
                if (!payloadId.endsWith(source)) continue;
                source = payloadId;
            }
            log.info("Versioning - Transforming PID '{}' from OID '{}'", (Object)source, (Object)in.getId());
            log.info(((FileSystemDigitalObject)in).getPath());
            sourcePayload = in.getPayload(source);
        }
        catch (StorageException ex) {
            log.error("Error accessing payload in storage: '{}'", (Throwable)ex);
        }
        try {
            String payloadName = this.payloadName();
            try {
                in.createStoredPayload(payloadName, sourcePayload.open());
                sourcePayload.close();
                this.createVersionIndex(((FileSystemDigitalObject)in).getPath());
                return in;
            }
            catch (StorageException ex) {
                in.updatePayload(payloadName, sourcePayload.open());
                sourcePayload.close();
                this.createVersionIndex(((FileSystemDigitalObject)in).getPath());
                return in;
            }
        }
        catch (StorageException ex) {
            throw new TransformerException("Error storing payload: ", (Throwable)ex);
        }
    }

    private String payloadName() {
        return "version_" + this.getTimestamp();
    }

    public String getId() {
        return "basicVersioning";
    }

    public String getName() {
        return "Basic versioning transformer";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(File jsonFile) throws PluginException {
        try {
            this.systemConfig = new JsonSimpleConfig(jsonFile);
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void init(String jsonString) throws PluginException {
        try {
            this.systemConfig = new JsonSimpleConfig(jsonString);
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void shutdown() throws PluginException {
    }

    private String getTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(new Date());
    }

    private void createVersionIndex(String rootPath) {
        String jsonPath = rootPath + "/" + "Version_Index.json";
        log.debug("Indexing a version into: " + jsonPath);
        JSONArray jArr = null;
        try {
            File oldf = new File(jsonPath);
            if (oldf.exists()) {
                log.debug("Need to update a version index file: " + jsonPath);
                JsonSimple js = new JsonSimple(oldf);
                jArr = js.getJsonArray();
            } else {
                log.debug("Need to create a new version index file: " + jsonPath);
                jArr = new JSONArray();
            }
            JsonObject newVer = new JsonObject();
            newVer.put((Object)"timestamp", (Object)this.getTimestamp());
            newVer.put((Object)"file_name", (Object)this.payloadName());
            try {
                jArr.add((Object)newVer);
                try {
                    FileWriter fw = new FileWriter(jsonPath);
                    fw.write(jArr.toJSONString());
                    fw.flush();
                    fw.close();
                }
                catch (IOException e) {
                    log.error("Failed to save versioning property file.", (Throwable)e);
                }
            }
            catch (Exception eStrange) {
                log.error("Failed to add a new version.", (Throwable)eStrange);
            }
        }
        catch (Exception eOther) {
            log.error("Failed to create/edit versioning property file.", (Throwable)eOther);
        }
    }
}

