/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.basicVersioning;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.api.transformer.TransformerException;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.storage.StorageUtils;
import com.googlecode.fascinator.transformer.basicVersioning.BasicVersioningTransformer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="extensionBasicVersioningTransformer")
public class ExtensionBasicVersioningTransformer
extends BasicVersioningTransformer {
    private static String DEFAULT_PAYLOAD = "object.tfpackage";
    private String systemPayload;
    private static Logger log = LoggerFactory.getLogger(BasicVersioningTransformer.class);
    private JsonSimpleConfig systemConfig;
    private JsonSimple itemConfig;

    public DigitalObject transform(DigitalObject in) throws TransformerException {
        try {
            this.systemConfig = new JsonSimpleConfig();
            return this.transform(in, new JsonSimple(JsonSimpleConfig.getSystemFile()).getObject(new Object[]{"transformerDefaults", this.getId()}).toString());
        }
        catch (IOException e) {
            throw new TransformerException((Throwable)e);
        }
    }

    @Override
    public DigitalObject transform(DigitalObject in, String config) throws TransformerException {
        try {
            this.itemConfig = new JsonSimple(config);
        }
        catch (IOException ex) {
            throw new TransformerException("Invalid configuration! '{}'", (Throwable)ex);
        }
        this.systemPayload = this.systemConfig.getString(DEFAULT_PAYLOAD, new Object[]{"transformerDefaults", "jsonVelocity", "sourcePayload"});
        String source = this.itemConfig.getString(this.systemPayload, new Object[]{"sourcePayload"});
        Payload sourcePayload = null;
        try {
            for (String payloadId : in.getPayloadIdList()) {
                log.debug("Looking for " + source + " in " + payloadId);
                if (!payloadId.endsWith(source)) continue;
                source = payloadId;
            }
            if (source.startsWith(".")) {
                log.info("Versioning - Source not found at this time:'{}' from OID '{}'", (Object)source, (Object)in.getId());
                return in;
            }
            log.info("Versioning - Transforming PID '{}' from OID '{}'", (Object)source, (Object)in.getId());
            sourcePayload = in.getPayload(source);
        }
        catch (StorageException ex) {
            log.error("Error accessing payload in storage: '{}'", (Throwable)ex);
        }
        try {
            String payloadName = this.payloadName(source);
            try {
                in.createStoredPayload(payloadName, sourcePayload.open());
                sourcePayload.close();
                this.createVersionIndex(in, payloadName, source);
                return in;
            }
            catch (StorageException ex) {
                in.updatePayload(payloadName, sourcePayload.open());
                sourcePayload.close();
                this.createVersionIndex(in, payloadName, source);
                return in;
            }
        }
        catch (StorageException ex) {
            throw new TransformerException("Error storing payload: ", (Throwable)ex);
        }
    }

    private String payloadName(String source) {
        String ext = FilenameUtils.getExtension((String)source);
        return "version_" + ext + "_" + this.getTimestamp();
    }

    @Override
    public String getId() {
        return "extensionBasicVersioning";
    }

    @Override
    public String getName() {
        return "Basic versioning transformer with Extensions support";
    }

    @Override
    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    @Override
    public void init(File jsonFile) throws PluginException {
        try {
            this.systemConfig = new JsonSimpleConfig(jsonFile);
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    @Override
    public void init(String jsonString) throws PluginException {
        try {
            this.systemConfig = new JsonSimpleConfig(jsonString);
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    @Override
    public void shutdown() throws PluginException {
    }

    private String getTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(new Date());
    }

    private void createVersionIndex(DigitalObject in, String payloadName, String source) {
        String versionIndexPayloadId = FilenameUtils.getExtension((String)source) + "_Version_Index.json";
        JSONArray jArr = null;
        try {
            log.debug("Need to update a version index file: " + in.getId());
            Payload payload = in.getPayload(versionIndexPayloadId);
            JsonSimple js = new JsonSimple(payload.open());
            jArr = js.getJsonArray();
        }
        catch (Exception e) {
            log.debug("Need to create a new version index file: " + in.getId());
            jArr = new JSONArray();
        }
        String timestamp = this.getTimestamp();
        for (Object curEntryObj : jArr) {
            JsonObject curEntry = (JsonObject)curEntryObj;
            String curTs = (String)curEntry.get((Object)"timestamp");
            if (!timestamp.equalsIgnoreCase(curTs)) continue;
            log.debug("A duplicate of the timestamp " + timestamp + " is already found in the version index, ignoring.");
            return;
        }
        JsonObject newVer = new JsonObject();
        newVer.put((Object)"timestamp", (Object)timestamp);
        newVer.put((Object)"file_name", (Object)payloadName);
        try {
            jArr.add((Object)newVer);
            StorageUtils.createOrUpdatePayload((DigitalObject)in, (String)versionIndexPayloadId, (InputStream)new ByteArrayInputStream(jArr.toJSONString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception eStrange) {
            log.error("Failed to add a new version.", (Throwable)eStrange);
        }
    }
}

