/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.ffmpeg;

import com.googlecode.fascinator.common.JsonSimple;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FfmpegDatabase {
    private final Logger log = LoggerFactory.getLogger(FfmpegDatabase.class);
    private static String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static String DERBY_PROTOCOL = "jdbc:derby:";
    private static String FFMPEG_DATABASE = "ffmpegTranscodings";
    private static String STATS_TABLE = "transcodings";
    private static String HASH_TABLE = "hashes";
    private String derbyHome;
    private Connection connection;

    public FfmpegDatabase(JsonSimple config) throws Exception {
        this.derbyHome = config.getString(null, new Object[]{"database-service", "derbyHome"});
        String oldHome = System.getProperty("derby.system.home");
        if (oldHome != null) {
            if (this.derbyHome != null) {
                this.log.warn("Using previously specified data directory: '{}', provided value has been ignored: '{}'", (Object)oldHome, (Object)this.derbyHome);
            } else {
                this.log.info("Using existing data directory: '{}'", (Object)oldHome);
            }
        } else {
            if (this.derbyHome == null) {
                this.log.error("No database home directory configured!");
                return;
            }
            File file = new File(this.derbyHome);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new Exception("Database home '" + this.derbyHome + "' is not a directory!");
                }
            } else {
                file.mkdirs();
                if (!file.exists()) {
                    throw new Exception("Database home '" + this.derbyHome + "' does not exist and could not be created!");
                }
            }
            System.setProperty("derby.system.home", this.derbyHome);
        }
        try {
            this.checkTable(STATS_TABLE);
            this.checkTable(HASH_TABLE);
        }
        catch (SQLException ex) {
            this.log.error("Error during database preparation:", (Throwable)ex);
            throw new Exception("Error during database preparation:", ex);
        }
        this.log.debug("Derby security database online!");
    }

    private Connection connection() throws SQLException {
        if (this.connection == null || !this.connection.isValid(1)) {
            if (this.connection != null) {
                this.log.error("!!! Database connection has failed, recreating.");
                try {
                    this.connection.close();
                }
                catch (SQLException ex) {
                    this.log.error("Error closing invalid connection, ignoring: {}", (Object)ex.getMessage());
                }
            }
            Properties props = new Properties();
            try {
                Class.forName(DERBY_DRIVER).newInstance();
            }
            catch (Exception ex) {
                this.log.error("Driver load failed: ", (Throwable)ex);
                throw new SQLException("Driver load failed: ", ex);
            }
            this.connection = DriverManager.getConnection(DERBY_PROTOCOL + FFMPEG_DATABASE + ";create=true", props);
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        String threadedShutdownMessage = DERBY_DRIVER + " is not registered with the JDBC driver manager";
        try {
            DriverManager.getConnection(DERBY_PROTOCOL + ";shutdown=true");
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 50000 && ex.getSQLState().equals("XJ015")) {
            } else if (!ex.getMessage().equals(threadedShutdownMessage)) {
                throw new Exception("Error during database shutdown:", ex);
            }
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (SQLException ex) {
                throw new Exception("Error closing connection:", ex);
            }
        }
    }

    public long getLastTranscoded(String oid, String render, String source, String output, String resolution) {
        String hash = DigestUtils.md5Hex((String)render);
        try {
            PreparedStatement sql = this.connection().prepareStatement("SELECT MAX(datetime)as time FROM " + STATS_TABLE + " WHERE oid = ? AND renderhash = ?" + " AND infile = ? AND outfile = ? AND resolution = ?");
            sql.setString(1, oid);
            sql.setString(2, hash);
            sql.setString(3, source);
            sql.setString(4, output);
            sql.setString(5, resolution);
            ResultSet result = sql.executeQuery();
            Timestamp ts = null;
            if (result.next()) {
                ts = result.getTimestamp("time");
            }
            this.close(result);
            this.close(sql);
            if (ts == null) {
                return -1L;
            }
            return ts.getTime();
        }
        catch (SQLException ex) {
            this.log.error("Error querying transcoding information: ", (Throwable)ex);
            return -1L;
        }
    }

    public void storeTranscoding(Map<String, String> data) throws Exception {
        String oid = data.get("oid");
        long datetime = Long.parseLong(data.get("datetime"));
        Timestamp timestamp = new Timestamp(datetime);
        int timespent = Integer.valueOf(data.get("timespent"));
        int mediaduration = Integer.valueOf(data.get("mediaduration"));
        String renderhash = this.getHash(data.get("renderString"));
        String inresolution = data.get("inresolution");
        String outresolution = data.get("outresolution");
        String insize = data.get("insize");
        String outsize = data.get("outsize");
        String infile = data.get("infile");
        String outfile = data.get("outfile");
        PreparedStatement sql = this.connection().prepareStatement("INSERT INTO " + STATS_TABLE + " (oid, datetime, timespent, mediaduration, renderhash, " + "inresolution, outresolution, insize, outsize, infile, " + "outfile) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        sql.setString(1, oid);
        sql.setTimestamp(2, timestamp);
        sql.setInt(3, timespent);
        sql.setInt(4, mediaduration);
        sql.setString(5, renderhash);
        sql.setString(6, inresolution);
        sql.setString(7, outresolution);
        sql.setString(8, insize);
        sql.setString(9, outsize);
        sql.setString(10, infile);
        sql.setString(11, outfile);
        sql.executeUpdate();
        this.close(sql);
    }

    private String getHash(String renderString) {
        String hash = DigestUtils.md5Hex((String)renderString);
        try {
            PreparedStatement sql = this.connection().prepareStatement("SELECT count(*) as total FROM " + HASH_TABLE + " WHERE hash = ?");
            sql.setString(1, hash);
            ResultSet result = sql.executeQuery();
            boolean stored = false;
            if (result.next() && result.getInt("total") == 1) {
                stored = true;
            }
            this.close(result);
            this.close(sql);
            if (stored) {
                return hash;
            }
            this.storeHash(hash, renderString);
        }
        catch (SQLException ex) {
            this.log.error("Error storing MD5 hash: ", (Throwable)ex);
        }
        return hash;
    }

    private void storeHash(String hash, String string) throws SQLException {
        PreparedStatement sql = this.connection().prepareStatement("INSERT INTO " + HASH_TABLE + " (hash, renderstring) VALUES (?, ?)");
        sql.setString(1, hash);
        sql.setString(2, string);
        sql.executeUpdate();
        this.close(sql);
    }

    private void checkTable(String table) throws SQLException {
        boolean tableFound = this.findTable(table);
        if (!tableFound) {
            this.log.debug("Table '{}' not found, creating now!", (Object)table);
            this.createTable(table);
            if (!this.findTable(table)) {
                this.log.error("Unknown error creating table '{}'", (Object)table);
                throw new SQLException("Could not find or create table '" + table + "'");
            }
        }
    }

    private boolean findTable(String table) throws SQLException {
        boolean tableFound = false;
        DatabaseMetaData meta = this.connection().getMetaData();
        ResultSet result = meta.getTables(null, null, null, null);
        while (result.next() && !tableFound) {
            if (!result.getString("TABLE_NAME").equalsIgnoreCase(table)) continue;
            tableFound = true;
        }
        this.close(result);
        return tableFound;
    }

    private void createTable(String table) throws SQLException {
        if (table.equals(STATS_TABLE)) {
            Statement sql = this.connection().createStatement();
            sql.execute("CREATE TABLE " + STATS_TABLE + "(id INT NOT NULL GENERATED ALWAYS AS IDENTITY, " + "oid VARCHAR(255) NOT NULL, " + "datetime TIMESTAMP NOT NULL, " + "timespent INT NOT NULL, " + "mediaduration INT NOT NULL, " + "renderhash VARCHAR(255) NOT NULL, " + "inresolution VARCHAR(30) NOT NULL, " + "outresolution VARCHAR(30) NOT NULL, " + "insize INT NOT NULL, " + "outsize INT NOT NULL, " + "infile VARCHAR(255) NOT NULL, " + "outfile VARCHAR(255) NOT NULL, " + "PRIMARY KEY (id))");
            sql.execute("CREATE INDEX a ON " + STATS_TABLE + "(datetime DESC, " + "oid, renderhash, inFile, outFile, outResolution)");
            sql.execute("CREATE INDEX b ON " + STATS_TABLE + "(oid, outFile)");
            sql.execute("CREATE INDEX c ON " + STATS_TABLE + "(oid)");
            this.close(sql);
            return;
        }
        if (table.equals(HASH_TABLE)) {
            Statement sql = this.connection().createStatement();
            sql.execute("CREATE TABLE " + HASH_TABLE + "(hash VARCHAR(255) NOT NULL, " + "renderstring VARCHAR(255) NOT NULL, " + "PRIMARY KEY (hash))");
            this.close(sql);
            return;
        }
        throw new SQLException("Unknown table '" + table + "' requested!");
    }

    private void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                this.log.error("Error closing result set: ", (Throwable)ex);
            }
        }
        resultSet = null;
    }

    private void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                this.log.error("Error closing statement: ", (Throwable)ex);
            }
        }
        statement = null;
    }
}

