/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.ffmpeg;

import com.googlecode.fascinator.transformer.ffmpeg.Ffmpeg;
import com.googlecode.fascinator.transformer.ffmpeg.FfmpegInfo;
import com.googlecode.fascinator.transformer.ffmpeg.InputGobbler;
import com.googlecode.fascinator.transformer.ffmpeg.InputHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FfmpegImpl
implements Ffmpeg {
    private Logger log = LoggerFactory.getLogger(FfmpegImpl.class);
    private boolean extraction = false;
    private String executable;
    private String metadata;
    private String availability = "Unknown";
    private Map<String, String> env;

    public FfmpegImpl() {
        this("ffmpeg", "ffprobe");
    }

    public FfmpegImpl(String executable, String metadata) {
        this.executable = executable == null ? "ffmpeg" : executable;
        this.metadata = metadata == null ? "ffprobe" : metadata;
        this.env = new HashMap<String, String>();
    }

    @Override
    public String testAvailability() {
        if (this.availability != null && this.availability.equals("Unknown")) {
            boolean ffprobe = this.testExtractor();
            boolean ffmpeg = this.testConverter();
            if (ffprobe && ffmpeg) {
                this.availability = "ffprobe";
            } else if (ffmpeg) {
                this.availability = "ffmpeg";
                this.metadata = this.executable;
            } else {
                this.availability = null;
            }
        }
        return this.availability;
    }

    private boolean testExtractor() {
        block5: {
            if (this.metadata.contains("ffprobe")) {
                this.extraction = true;
                try {
                    this.execute();
                    this.extraction = false;
                    return true;
                }
                catch (IOException ioe) {
                    File found = this.searchPathForExecutable("ffprobe");
                    if (found == null) break block5;
                    this.metadata = found.getAbsolutePath();
                    this.log.info("FFprobe found at {}", (Object)this.metadata);
                    try {
                        this.execute();
                        this.extraction = false;
                        return true;
                    }
                    catch (IOException ioe2) {
                        this.log.error("FFprobe not functioning correctly!");
                    }
                }
            }
        }
        this.extraction = false;
        return false;
    }

    private boolean testConverter() {
        block5: {
            if (this.executable.contains("ffmpeg")) {
                try {
                    this.execute();
                    return true;
                }
                catch (IOException ioe) {
                    File found = this.searchPathForExecutable("ffmpeg");
                    if (found == null) break block5;
                    this.executable = found.getAbsolutePath();
                    this.log.info("FFmpeg found at {}", (Object)this.executable);
                    try {
                        this.execute();
                        return true;
                    }
                    catch (IOException ioe2) {
                        this.log.error("FFmpeg not functioning correctly!");
                    }
                }
            }
        }
        return false;
    }

    private Process execute() throws IOException {
        List<String> noParams = Collections.emptyList();
        return this.execute(noParams, null);
    }

    private Process execute(List<String> params, File location) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.extraction) {
            cmd.add(this.metadata);
        } else {
            cmd.add(this.executable);
        }
        cmd.addAll(params);
        this.log.debug("Executing: {}", cmd);
        return this.createProcess(cmd, location).start();
    }

    private ProcessBuilder createProcess(List<String> commands, File location) {
        if (this.env.isEmpty()) {
            return new ProcessBuilder(commands);
        }
        ProcessBuilder process = new ProcessBuilder(commands);
        if (location != null) {
            process.directory(location);
        }
        Map<String, String> currentEnv = process.environment();
        for (String key : this.env.keySet()) {
            currentEnv.put(key, this.env.get(key));
        }
        return process;
    }

    private Process waitFor(Process proc, OutputStream out) {
        if (this.extraction && this.metadata.equals("ffprobe")) {
            new InputHandler("stdout", proc.getInputStream(), out).start();
            new InputGobbler("stderr", proc.getErrorStream()).start();
        } else {
            new InputHandler("stderr", proc.getErrorStream(), out).start();
            new InputGobbler("stdout", proc.getInputStream()).start();
        }
        try {
            proc.waitFor();
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            this.log.error("ffmpeg was interrupted!", (Throwable)ie);
            proc.destroy();
        }
        return proc;
    }

    private Process executeAndWait(List<String> params, OutputStream out, File location) throws IOException {
        return this.waitFor(this.execute(params, location), out);
    }

    @Override
    public String extract(File inputFile) throws IOException {
        if (this.testAvailability() == null) {
            return null;
        }
        this.extraction = true;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArrayList<String> params = new ArrayList<String>();
        if (this.testAvailability().equals("ffprobe")) {
            params.add("-show_format");
            params.add("-show_streams");
        } else {
            params.add("-i");
        }
        params.add(inputFile.getAbsolutePath());
        this.executeAndWait(params, out, null);
        this.extraction = false;
        return out.toString("UTF-8");
    }

    @Override
    public String transform(List<String> params, File location) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.executeAndWait(params, out, location);
        String response = out.toString("UTF-8");
        if (response.contains("Compile-time maximum width")) {
            throw new IOException("Maximum resolution exceeded!\n=====\n" + response);
        }
        return response;
    }

    @Override
    public FfmpegInfo getInfo(File inputFile) throws IOException {
        return new FfmpegInfo(this, inputFile);
    }

    private File searchPathForExecutable(String name) {
        String[] dirs;
        if (System.getProperty("os.name").startsWith("Windows") && !name.endsWith(".exe")) {
            name = name + ".exe";
        }
        for (String dir : dirs = System.getenv("PATH").split(File.pathSeparator)) {
            File file = new File(dir, name);
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }

    @Override
    public void setEnvironmentVariable(String key, String value) {
        this.env.put(key, value);
    }
}

