/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.ffmpeg;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.transformer.ffmpeg.Ffmpeg;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FfmpegInfo {
    private Logger log = LoggerFactory.getLogger(FfmpegInfo.class);
    private boolean supported = true;
    private boolean audio = false;
    private boolean video = false;
    private String rawMediaData;
    private String metadata;
    private int duration;
    private int width;
    private int height;
    private JsonObject format = new JsonObject();
    private List<JsonObject> streams = new ArrayList<JsonObject>();
    private JsonObject videoStream = new JsonObject();
    private JsonObject audioStream = new JsonObject();

    public FfmpegInfo(Ffmpeg ffmpeg, File inputFile) throws IOException {
        this.rawMediaData = ffmpeg.extract(inputFile);
        if (this.rawMediaData == null || this.rawMediaData.length() == 0) {
            this.supported = false;
            return;
        }
        if (ffmpeg.testAvailability().equals("ffprobe")) {
            this.parseFFprobeMetadata(this.rawMediaData);
            this.processFFprobeMetadata();
        } else {
            this.parseFFmpegMetadata(this.rawMediaData);
            JsonObject mData = new JsonObject();
            mData.put((Object)"duration", (Object)("" + this.duration));
            this.metadata = mData.toString();
        }
    }

    private String getCleanValue(JsonObject json, String path) {
        String result = new JsonSimple(json).getString(null, new Object[]{path});
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    private void parseFFprobeMetadata(String rawMetaData) {
        JsonObject stream = null;
        for (String line : rawMetaData.split("\r\n|\r|\n")) {
            int eq;
            if (line.equals("[STREAM]")) {
                stream = new JsonObject();
                continue;
            }
            if (line.equals("[/STREAM]")) {
                this.streams.add(stream);
                stream = null;
                continue;
            }
            if (line.equals("[FORMAT]") || line.equals("[/FORMAT]")) continue;
            if (line.startsWith("TAG:")) {
                line = "tags/" + line.substring(4);
            }
            if ((eq = line.indexOf("=")) == -1) continue;
            String key = line.substring(0, eq).replace(" ", "_");
            String value = line.substring(eq + 1);
            if (stream == null) {
                this.format.put((Object)key, (Object)value);
                continue;
            }
            stream.put((Object)key, (Object)value);
        }
    }

    private void parseFFmpegMetadata(String rawMetaData) {
        this.supported = rawMetaData.indexOf(": Unknown format") == -1;
        if (this.supported) {
            this.width = 0;
            this.height = 0;
            Pattern p = Pattern.compile(", ((\\d+)x(\\d+))(,)* ");
            Matcher m = p.matcher(rawMetaData);
            if (m.find()) {
                this.width = Integer.valueOf(m.group(2));
                this.height = Integer.valueOf(m.group(3));
            }
            if ((m = (p = Pattern.compile("Duration: ((\\d+):(\\d+):(\\d+))")).matcher(rawMetaData)).find()) {
                long hrs = Long.parseLong(m.group(2)) * 3600L;
                long min = Long.parseLong(m.group(3)) * 60L;
                long sec = Long.parseLong(m.group(4));
                this.duration = Long.valueOf(hrs + min + sec).intValue();
            }
            this.video = Pattern.compile("Stream #.*Video:.*").matcher(rawMetaData).find();
            this.audio = Pattern.compile("Stream #.*Audio:.*").matcher(rawMetaData).find();
        }
    }

    private void processFFprobeMetadata() {
        String lang;
        String codec;
        this.getPrimaryStreams();
        JsonObject mData = new JsonObject();
        String dString = this.getCleanValue(this.format, "duration");
        mData.put((Object)"duration_float", (Object)dString);
        this.duration = Float.valueOf(dString).intValue();
        mData.put((Object)"duration", (Object)this.duration);
        JsonObject formatData = new JsonObject();
        formatData.put((Object)"simple", (Object)this.getCleanValue(this.format, "format_name"));
        formatData.put((Object)"label", (Object)this.getCleanValue(this.format, "format_long_name"));
        mData.put((Object)"format", (Object)formatData);
        this.width = 0;
        this.height = 0;
        if (this.videoStream != null) {
            String heightStr;
            JsonObject videoData = new JsonObject();
            codec = this.getCleanValue(this.videoStream, "codec_name");
            if (codec != null) {
                this.video = true;
            }
            if ((lang = this.getCleanValue(this.videoStream, "language")) == null) {
                lang = this.getCleanValue(this.videoStream, "tags/language");
            }
            videoData.put((Object)"language", (Object)lang);
            String widthStr = this.getCleanValue(this.videoStream, "width");
            if (widthStr != null) {
                this.width = Integer.valueOf(widthStr);
                videoData.put((Object)"width", (Object)widthStr);
            }
            if ((heightStr = this.getCleanValue(this.videoStream, "height")) != null) {
                this.height = Integer.valueOf(heightStr);
                videoData.put((Object)"height", (Object)heightStr);
            }
            JsonObject videoCodec = new JsonObject();
            videoCodec.put((Object)"tag", (Object)this.getCleanValue(this.videoStream, "codec_tag"));
            videoCodec.put((Object)"tag_string", (Object)this.getCleanValue(this.videoStream, "codec_tag_string"));
            videoCodec.put((Object)"simple", (Object)this.getCleanValue(this.videoStream, "codec_name"));
            videoCodec.put((Object)"label", (Object)this.getCleanValue(this.videoStream, "codec_long_name"));
            videoData.put((Object)"codec", (Object)videoCodec);
            videoData.put((Object)"pixel_format", (Object)this.getCleanValue(this.videoStream, "pix_fmt"));
            mData.put((Object)"video", (Object)videoData);
        }
        if (this.audioStream != null) {
            JsonObject audioData = new JsonObject();
            codec = this.getCleanValue(this.audioStream, "codec_name");
            if (codec != null) {
                this.audio = true;
            }
            if ((lang = this.getCleanValue(this.audioStream, "language")) == null) {
                lang = this.getCleanValue(this.audioStream, "tags/language");
            }
            audioData.put((Object)"language", (Object)lang);
            JsonObject audioCodec = new JsonObject();
            audioCodec.put((Object)"tag", (Object)this.getCleanValue(this.audioStream, "codec_tag"));
            audioCodec.put((Object)"tag_string", (Object)this.getCleanValue(this.audioStream, "codec_tag_string"));
            audioCodec.put((Object)"simple", (Object)this.getCleanValue(this.audioStream, "codec_name"));
            audioCodec.put((Object)"label", (Object)this.getCleanValue(this.audioStream, "codec_long_name"));
            audioData.put((Object)"codec", (Object)audioCodec);
            String sample_rate = this.getCleanValue(this.audioStream, "sample_rate");
            if (sample_rate != null) {
                audioData.put((Object)"sample_rate", (Object)Float.valueOf(sample_rate).intValue());
            }
            audioData.put((Object)"channels", (Object)this.getCleanValue(this.audioStream, "channels"));
            mData.put((Object)"audio", (Object)audioData);
        }
        this.metadata = mData.toString();
    }

    private void getPrimaryStreams() {
        for (JsonObject stream : this.streams) {
            String type = (String)stream.get((Object)"codec_type");
            if (type == null) continue;
            if (type.equals("video") && this.videoStream != null) {
                this.videoStream = stream;
            }
            if (!type.equals("audio") || this.audioStream == null) continue;
            this.audioStream = stream;
        }
    }

    public String getRaw() {
        return this.rawMediaData;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isSupported() {
        return this.supported;
    }

    public boolean hasAudio() {
        return this.audio;
    }

    public boolean hasVideo() {
        return this.video;
    }

    public String toString() {
        return this.metadata;
    }
}

