/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.ffmpeg;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.api.transformer.Transformer;
import com.googlecode.fascinator.api.transformer.TransformerException;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.MimeTypeUtil;
import com.googlecode.fascinator.common.storage.StorageUtils;
import com.googlecode.fascinator.transformer.ffmpeg.Ffmpeg;
import com.googlecode.fascinator.transformer.ffmpeg.FfmpegDatabase;
import com.googlecode.fascinator.transformer.ffmpeg.FfmpegImpl;
import com.googlecode.fascinator.transformer.ffmpeg.FfmpegInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FfmpegTransformer
implements Transformer {
    private static String ERROR_PAYLOAD = "ffmpegErrors.json";
    private static String MERGED_PAYLOAD = "ffmpegMerged.";
    private static String METADATA_PAYLOAD = "ffmpeg.info";
    private Logger log = LoggerFactory.getLogger(FfmpegTransformer.class);
    private FfmpegDatabase stats;
    private JsonSimpleConfig config;
    private JsonSimple itemConfig;
    private File outputDir;
    private File outputRoot;
    private Ffmpeg ffmpeg;
    private boolean firstRun = true;
    private String format;
    private FfmpegInfo info;
    private Map<String, JsonObject> metadata;
    private Map<String, JsonSimple> oldMetadata;
    private Map<String, JsonObject> errors;
    private String oid;
    private String mergeRate;
    private String finalRate;
    private String finalFormat;

    public FfmpegTransformer() {
    }

    public FfmpegTransformer(Ffmpeg ffmpeg) {
        this.ffmpeg = ffmpeg;
    }

    public void init(File jsonFile) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonFile);
            this.reset();
        }
        catch (IOException ioe) {
            throw new PluginException((Throwable)ioe);
        }
    }

    public void init(String jsonString) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonString);
            this.reset();
        }
        catch (IOException ioe) {
            throw new PluginException((Throwable)ioe);
        }
    }

    private void reset() throws TransformerException {
        if (this.firstRun) {
            String presetsPath;
            this.firstRun = false;
            this.testExecLevel();
            String outputPath = this.config.getString(null, new Object[]{"outputPath"});
            if (outputPath == null) {
                this.log.error("No output path provided!");
                return;
            }
            this.outputRoot = new File(outputPath);
            this.outputRoot.mkdirs();
            boolean useDB = this.config.getBoolean(Boolean.valueOf(false), new Object[]{"database", "enabled"});
            if (useDB) {
                try {
                    this.stats = new FfmpegDatabase((JsonSimple)this.config);
                }
                catch (Exception ex) {
                    this.log.error("Statistics database failed to initialise!");
                }
            }
            if ((presetsPath = this.config.getString(null, new Object[]{"presetsPath"})) != null) {
                File presetDir = new File(presetsPath);
                if (presetDir.exists() && presetDir.isDirectory()) {
                    this.ffmpeg.setEnvironmentVariable("FFMPEG_DATADIR", presetDir.getAbsolutePath());
                } else {
                    this.log.error("Invalid FFmpeg presets path provided: '{}'", (Object)presetsPath);
                }
            }
        }
        this.itemConfig = null;
        this.info = null;
        this.format = null;
        this.errors = new LinkedHashMap<String, JsonObject>();
        this.metadata = new LinkedHashMap<String, JsonObject>();
        this.oldMetadata = new LinkedHashMap<String, JsonSimple>();
    }

    private void addError(String index, String message) {
        if (message == null || index == null) {
            return;
        }
        this.log.error(message);
        JsonObject msg = new JsonObject();
        msg.put((Object)"message", (Object)message);
        this.addError(index, msg);
    }

    private void addError(String index, String message, Exception ex) {
        if (message == null || index == null) {
            return;
        }
        this.log.error(message, (Throwable)ex);
        JsonObject msg = new JsonObject();
        msg.put((Object)"message", (Object)message);
        if (ex != null) {
            msg.put((Object)"exception", (Object)ex.getMessage());
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            msg.put((Object)"stacktrace", (Object)sw.toString());
        }
        this.addError(index, msg);
    }

    private void addError(String index, JsonObject message) {
        if (message == null || index == null) {
            return;
        }
        if (this.errors.containsKey(index)) {
            int inc = 2;
            while (this.errors.containsKey(index + "_" + inc)) {
                ++inc;
            }
            index = index + "_" + inc;
        }
        this.errors.put(index, message);
    }

    private String testExecLevel() {
        if (this.ffmpeg == null) {
            this.ffmpeg = new FfmpegImpl(this.get(null, null, "binaries", "transcoding"), this.get(null, null, "binaries", "metadata"));
        }
        return this.ffmpeg.testAvailability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigitalObject transform(DigitalObject object, String jsonConfig) throws TransformerException {
        File file;
        if (this.testExecLevel() == null) {
            this.log.error("FFmpeg is either not installed, or not executing!");
            return object;
        }
        this.reset();
        this.oid = object.getId();
        this.outputDir = new File(this.outputRoot, this.oid);
        this.outputDir.mkdirs();
        try {
            this.itemConfig = new JsonSimple(jsonConfig);
        }
        catch (IOException ex) {
            throw new TransformerException("Invalid configuration! '{}'", (Throwable)ex);
        }
        this.mergeRate = this.get(this.itemConfig, "25", "merging", "mpegFrameRate");
        this.finalRate = this.get(this.itemConfig, "10", "merging", "finalFrameRate");
        this.finalFormat = this.get(this.itemConfig, "avi", "merging", "finalFormat");
        this.mergeSegments(object);
        String sourceId = object.getSourceId();
        String ext = FilenameUtils.getExtension((String)sourceId);
        this.format = this.getFormat(ext);
        if (this.format == null) {
            return object;
        }
        try {
            file = this.cacheFile(object, sourceId);
        }
        catch (IOException ex) {
            this.addError(sourceId, "Error writing temp file", ex);
            this.errorAndClose(object);
            return object;
        }
        catch (StorageException ex) {
            this.addError(sourceId, "Error accessing storage data", (Exception)((Object)ex));
            this.errorAndClose(object);
            return object;
        }
        if (!file.exists()) {
            this.addError(sourceId, "Unknown error writing cache: does not exist");
            this.errorAndClose(object);
            return object;
        }
        String display = this.get(this.itemConfig, null, "displayTypes", this.format);
        if (display != null) {
            try {
                Properties prop = object.getMetadata();
                prop.setProperty("displayType", display);
                prop.setProperty("previewType", display);
            }
            catch (StorageException ex) {
                this.addError("display", "Could not access object metadata", (Exception)((Object)ex));
            }
        }
        try {
            this.info = this.ffmpeg.getInfo(file);
        }
        catch (IOException ex) {
            this.addError("metadata", "Error accessing metadata", ex);
            this.errorAndClose(object);
            return object;
        }
        if (!this.info.isSupported()) {
            this.closeObject(object);
            return object;
        }
        List<JsonSimple> conversions = this.getJsonList(this.itemConfig, "transcodings", this.format);
        for (JsonSimple conversion : conversions) {
            String name = conversion.getString(null, new Object[]{"alias"});
            List<JsonSimple> renditions = this.getJsonList(conversion, "renditions");
            if (renditions == null || renditions.isEmpty()) {
                this.addError("transcodings", "Invalid or missing transcoding data: '/transcodings/" + this.format + "'");
                continue;
            }
            for (JsonSimple render : renditions) {
                File converted = null;
                try {
                    converted = this.convert(file, render, this.info);
                }
                catch (Exception ex) {
                    String outputFile = render.getString(null, new Object[]{"name"});
                    if (outputFile != null) {
                        this.addError(this.jsonKey(outputFile), "Error converting file", ex);
                    }
                    this.addError("unknown", "Error converting file", ex);
                }
                if (converted == null) continue;
                try {
                    Payload payload = this.createFfmpegPayload(object, converted);
                    payload.setType(this.resolveType(render.getString(null, new Object[]{"type"})));
                    payload.close();
                }
                catch (Exception ex) {
                    this.addError(this.jsonKey(converted.getName()), "Error storing output", ex);
                }
                finally {
                    converted.delete();
                }
            }
        }
        if (this.compileMetadata(object)) {
            this.closeObject(object);
        } else {
            this.errorAndClose(object);
        }
        if (file.exists()) {
            file.delete();
        }
        return object;
    }

    private File cacheFile(DigitalObject object, String pid) throws FileNotFoundException, StorageException, IOException {
        File file = new File(this.outputDir, pid);
        FileOutputStream tempFileOut = new FileOutputStream(file);
        Payload payload = object.getPayload(pid);
        try {
            IOUtils.copy((InputStream)payload.open(), (OutputStream)tempFileOut);
        }
        catch (IOException ex) {
            payload.close();
            throw ex;
        }
        payload.close();
        tempFileOut.close();
        return file;
    }

    private void mergeSegments(DigitalObject object) {
        try {
            Properties props = object.getMetadata();
            String segs = props.getProperty("mediaSegments");
            if (segs == null) {
                return;
            }
            int segments = Integer.parseInt(segs);
            if (segments <= 1) {
                return;
            }
            this.log.info("Found {} source segments! Merging...", (Object)segments);
            ArrayList<String> segmentIds = new ArrayList<String>();
            Set payloadIds = object.getPayloadIdList();
            String sourceId = object.getSourceId();
            if (sourceId == null || !payloadIds.contains(sourceId)) {
                this.log.error("Cannot find source payload.");
                return;
            }
            segmentIds.add(sourceId);
            for (int i = 1; i < segments; ++i) {
                String segmentId = "segment" + i + ".";
                for (String pid : payloadIds) {
                    if (!pid.startsWith(segmentId)) continue;
                    segmentIds.add(pid);
                }
            }
            if (segmentIds.size() != segments) {
                this.log.error("Unable to find all segments in payload list.");
                return;
            }
            HashMap<String, File> files = new HashMap<String, File>();
            for (String segment : segmentIds) {
                try {
                    File file = this.basicMpeg(object, segment);
                    if (file == null) continue;
                    files.put(segment, file);
                }
                catch (Exception ex) {
                    this.log.error("Error transcoding segment to MPEG: ", (Throwable)ex);
                    for (File f : files.values()) {
                        if (!f.exists()) continue;
                        f.delete();
                    }
                    return;
                }
            }
            if (files.size() != segments) {
                this.log.error("At least one segment transcoding failed.");
                for (File f : files.values()) {
                    if (!f.exists()) continue;
                    f.delete();
                }
                return;
            }
            try {
                String filename = "temp_" + MERGED_PAYLOAD + "mpg";
                File merged = new File(this.outputDir, filename);
                if (merged.exists()) {
                    merged.delete();
                }
                FileOutputStream out = new FileOutputStream(merged);
                for (String sId : segmentIds) {
                    try {
                        this.mergeSegment(out, (File)files.get(sId));
                    }
                    catch (IOException ex) {
                        this.log.error("Failed to stream to merged file: ", (Throwable)ex);
                        out.close();
                        for (File f : files.values()) {
                            if (!f.exists()) continue;
                            f.delete();
                        }
                        merged.delete();
                        return;
                    }
                }
                out.close();
                filename = MERGED_PAYLOAD + this.finalFormat;
                File transcoded = new File(this.outputDir, filename);
                if (transcoded.exists()) {
                    transcoded.delete();
                }
                String stderr = this.mergeRender(merged, transcoded);
                this.log.debug("=====\n{}", (Object)stderr);
                if (transcoded.exists()) {
                    FileInputStream fis = new FileInputStream(transcoded);
                    String pid = transcoded.getName();
                    Payload p = StorageUtils.createOrUpdatePayload((DigitalObject)object, (String)pid, (InputStream)fis);
                    fis.close();
                    p.setType(PayloadType.Source);
                    object.setSourceId(pid);
                    for (String sId : segmentIds) {
                        object.removePayload(sId);
                    }
                    props.remove("mediaSegments");
                    object.close();
                    for (File f : files.values()) {
                        if (!f.exists()) continue;
                        f.delete();
                    }
                    merged.delete();
                    transcoded.delete();
                }
            }
            catch (IOException ex) {
                this.log.error("Error merging segments: ", (Throwable)ex);
            }
        }
        catch (StorageException ex) {
            this.log.error("Error accessing object metadata: ", (Throwable)ex);
        }
    }

    private void mergeSegment(OutputStream out, File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            in.close();
        }
    }

    private File basicMpeg(DigitalObject object, String pid) throws Exception {
        File sourceFile = this.cacheFile(object, pid);
        String ext = FilenameUtils.getExtension((String)pid);
        String output = pid.substring(0, pid.length() - ext.length()) + "mpg";
        File outputFile = new File(this.outputDir, "output_" + output);
        if (outputFile.exists()) {
            FileUtils.deleteQuietly((File)outputFile);
        }
        this.log.info("Converting '{}': '{}'", (Object)sourceFile.getName(), (Object)outputFile.getName());
        String stderr = this.mergeRender(sourceFile, outputFile);
        this.log.debug("=====\n{}", (Object)stderr);
        if (outputFile.exists()) {
            return outputFile;
        }
        return null;
    }

    private String mergeRender(File in, File out) throws IOException {
        ArrayList<String> params = new ArrayList<String>();
        params.add("-i");
        params.add(in.getAbsolutePath());
        params.add("-sameq");
        params.add("-r");
        if (out.getName().equals(MERGED_PAYLOAD + this.finalFormat)) {
            params.add(this.finalRate);
        } else {
            params.add(this.mergeRate);
        }
        params.add(out.getAbsolutePath());
        return this.ffmpeg.transform(params, this.outputDir);
    }

    private PayloadType resolveType(String type) {
        if (type == null) {
            return PayloadType.Enrichment;
        }
        try {
            PayloadType pt = PayloadType.valueOf((String)type);
            return pt;
        }
        catch (Exception ex) {
            return PayloadType.Enrichment;
        }
    }

    private String getFormat(String extension) {
        List<JsonSimple> formatList = this.getJsonList(null, "supportedFormats");
        for (JsonSimple json : formatList) {
            String group = json.getString(null, new Object[]{"group"});
            List<String> extensions = this.getList(json, ",", "extensions");
            for (String ext : extensions) {
                if (!extension.equalsIgnoreCase(ext)) continue;
                return group;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorAndClose(DigitalObject object) {
        try {
            this.createFfmpegErrorPayload(object);
        }
        catch (Exception ex) {
            JsonObject content = new JsonObject();
            for (String key : this.errors.keySet()) {
                content.put((Object)key, (Object)this.errors.get(key));
            }
            this.log.error("Unable to write error payload, {}", (Throwable)ex);
            this.log.error("Errors:\n{}", (Object)content.toString());
        }
        finally {
            this.closeObject(object);
        }
    }

    private void closeObject(DigitalObject object) {
        try {
            object.close();
        }
        catch (StorageException ex) {
            this.log.error("Failed writing object metadata", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileMetadata(DigitalObject object) {
        File metaFile;
        if (this.info == null) {
            return true;
        }
        if (!this.info.isSupported()) {
            return true;
        }
        JsonObject fullMetadata = null;
        try {
            fullMetadata = new JsonSimple(this.info.toString()).getJsonObject();
        }
        catch (IOException ex) {
            this.addError("metadata", "Error parsing metadata output", ex);
            return false;
        }
        if (!this.metadata.isEmpty()) {
            JsonObject metadataObject = new JsonObject();
            for (String key : this.metadata.keySet()) {
                metadataObject.put((Object)key, (Object)this.metadata.get(key));
            }
            fullMetadata.put((Object)"outputs", (Object)metadataObject);
        }
        try {
            metaFile = this.writeMetadata(fullMetadata.toString());
            if (metaFile == null) {
                this.addError("metadata", "Unknown error extracting metadata");
                return false;
            }
        }
        catch (TransformerException ex) {
            this.addError("metadata", "Error writing metadata to disk", (Exception)((Object)ex));
            return false;
        }
        try {
            Payload payload = this.createFfmpegPayload(object, metaFile);
            payload.setType(PayloadType.Enrichment);
            payload.close();
        }
        catch (Exception ex) {
            this.addError("metadata", "Error storing metadata payload", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            metaFile.delete();
        }
        return true;
    }

    public Payload createFfmpegErrorPayload(DigitalObject object) throws StorageException, FileNotFoundException, UnsupportedEncodingException {
        JsonObject content = new JsonObject();
        for (String key : this.errors.keySet()) {
            content.put((Object)key, (Object)this.errors.get(key));
        }
        this.log.debug("\nErrors:\n{}", (Object)content.toString());
        ByteArrayInputStream data = new ByteArrayInputStream(content.toString().getBytes("UTF-8"));
        Payload payload = StorageUtils.createOrUpdatePayload((DigitalObject)object, (String)ERROR_PAYLOAD, (InputStream)data);
        payload.setType(PayloadType.Error);
        payload.setContentType("application/json");
        payload.setLabel("FFMPEG conversion errors");
        return payload;
    }

    public Payload createFfmpegPayload(DigitalObject object, File file) throws StorageException, FileNotFoundException {
        String name = file.getName();
        Payload payload = StorageUtils.createOrUpdatePayload((DigitalObject)object, (String)name, (InputStream)new FileInputStream(file));
        payload.setContentType(MimeTypeUtil.getMimeType((String)name));
        payload.setLabel(name);
        return payload;
    }

    private void readMetadata(DigitalObject object) {
        Set pids = object.getPayloadIdList();
        if (pids.contains(METADATA_PAYLOAD)) {
            try {
                Payload payload = object.getPayload(METADATA_PAYLOAD);
                JsonSimple data = new JsonSimple(payload.open());
                payload.close();
                this.oldMetadata = JsonSimple.toJavaMap((JsonObject)data.getObject(new Object[]{"outputs"}));
            }
            catch (IOException ex) {
                this.log.error("Error parsing metadata JSON: ", (Throwable)ex);
            }
            catch (StorageException ex) {
                this.log.error("Error accessing metadata payload: ", (Throwable)ex);
            }
        }
    }

    private File writeMetadata(String data) throws TransformerException {
        File outputFile = new File(this.outputDir, METADATA_PAYLOAD);
        if (outputFile.exists()) {
            FileUtils.deleteQuietly((File)outputFile);
        }
        try {
            outputFile.createNewFile();
            FileUtils.writeStringToFile((File)outputFile, (String)data, (String)"utf-8");
        }
        catch (IOException ioe) {
            throw new TransformerException((Throwable)ioe);
        }
        return outputFile;
    }

    private File convert(File sourceFile, JsonSimple render, FfmpegInfo info) throws TransformerException {
        long timeSpent;
        long startTime;
        String resolution;
        String codecString;
        ArrayList<String> statParams = new ArrayList<String>();
        ArrayList<String> params = new ArrayList<String>();
        String outputName = render.getString(null, new Object[]{"name"});
        if (outputName == null) {
            return null;
        }
        File outputFile = new File(this.outputDir, outputName);
        if (outputFile.exists()) {
            FileUtils.deleteQuietly((File)outputFile);
        }
        this.log.info("Converting '{}': '{}'", (Object)sourceFile.getName(), (Object)outputFile.getName());
        JsonObject renderMetadata = new JsonObject();
        String key = this.jsonKey(outputName);
        String formatString = render.getString(null, new Object[]{"formatMetadata"});
        if (formatString != null) {
            renderMetadata.put((Object)"format", (Object)formatString);
        }
        if ((codecString = render.getString(null, new Object[]{"codecMetadata"})) != null) {
            renderMetadata.put((Object)"codec", (Object)codecString);
        }
        try {
            long fileSize;
            params.add("-i");
            params.add(sourceFile.getAbsolutePath());
            params.add("-y");
            String optionStr = render.getString("", new Object[]{"options"});
            List<String> options = this.split(optionStr, " ");
            long start = 0L;
            for (int i = 0; i < options.size(); ++i) {
                String option = options.get(i);
                statParams.add(option);
                if (option.equalsIgnoreCase("[[OFFSET]]")) {
                    start = (long)(Math.random() * (double)info.getDuration() * 0.25);
                    option = Long.toString(start);
                }
                params.add(option);
            }
            String audioStr = render.getString(null, new Object[]{"audioOnly"});
            boolean audio = Boolean.parseBoolean(audioStr);
            if (!audio) {
                List<String> dimensions = this.getPaddedParams(render, info, renderMetadata, statParams);
                if (dimensions == null || dimensions.isEmpty()) {
                    this.addError(key, "Error calculating dimensions");
                    return null;
                }
                params.addAll(dimensions);
            }
            String width = (String)renderMetadata.get((Object)"width");
            String height = (String)renderMetadata.get((Object)"height");
            resolution = width == null || height == null ? "0x0" : width + "x" + height;
            optionStr = render.getString("", new Object[]{"output"});
            options = this.split(optionStr, " ");
            if (!options.isEmpty()) {
                params.addAll(options);
                statParams.addAll(options);
            }
            params.add(outputFile.getAbsolutePath());
            startTime = new Date().getTime();
            String stderr = this.ffmpeg.transform(params, this.outputDir);
            timeSpent = new Date().getTime() - startTime;
            renderMetadata.put((Object)"timeSpent", (Object)String.valueOf(timeSpent));
            renderMetadata.put((Object)"debugOutput", (Object)stderr);
            if (outputFile.exists()) {
                fileSize = outputFile.length();
                if (fileSize == 0L) {
                    throw new TransformerException("File conversion failed!\n=====\n" + stderr);
                }
            } else {
                throw new TransformerException("File conversion failed!\n=====\n" + stderr);
            }
            renderMetadata.put((Object)"size", (Object)String.valueOf(fileSize));
        }
        catch (IOException ioe) {
            this.addError(key, "Failed to convert!", ioe);
            throw new TransformerException((Throwable)ioe);
        }
        if (outputFile.getName().contains("nullFile")) {
            return null;
        }
        this.metadata.put(key, renderMetadata);
        if (this.stats != null) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("oid", this.oid);
            data.put("datetime", String.valueOf(startTime));
            data.put("timespent", String.valueOf(timeSpent));
            data.put("renderString", StringUtils.join(statParams, (String)" "));
            data.put("mediaduration", String.valueOf(info.getDuration()));
            data.put("inresolution", info.getWidth() + "x" + info.getHeight());
            data.put("outresolution", resolution);
            data.put("insize", String.valueOf(sourceFile.length()));
            data.put("outsize", String.valueOf(outputFile.length()));
            data.put("infile", sourceFile.getName());
            data.put("outfile", outputFile.getName());
            try {
                this.stats.storeTranscoding(data);
            }
            catch (Exception ex) {
                this.log.error("Error storing statistics: ", (Throwable)ex);
            }
        }
        return outputFile;
    }

    private List<String> getPaddedParams(JsonSimple renderConfig, FfmpegInfo info, JsonObject renderMetadata, List<String> stats) {
        ArrayList<String> response = new ArrayList<String>();
        int maxX = renderConfig.getInteger(Integer.valueOf(-1), new Object[]{"maxWidth"});
        int maxY = renderConfig.getInteger(Integer.valueOf(-1), new Object[]{"maxHeight"});
        String size = this.getSize(info.getWidth(), info.getHeight(), maxX, maxY);
        if (size == null) {
            return null;
        }
        int i = size.indexOf("x");
        int x = this.makeEven(Integer.parseInt(size.substring(0, i)));
        int y = this.makeEven(Integer.parseInt(size.substring(i + 1)));
        String paddingConfig = renderConfig.getString("none", new Object[]{"padding"});
        String paddingColor = renderConfig.getString("black", new Object[]{"paddingColor"});
        if (paddingConfig.equalsIgnoreCase("none") || maxX == -1 || maxY == -1) {
            response.add("-s");
            response.add(size);
            renderMetadata.put((Object)"width", (Object)String.valueOf(x));
            renderMetadata.put((Object)"height", (Object)String.valueOf(y));
            stats.add("padding");
            stats.add("{none}");
            return response;
        }
        int padXleft = this.makeEven((maxX - x) / 2);
        int padXright = this.makeEven(maxX - x - padXleft);
        int padYtop = this.makeEven((maxY - y) / 2);
        int padYbottom = this.makeEven(maxY - y - padYtop);
        String width = String.valueOf(padXleft + x + padXright);
        String height = String.valueOf(padYtop + y + padYbottom);
        renderMetadata.put((Object)"width", (Object)width);
        renderMetadata.put((Object)"height", (Object)height);
        if (paddingConfig.equalsIgnoreCase("individual")) {
            response.add("-s");
            response.add(size);
            response.add("-padtop");
            response.add(String.valueOf(padYtop));
            response.add("-padbottom");
            response.add(String.valueOf(padYbottom));
            response.add("-padleft");
            response.add(String.valueOf(padXleft));
            response.add("-padright");
            response.add(String.valueOf(padXright));
            response.add("-padcolor");
            response.add(paddingColor);
            stats.add("padding");
            stats.add("{individual}");
            return response;
        }
        if (paddingConfig.equalsIgnoreCase("filter")) {
            String filter = "pad=" + width + ":" + height + ":" + padXleft + ":" + padYtop + ":" + paddingColor;
            response.add("-s");
            response.add(size);
            response.add("-vf");
            response.add(filter);
            stats.add("padding");
            stats.add("{filter}");
            return response;
        }
        this.log.error("Invalid padding config found: '{}'", (Object)paddingConfig);
        response.add("-s");
        response.add(size);
        stats.add("padding");
        stats.add("{invalid}");
        return response;
    }

    private int makeEven(int input) {
        if (input % 2 == 1) {
            return input - 1;
        }
        return input;
    }

    private String getSize(int width, int height, int maxWidth, int maxHeight) {
        float dY;
        float scale = 0.0f;
        float dX = maxWidth != -1 ? (float)width / (float)maxWidth : -1.0f;
        float f = dY = maxWidth != -1 ? (float)height / (float)maxHeight : -1.0f;
        scale = dY > dX ? dY : (dX != 0.0f && dX != -1.0f ? dX : 1.0f);
        int newWidth = this.makeEven(Math.round((float)width / scale));
        int newHeight = this.makeEven(Math.round((float)height / scale));
        return newWidth + "x" + newHeight;
    }

    private String jsonKey(String input) {
        return input.replace(" ", "_");
    }

    public String getId() {
        return "ffmpeg";
    }

    public String getName() {
        return "FFMPEG Transformer";
    }

    public PluginDescription getPluginDetails() {
        PluginDescription pd = new PluginDescription((Plugin)this);
        JsonSimple details = null;
        String availability = "Unknown";
        if (this.config == null) {
            try {
                details = new JsonSimple(pd.getMetadata());
            }
            catch (IOException ioe) {
                this.log.error("Error parsing plugin description JSON");
            }
        } else {
            details = new JsonSimple();
            availability = this.testExecLevel();
        }
        details.writeObject(new Object[]{"debug"}).put((Object)"availability", (Object)availability);
        pd.setMetadata(details.toString());
        return pd;
    }

    private List<JsonSimple> getJsonList(JsonSimple json, Object ... path) {
        ArrayList response = null;
        if (json != null) {
            response = json.getJsonSimpleList(path);
        }
        if (response == null) {
            response = this.config.getJsonSimpleList(path);
        }
        if (response == null) {
            response = new ArrayList();
        }
        return response;
    }

    private List<String> getList(JsonSimple json, String separator, Object ... path) {
        String configEntry = this.get(json, null, path);
        if (configEntry == null) {
            return new ArrayList<String>();
        }
        return this.split(configEntry, separator);
    }

    private String get(JsonSimple json, String value, Object ... path) {
        String configEntry = null;
        if (json != null) {
            configEntry = json.getString(null, path);
        }
        if (configEntry == null) {
            configEntry = this.config.getString(value, path);
        }
        return configEntry;
    }

    private List<String> split(String original, String separator) {
        return Arrays.asList(StringUtils.split((String)original, (String)separator));
    }

    public void shutdown() throws PluginException {
        if (this.stats != null) {
            try {
                this.stats.shutdown();
            }
            catch (Exception ex) {
                this.log.error("Error shutting down database: ", (Throwable)ex);
                throw new PluginException((Throwable)ex);
            }
        }
    }
}

