/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.ice2;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.api.transformer.Transformer;
import com.googlecode.fascinator.api.transformer.TransformerException;
import com.googlecode.fascinator.common.BasicHttpClient;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.MimeTypeUtil;
import com.googlecode.fascinator.common.sax.SafeSAXReader;
import com.googlecode.fascinator.common.storage.StorageUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ice2Transformer
implements Transformer {
    private Logger log = LoggerFactory.getLogger(Ice2Transformer.class);
    private JsonSimpleConfig config;
    private JsonSimple itemConfig;
    private File outputDir;
    private String convertUrl;
    private SafeSAXReader reader;
    private Boolean priority;
    private static final String ZIP_MIME_TYPE = "application/zip";
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String IMG_MIME_TYPE = "image/";
    private boolean firstRun = true;
    private List<String> excludeList;
    private List<String> thumbnails;
    private List<String> previews;

    public void init(File jsonFile) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonFile);
            this.itemConfig = new JsonSimple();
            this.reset();
        }
        catch (IOException ioe) {
            throw new PluginException((Throwable)ioe);
        }
    }

    public void init(String jsonString) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonString);
            this.itemConfig = new JsonSimple();
            this.reset();
        }
        catch (IOException ioe) {
            throw new PluginException((Throwable)ioe);
        }
    }

    private void reset() throws TransformerException {
        Boolean testResponse;
        if (this.firstRun) {
            this.firstRun = false;
            String outputPath = this.config.getString(null, new Object[]{"outputPath"});
            if (outputPath == null) {
                throw new TransformerException("Output path not specified!");
            }
            this.outputDir = new File(outputPath);
            this.outputDir.mkdirs();
            this.excludeList = Arrays.asList(StringUtils.split((String)this.config.getString(null, new Object[]{"excludeRenditionExt"}), (char)','));
            this.convertUrl = this.config.getString(null, new Object[]{"url"});
            if (this.convertUrl == null) {
                throw new TransformerException("No ICE URL provided!");
            }
        }
        this.priority = (testResponse = this.itemConfig.getBoolean(null, new Object[]{"priority"})) != null ? testResponse : this.config.getBoolean(Boolean.valueOf(true), new Object[]{"priority"});
        this.reader = new SafeSAXReader();
        this.thumbnails = null;
        this.previews = null;
    }

    public DigitalObject transform(DigitalObject object, String jsonConfig) throws TransformerException {
        File file;
        try {
            this.itemConfig = new JsonSimple(jsonConfig);
        }
        catch (IOException ex) {
            throw new TransformerException("Invalid configuration! '{}'", (Throwable)ex);
        }
        this.reset();
        String sourceId = object.getSourceId();
        String ext = FilenameUtils.getExtension((String)sourceId);
        String fileName = FilenameUtils.getBaseName((String)sourceId);
        try {
            file = new File(this.outputDir, sourceId);
            FileOutputStream out = new FileOutputStream(file);
            Payload payload = object.getPayload(sourceId);
            IOUtils.copy((InputStream)payload.open(), (OutputStream)out);
            payload.close();
            out.close();
        }
        catch (IOException ex) {
            this.log.error("Error writing temp file : ", (Throwable)ex);
            return object;
        }
        catch (StorageException ex) {
            this.log.error("Error accessing storage data : ", (Throwable)ex);
            return object;
        }
        if (file.exists() && !this.excludeList.contains(ext.toLowerCase())) {
            try {
                if (this.isSupported(file)) {
                    File outputFile = this.render(file);
                    outputFile.deleteOnExit();
                    object = this.createIcePayload(object, outputFile);
                    outputFile.delete();
                }
            }
            catch (Exception e) {
                this.log.debug("Adding error payload to {}", (Object)object.getId());
                try {
                    object = this.createErrorPayload(object, fileName, e);
                }
                catch (Exception e1) {
                    this.log.error("Error creating error payload", (Throwable)e1);
                }
            }
        }
        try {
            object.close();
        }
        catch (StorageException ex) {
            this.log.error("Failed writing object metadata", (Throwable)ex);
        }
        if (file.exists()) {
            file.delete();
        }
        return object;
    }

    public DigitalObject createErrorPayload(DigitalObject object, String file, Exception ex) throws StorageException, UnsupportedEncodingException {
        String name = file + "_ice_error.htm";
        String message = ex.getMessage();
        if (message == null) {
            message = ex.toString();
        }
        Payload errorPayload = StorageUtils.createOrUpdatePayload((DigitalObject)object, (String)name, (InputStream)new ByteArrayInputStream(message.getBytes("UTF-8")));
        errorPayload.setType(PayloadType.Error);
        errorPayload.setLabel("ICE conversion errors");
        errorPayload.setContentType(HTML_MIME_TYPE);
        return object;
    }

    public DigitalObject createIcePayload(DigitalObject object, File file) throws StorageException, IOException, Exception {
        if (ZIP_MIME_TYPE.equals(MimeTypeUtil.getMimeType((File)file))) {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                String mimeType = MimeTypeUtil.getMimeType((String)name);
                InputStream in = zipFile.getInputStream(entry);
                if (mimeType.equals(HTML_MIME_TYPE)) {
                    try {
                        this.log.debug("Stripping unnecessary HTML");
                        Document doc = this.reader.loadDocumentFromStream(in);
                        Node node = doc.selectSingleNode("//*[local-name()='body']");
                        node.setName("div");
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        this.reader.docToStream(node, (OutputStream)out);
                        in = new ByteArrayInputStream(out.toByteArray());
                    }
                    catch (DocumentException ex) {
                        this.createErrorPayload(object, name, (Exception)((Object)ex));
                        continue;
                    }
                    catch (Exception ex) {
                        this.log.error("Error : ", (Throwable)ex);
                        continue;
                    }
                }
                PayloadType pt = null;
                try {
                    pt = this.assignType(object, name, mimeType);
                }
                catch (TransformerException ex) {
                    throw new Exception("Error examining object to assign type: ", ex);
                }
                if (pt == null) {
                    return object;
                }
                Payload icePayload = StorageUtils.createOrUpdatePayload((DigitalObject)object, (String)name, (InputStream)in);
                icePayload.setLabel(name);
                icePayload.setContentType(mimeType);
                icePayload.setType(pt);
                icePayload.close();
            }
            zipFile.close();
        } else {
            String name = file.getName();
            String mimeType = MimeTypeUtil.getMimeType((String)name);
            PayloadType pt = null;
            try {
                pt = this.assignType(object, name, mimeType);
            }
            catch (TransformerException ex) {
                throw new Exception("Error examining object to assign type: ", ex);
            }
            if (pt == null) {
                return object;
            }
            Payload icePayload = StorageUtils.createOrUpdatePayload((DigitalObject)object, (String)name, (InputStream)new FileInputStream(file));
            icePayload.setLabel(name);
            icePayload.setContentType(mimeType);
            icePayload.setType(pt);
            icePayload.close();
        }
        return object;
    }

    private PayloadType assignType(DigitalObject object, String pid, String mimeType) throws TransformerException {
        if (this.thumbnails == null) {
            this.getThumbAndPreviews(object);
            this.cleanObject(object);
        }
        if (this.thumbnails.contains(pid)) {
            return PayloadType.Thumbnail;
        }
        if (this.previews.contains(pid)) {
            return PayloadType.Preview;
        }
        if (mimeType.equals(HTML_MIME_TYPE) || mimeType.contains(IMG_MIME_TYPE) && pid.contains("_preview")) {
            if (!this.previews.isEmpty()) {
                if (this.priority.booleanValue()) {
                    String oldPid = this.previews.get(0);
                    this.changeType(object, oldPid, PayloadType.AltPreview);
                    this.previews.remove(oldPid);
                    this.previews.add(pid);
                    return PayloadType.Preview;
                }
                return PayloadType.AltPreview;
            }
            this.previews.add(pid);
            return PayloadType.Preview;
        }
        if (mimeType.contains(IMG_MIME_TYPE) && pid.contains("_thumbnail.jpg")) {
            if (!this.thumbnails.isEmpty()) {
                if (this.priority.booleanValue()) {
                    String oldPid = this.thumbnails.get(0);
                    this.changeType(object, oldPid, PayloadType.Enrichment);
                    this.thumbnails.remove(oldPid);
                    this.thumbnails.add(pid);
                    return PayloadType.Thumbnail;
                }
                return null;
            }
            this.thumbnails.add(pid);
            return PayloadType.Thumbnail;
        }
        return PayloadType.Enrichment;
    }

    private void cleanObject(DigitalObject object) throws TransformerException {
        boolean success;
        String[] loop;
        String keeper;
        if (this.thumbnails.size() > 1) {
            keeper = this.thumbnails.get(0);
            for (String pid : loop = this.thumbnails.toArray(new String[0])) {
                if (pid.equals(keeper)) continue;
                success = this.changeType(object, pid, PayloadType.Enrichment);
                if (!success) {
                    throw new TransformerException("Object has multiple thumbnails, error accessing payloads to correct");
                }
                this.thumbnails.remove(pid);
            }
        }
        if (this.previews.size() > 1) {
            keeper = this.previews.get(0);
            for (String pid : loop = this.previews.toArray(new String[0])) {
                if (pid.equals(keeper)) continue;
                success = this.changeType(object, pid, PayloadType.AltPreview);
                if (!success) {
                    throw new TransformerException("Object has multiple previews, error accessing payloads to correct");
                }
                this.previews.remove(pid);
            }
        }
    }

    private boolean changeType(DigitalObject object, String pid, PayloadType newType) {
        try {
            Payload payload = object.getPayload(pid);
            payload.setType(newType);
            payload.close();
            return true;
        }
        catch (StorageException ex) {
            this.log.error("Error accessing payload: '{}'", (Object)pid, (Object)ex);
            return false;
        }
    }

    private File render(File sourceFile) throws TransformerException {
        this.log.info("Converting {}...", (Object)sourceFile);
        String filename = sourceFile.getName();
        String basename = FilenameUtils.getBaseName((String)filename);
        String ext = FilenameUtils.getExtension((String)filename);
        int status = 200;
        JsonObject object = this.itemConfig.getObject(new Object[]{"resize"});
        Map resizeConfig = JsonSimple.toJavaMap((JsonObject)object);
        if ((resizeConfig == null || resizeConfig.isEmpty()) && ((resizeConfig = JsonSimple.toJavaMap((JsonObject)(object = this.config.getObject(new Object[]{"resize"})))) == null || resizeConfig.isEmpty())) {
            throw new TransformerException("No resizing configuration found.");
        }
        String resizeJson = "";
        for (String key : resizeConfig.keySet()) {
            JsonSimple j = (JsonSimple)resizeConfig.get(key);
            resizeJson = resizeJson + "\"" + key + "\":" + j.toString() + ",";
        }
        PostMethod post = new PostMethod(this.convertUrl);
        try {
            Part[] parts = new Part[]{new StringPart("zip", "on"), new StringPart("dc", "on"), new StringPart("toc", "on"), new StringPart("pdflink", "on"), new StringPart("addThumbnail", "on"), new StringPart("pathext", ext), new StringPart("template", this.getTemplate()), new StringPart("multipleImageOptions", "{" + StringUtils.substringBeforeLast((String)resizeJson, (String)",") + "}"), new StringPart("mode", "download"), new FilePart("file", sourceFile)};
            post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
            BasicHttpClient client = new BasicHttpClient(this.convertUrl);
            this.log.debug("Using conversion URL: {}", (Object)this.convertUrl);
            status = client.executeMethod((HttpMethodBase)post);
            this.log.debug("HTTP status: {} {}", (Object)status, (Object)HttpStatus.getStatusText((int)status));
        }
        catch (IOException ioe) {
            throw new TransformerException("Failed to send ICE conversion request", (Throwable)ioe);
        }
        try {
            if (status != 200) {
                String xmlError = post.getResponseBodyAsString();
                this.log.debug("Error: {}", (Object)xmlError);
                throw new TransformerException(xmlError);
            }
            String type = post.getResponseHeader("Content-Type").getValue();
            if (ZIP_MIME_TYPE.equals(type)) {
                filename = basename + ".zip";
            } else if (type.startsWith(IMG_MIME_TYPE)) {
                filename = basename + "_thumbnail.jpg";
            } else if ("video/x-flv".equals(type)) {
                filename = basename + ".flv";
            } else if ("audio/mpeg".equals(type)) {
                filename = basename + ".mp3";
            }
            File outputFile = new File(this.outputDir, filename);
            if (outputFile.exists()) {
                outputFile.delete();
            }
            InputStream in = post.getResponseBodyAsStream();
            FileOutputStream out = new FileOutputStream(outputFile);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.close();
            this.log.debug("ICE output file: {}", (Object)outputFile);
            return outputFile;
        }
        catch (IOException ioe) {
            throw new TransformerException("Failed to process ICE output", (Throwable)ioe);
        }
    }

    private boolean isSupported(File sourceFile) throws TransformerException {
        String ext = FilenameUtils.getExtension((String)sourceFile.getName());
        String url = this.convertUrl + "/query?pathext=" + ext.toLowerCase();
        try {
            GetMethod getMethod = new GetMethod(url);
            BasicHttpClient extClient = new BasicHttpClient(url);
            extClient.executeMethod((HttpMethodBase)getMethod);
            String response = getMethod.getResponseBodyAsString().trim();
            return "OK".equals(response);
        }
        catch (IOException ioe) {
            throw new TransformerException("Failed to query if file type is supported", (Throwable)ioe);
        }
    }

    private String getTemplate() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("/template.xhtml"), (OutputStream)out);
        return out.toString("UTF-8");
    }

    public String getId() {
        return "ice2";
    }

    public String getName() {
        return "ICE Transformer";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void shutdown() throws PluginException {
    }

    private void getThumbAndPreviews(DigitalObject object) {
        this.thumbnails = new ArrayList<String>();
        this.previews = new ArrayList<String>();
        for (String pid : object.getPayloadIdList()) {
            try {
                Payload p = object.getPayload(pid);
                if (p.getType().compareTo((Enum)PayloadType.Thumbnail) == 0) {
                    this.thumbnails.add(pid);
                }
                if (p.getType().compareTo((Enum)PayloadType.Preview) != 0) continue;
                this.previews.add(pid);
            }
            catch (StorageException ex) {
                this.log.error("Error looking at payload: '{}'", (Object)pid);
            }
        }
    }
}

