/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.ims;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.PayloadType;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.api.transformer.Transformer;
import com.googlecode.fascinator.api.transformer.TransformerException;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.MimeTypeUtil;
import com.googlecode.fascinator.common.storage.StorageUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImsTransformer
implements Transformer {
    private static Logger log = LoggerFactory.getLogger(ImsTransformer.class);
    private JsonSimpleConfig config;
    private String manifestFile = "imsmanifest.xml";
    private boolean firstRun = true;

    public void init(File jsonFile) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonFile);
            this.reset();
        }
        catch (IOException e) {
            log.error("Error reading config: ", (Throwable)e);
        }
    }

    public void init(String jsonString) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonString);
            this.reset();
        }
        catch (IOException e) {
            log.error("Error reading config: ", (Throwable)e);
        }
    }

    private void reset() throws TransformerException {
        if (this.firstRun) {
            this.firstRun = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigitalObject transform(DigitalObject in, String jsonConfig) throws TransformerException {
        File inFile;
        JsonSimple itemConfig;
        this.reset();
        try {
            itemConfig = new JsonSimple(jsonConfig);
        }
        catch (IOException ex) {
            throw new TransformerException("Invalid configuration! '{}'", (Throwable)ex);
        }
        String sourceId = in.getSourceId();
        String ext = FilenameUtils.getExtension((String)sourceId);
        if (!ext.equalsIgnoreCase("zip")) {
            return in;
        }
        String filePath = itemConfig.getString(null, new Object[]{"sourceFile"});
        if (filePath != null) {
            inFile = new File(filePath);
        } else {
            try {
                inFile = File.createTempFile("ims", ".zip");
                inFile.deleteOnExit();
                FileOutputStream tempFileOut = new FileOutputStream(inFile);
                Payload tempPayload = in.getPayload(sourceId);
                IOUtils.copy((InputStream)tempPayload.open(), (OutputStream)tempFileOut);
                tempPayload.close();
                tempFileOut.close();
            }
            catch (IOException ex) {
                log.error("Error writing temp file : ", (Throwable)ex);
                return in;
            }
            catch (StorageException ex) {
                log.error("Error accessing storage data : ", (Throwable)ex);
                return in;
            }
        }
        if (inFile.exists()) {
            log.info("Unpacking IMS Package: '{}'", (Object)inFile.getName());
            try {
                in = this.createImsPayload(in, inFile);
            }
            catch (StorageException e) {
                log.error("Error accessing storage: ", (Throwable)e);
            }
            catch (IOException e) {
                log.error("Error reading ZIP: ", (Throwable)e);
            }
            finally {
                inFile.delete();
            }
        } else {
            log.info("not found inFile {}", (Object)inFile);
        }
        return in;
    }

    public DigitalObject createImsPayload(DigitalObject object, File file) throws StorageException, IOException {
        boolean htmlPreview = false;
        ZipFile zipFile = new ZipFile(file);
        ZipEntry manifestEntry = zipFile.getEntry(this.manifestFile);
        if (manifestEntry != null) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                Payload imsPayload = StorageUtils.createOrUpdatePayload((DigitalObject)object, (String)name, (InputStream)zipFile.getInputStream(entry));
                if (name.startsWith("index.htm")) {
                    imsPayload.setType(PayloadType.Preview);
                    log.info("New preview found: '{}'", (Object)name);
                    htmlPreview = true;
                } else {
                    imsPayload.setType(PayloadType.Enrichment);
                }
                imsPayload.setLabel(name);
                imsPayload.setContentType(MimeTypeUtil.getMimeType((String)name));
                imsPayload.close();
            }
            if (htmlPreview) {
                Properties prop = object.getMetadata();
                prop.setProperty("displayType", "html");
                prop.setProperty("previewType", "html");
                object.close();
            }
        } else {
            log.debug("No manifest entry: '{}'", (Object)this.manifestFile);
        }
        return object;
    }

    public String getId() {
        return "ims";
    }

    public String getName() {
        return "IMS Transformer";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void shutdown() throws PluginException {
    }

    public String getFileExt(File fileName) {
        return fileName.getName().substring(fileName.getName().lastIndexOf(46));
    }
}

