/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.jsonVelocity;

import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.api.transformer.TransformerException;
import com.googlecode.fascinator.transformer.jsonVelocity.JsonVelocityTransformer;
import com.itextpdf.text.DocumentException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class JsonVelocityPDFTransformer
extends JsonVelocityTransformer {
    public String getId() {
        return "jsonVelocityPDF";
    }

    public String getName() {
        return "Json Velocity PDF Transformer";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Payload storeData(DigitalObject object, String pid, String data) throws TransformerException {
        try {
            try {
                if (this.itemConfig.getBoolean(Boolean.valueOf(false), new Object[]{"versioning"}).booleanValue()) {
                    String dateStampedPid = this.getTimestampedPayload(pid);
                    object.createStoredPayload(dateStampedPid, this.stream(data));
                }
                return object.createStoredPayload(pid, this.stream(data));
            }
            catch (StorageException ex) {
                try {
                    return object.updatePayload(pid, this.stream(data));
                }
                catch (StorageException ex2) {
                    throw new TransformerException("Error storing payload: ", (Throwable)ex2);
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new TransformerException("Error in data encoding: ", (Throwable)ex);
        }
        catch (DocumentException ex) {
            throw new TransformerException("Error creating PDF (document is not well formed): ", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new TransformerException("Error creating PDF: ", (Throwable)ex);
        }
    }

    private InputStream stream(String string) throws DocumentException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ITextRenderer renderer = new ITextRenderer();
        renderer.setDocumentFromString(string, new File(".").toURI().toURL().toString());
        renderer.layout();
        renderer.createPDF((OutputStream)bos);
        return new ByteArrayInputStream(bos.toByteArray());
    }

    protected String payloadName(String templateName) {
        return templateName.substring(0, templateName.indexOf(".")) + ".pdf";
    }

    protected String getUrlBase() {
        return this.systemConfig.getString(null, new Object[]{"urlBase"});
    }

    protected String getSystemPortal() {
        return this.systemConfig.getString(DEFAULT_PORTAL, new Object[]{"transformerDefaults", "jsonVelocityPDF", "portalId"});
    }

    protected String getSystemPayload() {
        return this.systemConfig.getString(DEFAULT_PAYLOAD, new Object[]{"transformerDefaults", "jsonVelocityPDF", "sourcePayload"});
    }

    protected String getTemplatePath() {
        return this.systemConfig.getString(null, new Object[]{"transformerDefaults", "jsonVelocityPDF", "templatesPath"});
    }
}

