/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.jsonVelocity;

import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.portal.lookup.MintLookupHelper;
import com.googlecode.fascinator.transformer.jsonVelocity.JsonVelocityTransformer;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    static Logger log = LoggerFactory.getLogger(JsonVelocityTransformer.class);

    public Map<String, Object> getList(Map<String, Object> sourceMap, String baseKey) {
        TreeMap<String, Object> valueMap = new TreeMap<String, Object>();
        if (baseKey == null) {
            log.error("NULL baseKey provided!");
            return valueMap;
        }
        if (!baseKey.endsWith(".")) {
            baseKey = baseKey + ".";
        }
        if (sourceMap == null) {
            log.error("NULL sourceMap provided!");
            return valueMap;
        }
        for (String key : sourceMap.keySet()) {
            Map<String, String> data;
            if (!key.startsWith(baseKey)) continue;
            String value = sourceMap.get(key).toString();
            String field = baseKey;
            if (key.length() >= baseKey.length()) {
                field = key.substring(baseKey.length(), key.length());
            }
            String index = field;
            if (field.indexOf(".") > 0) {
                index = field.substring(0, field.indexOf("."));
            }
            if (valueMap.containsKey(index)) {
                data = (Map)valueMap.get(index);
            } else {
                data = new LinkedHashMap();
                valueMap.put(index, data);
            }
            if (value.length() == 1) {
                value = String.valueOf(value.charAt(0));
            }
            data.put(field.substring(field.indexOf(".") + 1, field.length()), value);
        }
        return valueMap;
    }

    public Map<String, Object> getList(JsonSimple json, String baseKey) {
        TreeMap<String, Object> valueMap = new TreeMap<String, Object>();
        if (baseKey == null) {
            log.error("NULL baseKey provided!");
            return valueMap;
        }
        if (!baseKey.endsWith(".")) {
            baseKey = baseKey + ".";
        }
        if (json == null) {
            log.error("NULL JSON object provided!");
            return valueMap;
        }
        for (Object oKey : json.getJsonObject().keySet()) {
            Map<String, String> data;
            String key = (String)oKey;
            if (!key.startsWith(baseKey)) continue;
            String value = json.getString(null, new Object[]{key});
            String field = baseKey;
            if (key.length() >= baseKey.length()) {
                field = key.substring(baseKey.length(), key.length());
            }
            String index = field;
            if (field.indexOf(".") > 0) {
                index = field.substring(0, field.indexOf("."));
            }
            if (valueMap.containsKey(index)) {
                data = (Map)valueMap.get(index);
            } else {
                data = new LinkedHashMap();
                valueMap.put(index, data);
            }
            if (value.length() == 1) {
                value = String.valueOf(value.charAt(0));
            }
            data.put(field.substring(field.indexOf(".") + 1, field.length()), value);
        }
        return valueMap;
    }

    public String get(JsonSimple json, Object ... field) {
        if (json == null) {
            log.error("NULL JSON object provided!");
            return "";
        }
        return json.getString(null, field);
    }

    public String getW3CDateTime(String dateTime) throws ParseException {
        return this.getDateTime(dateTime, "yyyy-MM-dd'T'HH:mm:ssZ");
    }

    public String getDateTime(String dateTime, String format) throws ParseException {
        if (dateTime != null && !"".equals(dateTime)) {
            if (dateTime.indexOf("-") == -1) {
                dateTime = dateTime + "-01-01";
            } else {
                String[] part = dateTime.trim().split("-");
                if (part.length == 2) {
                    dateTime = dateTime + "-01";
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat odf = new SimpleDateFormat(format);
            Date date = sdf.parse(dateTime);
            return odf.format(date);
        }
        return "";
    }

    private String formatDate(Date input) {
        SimpleDateFormat ISO8601Local = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone timeZone = TimeZone.getDefault();
        ISO8601Local.setTimeZone(timeZone);
        DecimalFormat twoDigits = new DecimalFormat("00");
        int offset = ISO8601Local.getTimeZone().getOffset(input.getTime());
        String sign = "+";
        if (offset < 0) {
            offset = -offset;
            sign = "-";
        }
        int hours = offset / 3600000;
        int minutes = (offset - hours * 3600000) / 60000;
        return ISO8601Local.format(input) + sign + twoDigits.format(hours) + ":" + twoDigits.format(minutes);
    }

    public String getMetadata(DigitalObject object, String field) {
        if (object == null) {
            log.error("NULL object provided!");
            return "";
        }
        try {
            Properties metadata = object.getMetadata();
            String result = metadata.getProperty(field);
            if (result == null) {
                return "";
            }
            return result;
        }
        catch (StorageException ex) {
            log.error("Error accessing object metadata: ", (Throwable)ex);
            return "";
        }
    }

    public String encodeXml(String value) {
        return StringEscapeUtils.escapeXml((String)value);
    }

    public String encodeJson(String value) {
        return JSONValue.escape((String)value);
    }

    public ArrayList<String> getMintLabels(JsonSimpleConfig systemConfig, String urlName, String ids) {
        HashMap<String, String> mapIds = new HashMap<String, String>();
        mapIds.put("id", ids);
        try {
            JsonSimple labelsMint = MintLookupHelper.get((JsonSimple)systemConfig, (String)urlName, mapIds);
            ArrayList<String> labels = new ArrayList<String>();
            JSONArray arr = labelsMint.getJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                JsonSimple labelJson = new JsonSimple(arr.get(i).toString());
                labels.add(labelJson.getString("", new Object[]{"label"}));
            }
            return labels;
        }
        catch (Exception ex) {
            log.error("PDF transfer - When retrieving Mint labels: ", (Throwable)ex);
            return null;
        }
    }
}

