/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.jsonVelocity;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.api.transformer.Transformer;
import com.googlecode.fascinator.api.transformer.TransformerException;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.storage.StorageUtils;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import com.googlecode.fascinator.spring.ApplicationContextProvider;
import com.googlecode.fascinator.transformer.jsonVelocity.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonVelocityTransformer
implements Transformer {
    protected static String DEFAULT_PORTAL = "default";
    protected static String DEFAULT_PAYLOAD = "object.tfpackage";
    private static Logger log = LoggerFactory.getLogger(JsonVelocityTransformer.class);
    protected JsonSimpleConfig systemConfig;
    private File systemTemplates;
    private String systemPayload;
    private String systemPortal;
    private String urlBase;
    public Util util;
    public VelocityEngine velocity;
    private File oldTemplates;
    protected JsonSimple itemConfig;
    private File itemTemplates;
    private ScriptingServices scriptingServices;

    public void init(String jsonString) throws PluginException {
        try {
            this.systemConfig = new JsonSimpleConfig(jsonString);
            this.reset();
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws PluginException {
        try {
            this.systemConfig = new JsonSimpleConfig(jsonFile);
            this.reset();
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    private void reset() throws TransformerException {
        if (this.scriptingServices == null && ApplicationContextProvider.getApplicationContext() != null) {
            this.scriptingServices = (ScriptingServices)ApplicationContextProvider.getApplicationContext().getBean("scriptingServices", ScriptingServices.class);
        }
        if (this.util == null) {
            this.util = new Util();
            String templatePath = this.getTemplatePath();
            if (templatePath != null) {
                this.systemTemplates = new File(templatePath);
                if (this.systemTemplates == null || !this.systemTemplates.exists()) {
                    throw new TransformerException("Error finding template path: '" + templatePath + "'");
                }
            }
            this.systemPayload = this.getSystemPayload();
            this.systemPortal = this.getSystemPortal();
            this.urlBase = this.getUrlBase();
            if (this.urlBase == null) {
                throw new TransformerException("No URL base in system config");
            }
        }
        this.itemConfig = null;
        this.itemTemplates = null;
    }

    protected String getUrlBase() {
        return this.systemConfig.getString(null, new Object[]{"urlBase"});
    }

    protected String getSystemPortal() {
        return this.systemConfig.getString(DEFAULT_PORTAL, new Object[]{"transformerDefaults", "jsonVelocity", "portalId"});
    }

    protected String getSystemPayload() {
        return this.systemConfig.getString(DEFAULT_PAYLOAD, new Object[]{"transformerDefaults", "jsonVelocity", "sourcePayload"});
    }

    protected String getTemplatePath() {
        return this.systemConfig.getString(null, new Object[]{"transformerDefaults", "jsonVelocity", "templatesPath"});
    }

    private void initVelocityEngine() throws TransformerException {
        if (this.velocity == null || this.oldTemplates == null || !this.oldTemplates.getAbsolutePath().equals(this.itemTemplates.getAbsolutePath())) {
            log.info("Velocity engine re-initialising. Templates: '{}'", (Object)this.itemTemplates.getAbsolutePath());
            try {
                this.oldTemplates = this.itemTemplates;
                this.velocity = new VelocityEngine();
                this.velocity.setProperty("resource.loader", (Object)"file, class, url");
                this.velocity.setProperty("file.resource.loader.cache", (Object)"false");
                this.velocity.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
                this.velocity.setProperty("url.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.URLResourceLoader");
                this.velocity.setProperty("directive.set.null.allowed", (Object)"true");
                this.velocity.setProperty("runtime.log.logsystem.class", (Object)"com.googlecode.fascinator.transformer.jsonVelocity.LoggingWrapper");
                this.velocity.setProperty("url.resource.loader.root", (Object)"");
                File templateDir = this.itemTemplates;
                if (this.itemTemplates.isFile()) {
                    templateDir = this.itemTemplates.getParentFile();
                }
                this.velocity.setProperty("file.resource.loader.path", (Object)templateDir.getAbsolutePath());
                String portalPath = this.systemConfig.getString("portal", new Object[]{"portal", "home"});
                File portalLibraryFile = new File(portalPath + "/portal-library.vm");
                if (portalLibraryFile.exists()) {
                    this.velocity.setProperty("velocimacro.library", (Object)portalLibraryFile.toURI().toURL().toExternalForm().toString());
                }
                this.velocity.init();
            }
            catch (Exception ex) {
                this.velocity = null;
                throw new TransformerException("Error initialising Velocity: ", (Throwable)ex);
            }
        }
    }

    public String getId() {
        return "jsonVelocity";
    }

    public String getName() {
        return "Json Velocity Transformer";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void shutdown() throws PluginException {
    }

    public DigitalObject transform(DigitalObject in, String jsonConfig) throws TransformerException {
        this.reset();
        try {
            this.itemConfig = new JsonSimple(jsonConfig);
        }
        catch (IOException ex) {
            throw new TransformerException("Invalid configuration! '{}'", (Throwable)ex);
        }
        if (this.okToProcess(in, this.itemConfig)) {
            String source = this.itemConfig.getString(this.systemPayload, new Object[]{"sourcePayload"});
            Payload sourcePayload = null;
            try {
                for (String payloadId : in.getPayloadIdList()) {
                    if (!payloadId.endsWith(source)) continue;
                    source = payloadId;
                }
                log.info("Transforming PID '{}' from OID '{}'", (Object)source, (Object)in.getId());
                sourcePayload = in.getPayload(source);
            }
            catch (StorageException ex) {
                log.error("Error accessing payload in storage: '{}'", (Throwable)ex);
            }
            JsonSimple json = null;
            try {
                json = new JsonSimple(sourcePayload.open());
                sourcePayload.close();
            }
            catch (Exception ex) {
                throw new TransformerException("Error accessing JSON payload: ", (Throwable)ex);
            }
            String portalId = this.itemConfig.getString(this.systemPortal, new Object[]{"portalId"});
            List<File> templates = this.getListOfTemplates();
            if (templates.isEmpty()) {
                log.info("No templates to execute");
                return in;
            }
            this.initVelocityEngine();
            VelocityContext vc = new VelocityContext();
            vc.put("systemConfig", (Object)this.systemConfig);
            vc.put("item", (Object)json);
            vc.put("util", (Object)this.util);
            vc.put("jsonUtil", (Object)this.util);
            vc.put("StringUtils", StringUtils.class);
            vc.put("StringEscapeUtils", StringEscapeUtils.class);
            vc.put("Services", (Object)this.scriptingServices);
            vc.put("oid", (Object)in.getId());
            vc.put("object", (Object)in);
            vc.put("urlBase", (Object)(this.urlBase + portalId));
            JsonObject params = (JsonObject)this.itemConfig.getJsonObject().get((Object)"velocityContextParams");
            if (params != null) {
                for (File key : params.keySet()) {
                    vc.put((String)((Object)key), params.get((Object)key));
                }
            }
            for (File file : templates) {
                String output = null;
                try {
                    Template template = this.velocity.getTemplate(file.getName());
                    log.info("Rendering template: '{}'", (Object)file.getName());
                    output = this.renderTemplate(template, vc);
                }
                catch (Exception ex) {
                    log.error("Error rendering template: '" + file.getName() + "': ", (Throwable)ex);
                }
                if (output == null) {
                    log.error("Unknown error rendering template: '{}'", (Object)file.getName());
                    continue;
                }
                try {
                    String payloadName = this.itemConfig.getString(this.payloadName(file.getName()), new Object[]{"outputFilename"});
                    if (this.itemConfig.getBoolean(Boolean.valueOf(false), new Object[]{"transformSource"}).booleanValue()) {
                        payloadName = sourcePayload.getId();
                    }
                    this.storeData(in, payloadName, output);
                }
                catch (Exception ex) {
                    log.error("Error storing rendered output: '" + file.getName() + "'", (Throwable)ex);
                }
            }
        }
        return in;
    }

    private boolean okToProcess(DigitalObject in, JsonSimple itemConfig) throws TransformerException {
        if (itemConfig.getBoolean(Boolean.valueOf(false), new Object[]{"checkForTFMETAProperty"}).booleanValue()) {
            String propertyName = itemConfig.getString(null, new Object[]{"TFMETAPropertyName"});
            String propertyValue = itemConfig.getString(null, new Object[]{"TFMETAPropertyValue"});
            if (propertyName != null && propertyValue != null) {
                Properties tfMetadata;
                try {
                    tfMetadata = in.getMetadata();
                }
                catch (StorageException e) {
                    throw new TransformerException((Throwable)e);
                }
                if (!propertyValue.equals(tfMetadata.getProperty(propertyName))) {
                    return false;
                }
                if (itemConfig.getBoolean(Boolean.valueOf(false), new Object[]{"clearPropertyOnTransform"}).booleanValue()) {
                    try {
                        tfMetadata.remove(propertyName);
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        tfMetadata.store(output, null);
                        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
                        StorageUtils.createOrUpdatePayload((DigitalObject)in, (String)"TF-OBJ-META", (InputStream)input);
                    }
                    catch (Exception e) {
                        throw new TransformerException((Throwable)e);
                    }
                }
            }
        }
        return true;
    }

    private String renderTemplate(Template template, VelocityContext context) throws TransformerException {
        StringWriter writer = new StringWriter();
        try {
            template.merge((Context)context, (Writer)writer);
        }
        catch (IOException ex) {
            throw new TransformerException("Error rendering template: ", (Throwable)ex);
        }
        return writer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Payload storeData(DigitalObject object, String pid, String data) throws TransformerException {
        try {
            try {
                return object.createStoredPayload(pid, this.stream(data));
            }
            catch (StorageException ex) {
                try {
                    return object.updatePayload(pid, this.stream(data));
                }
                catch (StorageException ex2) {
                    throw new TransformerException("Error storing payload: ", (Throwable)ex2);
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new TransformerException("Error in data encoding: ", (Throwable)ex);
        }
    }

    private InputStream stream(String string) throws UnsupportedEncodingException {
        return new ByteArrayInputStream(string.getBytes("UTF8"));
    }

    public List<File> getListOfTemplates() {
        ArrayList<File> templateList = new ArrayList<File>();
        String templatePath = this.itemConfig.getString(null, new Object[]{"templatesPath"});
        if (templatePath != null) {
            this.itemTemplates = new File(templatePath);
            if (this.itemTemplates == null || !this.itemTemplates.exists()) {
                log.error("Error finding template path: '{}'", (Object)templatePath);
                this.itemTemplates = this.systemTemplates;
            }
        } else {
            this.itemTemplates = this.systemTemplates;
        }
        if (this.itemTemplates == null) {
            log.error("No configured or default templates!");
            return templateList;
        }
        if (this.itemTemplates.isDirectory()) {
            for (File template : this.itemTemplates.listFiles()) {
                if (!template.getName().endsWith(".vm")) continue;
                templateList.add(template);
            }
        } else if (this.itemTemplates.isFile()) {
            templateList.add(this.itemTemplates);
        }
        return templateList;
    }

    protected String payloadName(String templateName) {
        String extension = this.itemConfig.getString("xml", new Object[]{"outputExtension"});
        return templateName.substring(0, templateName.lastIndexOf(".")) + "." + extension;
    }

    protected String getTimestampedPayload(String payloadName) {
        int extensionIndex = payloadName.lastIndexOf(".");
        if (extensionIndex != -1) {
            String extension = payloadName.substring(extensionIndex, payloadName.length());
            return payloadName.substring(0, extensionIndex) + "-" + this.getTimeStamp() + extension;
        }
        return payloadName + "-" + this.getTimeStamp();
    }

    protected String getTimeStamp() {
        SimpleDateFormat convertor = new SimpleDateFormat("yyyyMMddHHmmss");
        return convertor.format(new Date());
    }
}

