/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.jsonVelocity;

import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.StorageDataUtil;
import com.googlecode.fascinator.portal.lookup.MintLookupHelper;
import com.googlecode.fascinator.transformer.jsonVelocity.JsonVelocityTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util
extends StorageDataUtil {
    static Logger log = LoggerFactory.getLogger(JsonVelocityTransformer.class);

    public Map<String, Object> getList(JsonSimple json, String baseKey) {
        TreeMap<String, Object> valueMap = new TreeMap<String, Object>();
        if (baseKey == null) {
            log.error("NULL baseKey provided!");
            return valueMap;
        }
        if (!baseKey.endsWith(".")) {
            baseKey = baseKey + ".";
        }
        if (json == null) {
            log.error("NULL JSON object provided!");
            return valueMap;
        }
        for (Object oKey : json.getJsonObject().keySet()) {
            Map<String, String> data;
            String key = (String)oKey;
            if (!key.startsWith(baseKey)) continue;
            String value = json.getString(null, new Object[]{key});
            String field = baseKey;
            if (key.length() >= baseKey.length()) {
                field = key.substring(baseKey.length(), key.length());
            }
            String index = field;
            if (field.indexOf(".") > 0) {
                index = field.substring(0, field.indexOf("."));
            }
            if (valueMap.containsKey(index)) {
                data = (Map)valueMap.get(index);
            } else {
                data = new LinkedHashMap();
                valueMap.put(index, data);
            }
            if (value.length() == 1) {
                value = String.valueOf(value.charAt(0));
            }
            data.put(field.substring(field.indexOf(".") + 1, field.length()), value);
        }
        return valueMap;
    }

    public ArrayList<String> getMintLabels(JsonSimpleConfig systemConfig, String urlName, String ids) {
        HashMap<String, String> mapIds = new HashMap<String, String>();
        mapIds.put("id", ids);
        try {
            JsonSimple labelsMint = MintLookupHelper.get((JsonSimple)systemConfig, (String)urlName, mapIds);
            ArrayList<String> labels = new ArrayList<String>();
            JSONArray arr = labelsMint.getJsonArray();
            for (int i = 0; i < arr.size(); ++i) {
                JsonSimple labelJson = new JsonSimple(arr.get(i).toString());
                labels.add(labelJson.getString("", new Object[]{"label"}));
            }
            return labels;
        }
        catch (Exception ex) {
            log.error("PDF transfer - When retrieving Mint labels: ", (Throwable)ex);
            return null;
        }
    }
}

