/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer.jython;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.transformer.Transformer;
import com.googlecode.fascinator.api.transformer.TransformerException;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.PythonUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonTransformer
implements Transformer {
    private static Logger log = LoggerFactory.getLogger(JythonTransformer.class);
    private JsonSimpleConfig config;
    private JsonSimple itemConfig;
    private PythonUtils pyUtils;

    public void init(String jsonString) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonString);
            this.reset();
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonFile);
            this.reset();
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    private void reset() throws TransformerException {
        if (this.pyUtils == null) {
            log.info("--Initializing Extractor plugin--");
            try {
                this.pyUtils = new PythonUtils(new JsonSimpleConfig());
            }
            catch (IOException e) {
                log.error("Fail to initialise pyUtils : ", (Throwable)e);
            }
            catch (PluginException e) {
                log.error("Fail to initialise pyUtils : ", (Throwable)e);
            }
        }
    }

    public String getId() {
        return "jython";
    }

    public String getName() {
        return "Jython Extractor";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void shutdown() throws PluginException {
    }

    public DigitalObject transform(DigitalObject in, String jsonConfig) throws TransformerException {
        try {
            this.itemConfig = new JsonSimple(jsonConfig);
        }
        catch (IOException ex) {
            throw new TransformerException("Invalid configuration provided.");
        }
        this.reset();
        try {
            Properties props = in.getMetadata();
            String scriptFile = props.getProperty("jythonScript");
            if (scriptFile != null) {
                File script = new File(scriptFile);
                if (!script.exists()) {
                    log.error("Script file not found: '{}'", (Object)scriptFile);
                    this.restoreAllProperty(props);
                    return in;
                }
                log.info("Running script: '{}'", (Object)scriptFile);
                PythonInterpreter python = new PythonInterpreter();
                python.set("object", (Object)in);
                python.set("config", (Object)this.itemConfig);
                python.set("pyUtils", (Object)this.pyUtils);
                python.set("log", (Object)log);
                python.execfile(scriptFile);
                python.cleanup();
            } else {
                log.info("Script file not found");
            }
            this.restoreAllProperty(props);
        }
        catch (Exception e) {
            ByteArrayOutputStream eOut = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(eOut));
            String eMsg = eOut.toString();
            log.warn("Failed to run script!\n=====\n{}\n=====", (Object)eMsg);
        }
        return in;
    }

    private void restoreAllProperty(Properties props) {
        this.restoreProperty(props, "indexOnHarvest");
        this.restoreProperty(props, "harvestQueue");
        this.restoreProperty(props, "renderQueue");
        this.restoreProperty(props, "jythonScript");
    }

    private void restoreProperty(Properties props, String key) {
        String copyKey = "copyOf_" + key;
        if (props.containsKey(copyKey)) {
            String copyValue = props.remove(copyKey).toString();
            props.setProperty(key, copyValue);
        } else {
            props.remove(key);
        }
    }
}

