/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.transformer;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.transformer.Transformer;
import com.googlecode.fascinator.api.transformer.TransformerException;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import groovy.lang.Binding;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingTransformer
implements Transformer {
    private static Logger log = LoggerFactory.getLogger(ScriptingTransformer.class);
    private JsonSimpleConfig config;
    private static final String PYTHON_SCRIPT_CLASS_NAME = "Transformer";
    private static final String PYTHON_SCRIPT_ACTIVATE_METHOD = "transform";

    public void init(String jsonString) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonString);
            this.reset();
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void init(File jsonFile) throws PluginException {
        try {
            this.config = new JsonSimpleConfig(jsonFile);
            this.reset();
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    private void reset() throws TransformerException {
    }

    public String getId() {
        return "scripting";
    }

    public String getName() {
        return "Jython Extractor";
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void shutdown() throws PluginException {
    }

    public DigitalObject transform(DigitalObject in, String jsonConfig) throws TransformerException {
        JsonSimple config;
        try {
            config = new JsonSimple(jsonConfig);
        }
        catch (IOException e1) {
            throw new TransformerException((Throwable)e1);
        }
        DigitalObject response = null;
        String scriptType = config.getString("python", new Object[]{"scriptType"});
        String scriptPath = config.getString(null, new Object[]{"scriptPath"});
        if (scriptPath == null) {
            throw new TransformerException("Please specify a scriptPath");
        }
        if ("groovy".equals(scriptType)) {
            Binding binding = new Binding();
            binding.setVariable("digitalObject", (Object)in);
            binding.setVariable("config", (Object)config);
            GroovyShell shell = new GroovyShell(binding);
            try {
                GroovyCodeSource groovyScript = new GroovyCodeSource(new File(scriptPath));
                response = (DigitalObject)shell.evaluate(groovyScript);
            }
            catch (IOException e) {
                throw new TransformerException((Throwable)e);
            }
        } else if ("python".equals(scriptType)) {
            HashMap<String, Object> binding = new HashMap<String, Object>();
            HashMap fields = new HashMap();
            binding.put("digitalObject", in);
            binding.put("config", config);
            PyObject script = this.getPythonObject(scriptPath);
            if (script.__findattr__(PYTHON_SCRIPT_ACTIVATE_METHOD) != null) {
                PyObject result = script.invoke(PYTHON_SCRIPT_ACTIVATE_METHOD, Py.java2py(binding));
                response = (DigitalObject)result;
            } else {
                log.warn("Activation method not found!");
            }
        }
        return response;
    }

    private PyObject getPythonObject(String scriptPath) throws TransformerException {
        PythonInterpreter python = new PythonInterpreter();
        try {
            python.execfile((InputStream)new FileInputStream(new File(scriptPath)), "Processor");
        }
        catch (FileNotFoundException e) {
            throw new TransformerException((Throwable)e);
        }
        PyObject scriptClass = python.get(PYTHON_SCRIPT_CLASS_NAME);
        python.cleanup();
        return scriptClass.__call__();
    }
}

